/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.data.Material;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7923;

public class WorkbenchContructingRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final class_2371<StackedIngredient> materials;
    private final class_1799 result;
    private final boolean notification;

    public WorkbenchContructingRecipe(class_2960 id, class_2371<StackedIngredient> materials, class_1799 result, boolean notification) {
        this.id = id;
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get();
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRecipeSerializers.WORKBENCH_RECIPE.get();
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        return true;
    }

    public class_1799 method_8116(class_1263 container, class_5455 access) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 access) {
        return this.result;
    }

    public boolean method_49188() {
        return this.notification;
    }

    public class_2371<StackedIngredient> getMaterials() {
        return this.materials;
    }

    public int getResultId() {
        return class_1792.method_7880((class_1792)this.result.method_7909());
    }

    public class_1799 getResult() {
        return this.result;
    }

    public static Builder builder(class_1935 result, int count, Function<class_1935, class_184> hasItem, Function<class_6862<class_1792>, class_184> hasTag) {
        return new Builder(result.method_8389(), count, hasItem, hasTag);
    }

    public static class Builder
    implements class_5797 {
        private final class_1792 result;
        private final int count;
        private final Function<class_1935, class_184> hasItem;
        private final Function<class_6862<class_1792>, class_184> hasTag;
        private final List<StackedIngredient> materials = new ArrayList<StackedIngredient>();
        private final class_161.class_162 advancement = class_161.class_162.method_51698();
        private class_7800 category = class_7800.field_40642;
        private boolean showNotification;

        private Builder(class_1792 result, int count, Function<class_1935, class_184> hasItem, Function<class_6862<class_1792>, class_184> hasTag) {
            this.result = result;
            this.count = count;
            this.hasItem = hasItem;
            this.hasTag = hasTag;
        }

        public Builder requiresMaterial(Material<?> material) {
            this.materials.add(material.asStackedIngredient());
            return this.unlockedBy("has_" + material.getName(), material.createTrigger(this.hasItem, this.hasTag));
        }

        public Builder unlockedBy(String name, class_184 trigger) {
            this.advancement.method_709(name, trigger);
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Builder category(class_7800 category) {
            this.category = category;
            return this;
        }

        public Builder showNotification(boolean show) {
            this.showNotification = show;
            return this;
        }

        public class_1792 method_36441() {
            return this.result;
        }

        public void method_17972(Consumer<class_2444> consumer, class_2960 id) {
            this.validate(id);
            this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
            consumer.accept(new Result(id, this.result, this.count, this.materials, this.advancement, id.method_45138("recipes/" + this.category.method_46203() + "/"), this.showNotification));
        }

        private void validate(class_2960 id) {
            if (this.materials.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one material for workbench crafting recipe %s".formatted(id));
            }
            if (this.advancement.method_710().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final List<StackedIngredient> materials;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final boolean notification;

        public Result(class_2960 id, class_1792 result, int count, List<StackedIngredient> materials, class_161.class_162 advancement, class_2960 advancementId, boolean notification) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.materials = materials;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.notification = notification;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)ModRecipeSerializers.WORKBENCH_RECIPE.get();
        }

        public void method_10416(JsonObject object) {
            Serializer.toJson(this, object);
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements class_1865<WorkbenchContructingRecipe> {
        public static void toJson(Result result, JsonObject object) {
            JsonArray materialsArray = new JsonArray();
            for (StackedIngredient ingredient : result.materials) {
                materialsArray.add(ingredient.toJson());
            }
            object.add("materials", (JsonElement)materialsArray);
            if (result.count == 1) {
                object.addProperty("result", class_7923.field_41178.method_10221((Object)result.result).toString());
            } else {
                JsonObject itemObject = new JsonObject();
                itemObject.addProperty("item", class_7923.field_41178.method_10221((Object)result.result).toString());
                itemObject.addProperty("count", (Number)result.count);
                object.add("result", (JsonElement)itemObject);
            }
            object.addProperty("show_notification", Boolean.valueOf(result.notification));
        }

        public WorkbenchContructingRecipe fromJson(class_2960 id, JsonObject object) {
            JsonArray materialArray = class_3518.method_15261((JsonObject)object, (String)"materials");
            class_2371 materials = class_2371.method_10213((int)materialArray.size(), (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialArray.size()).forEach(i -> materials.set(i, (Object)StackedIngredient.fromJson(materialArray.get(i))));
            class_1799 result = Utils.getItemStack(object, "result");
            boolean notification = class_3518.method_15258((JsonObject)object, (String)"show_notification", (boolean)true);
            return new WorkbenchContructingRecipe(id, (class_2371<StackedIngredient>)materials, result, notification);
        }

        public WorkbenchContructingRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            int materialCount = buffer.readInt();
            class_2371 materials = class_2371.method_10213((int)materialCount, (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialCount).forEach(value -> materials.set(value, (Object)StackedIngredient.fromNetwork(buffer)));
            class_1799 result = buffer.method_10819();
            boolean notification = buffer.readBoolean();
            return new WorkbenchContructingRecipe(id, (class_2371<StackedIngredient>)materials, result, notification);
        }

        public void toNetwork(class_2540 buffer, WorkbenchContructingRecipe recipe) {
            buffer.writeInt(recipe.materials.size());
            recipe.materials.forEach(ingredient -> ingredient.toNetwork(buffer));
            buffer.method_10793(recipe.result);
            buffer.writeBoolean(recipe.notification);
        }
    }
}

