/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.data;

import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_6862;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Material<T> {
    protected final String name;
    protected final T t;
    protected final int count;

    public Material(String name, T t, int count) {
        this.name = name;
        this.t = t;
        this.count = count;
    }

    public abstract StackedIngredient asStackedIngredient();

    public abstract class_184 createTrigger(Function<class_1935, class_184> var1, Function<class_6862<class_1792>, class_184> var2);

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.t;
    }

    public int getCount() {
        return this.count;
    }

    public static Material<?> of(class_1935 item, int count) {
        return new ItemValue(item.method_8389(), count);
    }

    public static Material<?> of(String name, class_1935 item, int count) {
        return new ItemValue(name, item.method_8389(), count);
    }

    public static Material<?> of(String name, class_6862<class_1792> tag, int count) {
        return new TagValue(name, tag, count);
    }

    private static final class ItemValue
    extends Material<class_1792> {
        public ItemValue(class_1792 item, int count) {
            super(item.toString(), item, count);
        }

        public ItemValue(String name, class_1792 item, int count) {
            super(name, item, count);
        }

        @Override
        public StackedIngredient asStackedIngredient() {
            return new StackedIngredient(class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)this.t}), this.count);
        }

        @Override
        public class_184 createTrigger(Function<class_1935, class_184> hasItem, Function<class_6862<class_1792>, class_184> hasTag) {
            return hasItem.apply((class_1935)this.t);
        }
    }

    private static final class TagValue
    extends Material<class_6862<class_1792>> {
        public TagValue(String name, class_6862<class_1792> itemTagKey, int count) {
            super(name, itemTagKey, count);
        }

        @Override
        public StackedIngredient asStackedIngredient() {
            return new StackedIngredient(class_1856.method_8106((class_6862)((class_6862)this.t)), this.count);
        }

        @Override
        public class_184 createTrigger(Function<class_1935, class_184> hasItem, Function<class_6862<class_1792>, class_184> hasTag) {
            return hasTag.apply((class_6862<class_1792>)((class_6862)this.t));
        }
    }
}

