/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3312;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public record Mailbox(UUID id, class_5321<class_1937> levelKey, class_2338 pos, MutableObject<UUID> owner, MutableObject<String> customName, Queue<class_1799> queue, MutableBoolean removed, DeliveryService service) implements IMailbox
{
    public static final int MAX_NAME_LENGTH = 32;

    public boolean rename(String customName) {
        if (!customName.isBlank() && customName.length() <= 32) {
            this.customName.setValue((Object)customName);
            this.service.method_80();
            return true;
        }
        return false;
    }

    public boolean hasOwner() {
        return this.owner.getValue() != null;
    }

    public void setOwner(UUID uuid) {
        this.owner.setValue((Object)uuid);
        this.service.method_80();
    }

    void tick() {
        if (this.removed.booleanValue()) {
            return;
        }
        MinecraftServer server = this.service.getServer();
        class_3218 level = server.method_3847(this.levelKey);
        if (level == null || !level.method_8477(this.pos)) {
            return;
        }
        class_2586 class_25862 = level.method_8321(this.pos);
        if (class_25862 instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
            if (blockEntity.getMailbox() != this) {
                this.remove();
                return;
            }
            if (this.queue.isEmpty()) {
                return;
            }
            class_1799 stack = this.queue.peek();
            if (blockEntity.deliverItem(stack)) {
                this.queue.remove();
                this.service.method_80();
            }
        } else {
            this.remove();
        }
    }

    public void remove() {
        this.service.removeMailbox(this);
        this.removed.setValue(true);
    }

    public void writeQueue(class_2487 compound) {
        class_2499 list = new class_2499();
        this.queue.forEach(stack -> list.add((Object)stack.method_7953(new class_2487())));
        compound.method_10566("Queue", (class_2520)list);
    }

    public static Queue<class_1799> readQueueListTag(class_2487 compound) {
        if (compound.method_10573("Queue", 9)) {
            ArrayDeque<class_1799> queue = new ArrayDeque<class_1799>();
            class_2499 list = compound.method_10554("Queue", 10);
            list.forEach(tag -> queue.offer(class_1799.method_7915((class_2487)((class_2487)tag))));
            return queue;
        }
        return new ArrayDeque<class_1799>();
    }

    void spawnQueueIntoLevel() {
        class_3218 level = this.service.getServer().method_3847(this.levelKey);
        if (level != null) {
            Queue<class_1799> queue = this.queue;
            while (!queue.isEmpty()) {
                class_1799 stack = queue.poll();
                class_1264.method_5449((class_1937)level, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), (class_1799)stack);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mailbox mailbox = (Mailbox)obj;
        return this.id.equals(mailbox.id);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Optional<GameProfile> getOwner() {
        class_3312 cache;
        UUID ownerId = (UUID)this.owner.getValue();
        if (ownerId != null && (cache = this.service.getServer().method_3793()) != null) {
            return cache.method_14512(ownerId);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCustomName() {
        return Optional.ofNullable((String)this.customName.getValue());
    }
}

