/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.bounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import java.util.Optional;
import net.minecraft.class_2096;
import org.jetbrains.annotations.Nullable;

public class BoundCodec<T extends Number, B extends class_2096<T>>
implements Codec<B> {
    private final Codec<B> codec;
    private final Codec<B> singleCodec;
    private final Codec<B> minMaxCodec;

    public BoundCodec(Codec<T> typeCodec, BoundsFactory<T, B> factory) {
        this.singleCodec = BoundCodec.createSingle(typeCodec, factory);
        this.minMaxCodec = BoundCodec.createMinMax(typeCodec, factory);
        this.codec = CodecExtras.eitherLeft(Codec.either(this.singleCodec, this.minMaxCodec));
    }

    public <I> DataResult<Pair<B, I>> decode(DynamicOps<I> ops, I input) {
        return this.codec.decode(ops, input);
    }

    public <I> DataResult<I> encode(B input, DynamicOps<I> ops, I prefix) {
        if (input.method_9041()) {
            return DataResult.success((Object)ops.empty());
        }
        if (input.method_9038() != null && input.method_9038().equals(input.method_9042())) {
            return this.singleCodec.encode(input, ops, prefix);
        }
        return this.minMaxCodec.encode(input, ops, prefix);
    }

    private static <T extends Number, B extends class_2096<T>> Codec<B> createSingle(Codec<T> type, BoundsFactory<T, B> factory) {
        return type.comapFlatMap(value -> DataResult.success(factory.create(value, value)), class_2096::method_9038);
    }

    private static <T extends Number, B extends class_2096<T>> Codec<B> createMinMax(Codec<T> type, BoundsFactory<T, B> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)type.optionalFieldOf("min").forGetter(bounds -> Optional.ofNullable(bounds.method_9038())), (App)type.optionalFieldOf("max").forGetter(bounds -> Optional.ofNullable(bounds.method_9042()))).apply((Applicative)instance, (min, max) -> factory.create(min.orElse(null), max.orElse(null))));
    }

    @FunctionalInterface
    public static interface BoundsFactory<T extends Number, R extends class_2096<T>> {
        public R create(@Nullable T var1, @Nullable T var2);
    }
}

