/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.fabric;

import com.teamresourceful.resourcefullib.common.lib.Constants;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public final class FabricResourcePackHandler {
    private static final String RESOURCE_PACK_KEY = "resourcefullib:resourcepack";

    public static void load() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = mod.getMetadata();
            if (!metadata.containsCustomValue(RESOURCE_PACK_KEY)) continue;
            try {
                FabricResourcePackHandler.initMod(mod, metadata);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Resourceful Lib failed to load resource pack for mod: " + metadata.getName());
                e.printStackTrace();
            }
        }
    }

    private static void initMod(ModContainer mod, ModMetadata metadata) {
        CustomValue.CvArray packs = metadata.getCustomValue(RESOURCE_PACK_KEY).getAsArray();
        for (CustomValue pack : packs) {
            FabricResourcePackHandler.loadPack(mod, pack);
        }
    }

    private static void loadPack(ModContainer container, CustomValue value) {
        try {
            String name = value.getAsString();
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(name), (ModContainer)container, (class_2561)class_2561.method_43471((String)("resourcefullib.resourcepack." + name)), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        }
        catch (Exception ignored) {
            CustomValue.CvObject object = value.getAsObject();
            class_2960 id = new class_2960(object.get("name").getAsString());
            String description = object.get("description").getAsString();
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)id, (ModContainer)container, (class_2561)class_2561.method_43471((String)description), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        }
    }
}

