/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.rpgmana;

import com.cleannrooster.rpgmana.api.ManaInstance;
import com.cleannrooster.rpgmana.api.ManaInterface;
import com.cleannrooster.rpgmana.api.SpellcostMixinInterface;
import com.cleannrooster.rpgmana.config.ClientConfig;
import com.cleannrooster.rpgmana.config.ClientConfigWrapper;
import com.cleannrooster.rpgmana.config.ServerConfig;
import com.cleannrooster.rpgmana.config.ServerConfigWrapper;
import com.cleannrooster.rpgmana.effects.BorrowedPower;
import com.cleannrooster.rpgmana.effects.Overdrive;
import com.cleannrooster.rpgmana.effects.Stability;
import com.cleannrooster.rpgmana.enchantment.Archmage;
import com.cleannrooster.rpgmana.enchantment.Lucidity;
import com.cleannrooster.rpgmana.enchantment.ManaStabilized;
import com.cleannrooster.rpgmana.enchantment.Manafused;
import com.cleannrooster.rpgmana.enchantment.MindOverMatter;
import com.cleannrooster.rpgmana.enchantment.Resplendent;
import com.cleannrooster.rpgmana.item.ItemInit;
import com.cleannrooster.rpgmana.loot.Default;
import com.cleannrooster.rpgmana.loot.LootConfig;
import com.cleannrooster.rpgmana.loot.LootHelper;
import com.cleannrooster.rpgmana.mixin.BrewingRecipeRegistryMixin;
import com.cleannrooster.rpgmana.network.ConfigSync;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_7923;
import net.runes.api.RuneItems;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.tinyconfig.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rpgmana
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rpgmana");
    public static final String MOD_ID = "rpgmana";
    public static ConfigManager<LootConfig> lootConfig = new ConfigManager("loot_v2", (Object)Default.loot).builder().setDirectory("rpgmana").sanitize(true).build();
    public static class_1291 BORROWEDPOWER;
    public static class_1291 OVERDRIVE;
    public static class_1291 STABILITY;
    public static class_1842 BORROWEDPOWERPOTION;
    public static class_1842 OVERDRIVEPOTION;
    public static class_1842 STABILITYPOTION;
    public static final class_1887 ARCHMAGE;
    public static final class_1887 LUCIDITY;
    public static final class_1887 MANAFUSED;
    public static final class_1887 MANASTABILIZED;
    public static final class_1887 RESPLENDENT;
    public static final class_1887 MINDOVERMATTER;
    public static ServerConfig config;
    private static class_2540 configSerialized;
    public static ClientConfig clientConfig;
    public static final class_1329 MANA;
    public static final class_1329 MANAREGEN;
    public static final class_1329 MANACOST;

    private static float getManaCost(class_1657 player, Spell spell, SpellCast.Action action, float progress) {
        float channelMultiplier = 1.0f;
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext(channelMultiplier, 1.0f, (class_243)null, new SpellPower.Result(SpellSchools.ARCANE, 0.0, 0.0, 0.0), SpellHelper.impactTargetingMode((Spell)spell));
        float coeff = 0.0f;
        int proj = 1;
        for (Spell.Impact impact : spell.impact) {
            if (impact.action == null || impact.action.damage == null) continue;
            coeff += impact.action.damage.spell_power_coefficient;
        }
        if (spell.impact.length > 0) {
            coeff /= (float)spell.impact.length;
        }
        if (spell.release.target.projectile != null) {
            proj += spell.release.target.projectile.launch_properties.extra_launch_count;
        }
        return ((SpellcostMixinInterface)spell.cost).calculateManaCost() ? (float)Math.max((double)(20.0f * context.total()), (1.0 + 0.05 * (double)(SpellPowerEnchanting.getEnchantmentLevel((class_1887)ARCHMAGE, (class_1309)player, (class_1799)player.method_6047()) - SpellPowerEnchanting.getEnchantmentLevel((class_1887)MANASTABILIZED, (class_1309)player, (class_1799)player.method_6047()))) * 40.0 * (double)context.total() * (double)coeff * (double)proj * (double)((float)player.method_26825((class_1320)MANACOST) * 0.01f)) : ((SpellcostMixinInterface)spell.cost).getManaCost();
    }

    public void onInitialize() {
        lootConfig.refresh();
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        AutoConfig.register(ClientConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        clientConfig = ((ClientConfigWrapper)AutoConfig.getConfigHolder(ClientConfigWrapper.class).getConfig()).client;
        configSerialized = ConfigSync.write(config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> sender.sendPacket(ConfigSync.ID, configSerialized));
        BORROWEDPOWER = new BorrowedPower(class_4081.field_18273, 3694022).method_5566((class_1320)MANA, "ee7652b3-cb11-44c1-9730-befd558a1695", 40.0, class_1322.class_1323.field_6328).method_5566((class_1320)MANAREGEN, "3fe9ec66-b4ca-4be0-a4b4-678366f84865", -0.5, class_1322.class_1323.field_6331);
        OVERDRIVE = new Overdrive(class_4081.field_18273, 11101546).method_5566((class_1320)MANA, "719aaeb0-5d4b-4fcd-a9fa-7ca5d6ef0f1d", -20.0, class_1322.class_1323.field_6328).method_5566((class_1320)MANAREGEN, "4ae741b0-e749-44cd-8e3a-62951910eac5", 0.5, class_1322.class_1323.field_6331).method_5566((class_1320)MANACOST, "95065ab2-71e7-4427-b8a3-97222074608a", 0.5, class_1322.class_1323.field_6331);
        STABILITY = new Stability(class_4081.field_18273, 9154528).method_5566((class_1320)MANAREGEN, "a30c135a-4425-437d-a1cc-5f701e8ebdcc", 0.25, class_1322.class_1323.field_6331).method_5566((class_1320)MANACOST, "dd6b2040-bccb-4a25-a17d-0c65c23a4eea", -0.25, class_1322.class_1323.field_6331);
        BORROWEDPOWERPOTION = new class_1842(new class_1293[]{new class_1293(BORROWEDPOWER, 600, 0)});
        OVERDRIVEPOTION = new class_1842(new class_1293[]{new class_1293(OVERDRIVE, 600, 0)});
        STABILITYPOTION = new class_1842(new class_1293[]{new class_1293(STABILITY, 600, 0)});
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)new class_2960(MOD_ID, "borrowed_power"), (Object)BORROWEDPOWER);
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)new class_2960(MOD_ID, "overdrive"), (Object)OVERDRIVE);
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)new class_2960(MOD_ID, "magical_stability"), (Object)STABILITY);
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "mana"), (Object)MANA);
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "manaregen"), (Object)MANAREGEN);
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "manacost"), (Object)MANACOST);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960(MOD_ID, "inspiration"), (Object)ARCHMAGE);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960(MOD_ID, "lucidity"), (Object)LUCIDITY);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960(MOD_ID, "manafused"), (Object)MANAFUSED);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960(MOD_ID, "manastabilized"), (Object)MANASTABILIZED);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960(MOD_ID, "resplendent"), (Object)RESPLENDENT);
        class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)new class_2960(MOD_ID, "borrowed_power"), (Object)BORROWEDPOWERPOTION);
        class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)new class_2960(MOD_ID, "overdrive"), (Object)OVERDRIVEPOTION);
        class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)new class_2960(MOD_ID, "stability"), (Object)STABILITYPOTION);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960(MOD_ID, "mind_over_matter"), (Object)MINDOVERMATTER);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(class_1847.field_8999, RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.ARCANE), BORROWEDPOWERPOTION);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(class_1847.field_8999, RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.FROST), STABILITYPOTION);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(class_1847.field_8999, RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.FIRE), OVERDRIVEPOTION);
        for (SpellSchool school : SpellSchools.all()) {
            school.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.MULTIPLY, queryArgs -> {
                class_1657 player;
                class_1309 patt0$temp = queryArgs.entity();
                if (patt0$temp instanceof class_1657 && (player = (class_1657)patt0$temp) instanceof SpellCasterEntity) {
                    ManaInterface manaInterface;
                    SpellCasterEntity casterEntity = (SpellCasterEntity)player;
                    if (player instanceof ManaInterface && (manaInterface = (ManaInterface)player).getMana() > 0.1) {
                        List<ManaInstance> list = manaInterface.getManaInstances();
                        double amount = 0.0;
                        for (ManaInstance instance : list) {
                            amount += instance.value;
                        }
                        return amount * 0.01 / 4.0;
                    }
                }
                return 0.0;
            });
        }
        MANA.method_26829(true);
        MANAREGEN.method_26829(true);
        MANACOST.method_26829(true);
        ItemInit.register();
        LOGGER.info("Loading RPGMANA");
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> LootHelper.configure(id, tableBuilder, (LootConfig)Rpgmana.lootConfig.value, ItemInit.entryMap));
    }

    static {
        ARCHMAGE = new Archmage(class_1887.class_1888.field_9088, class_1886.field_9082, class_1304.values());
        LUCIDITY = new Lucidity(class_1887.class_1888.field_9088, class_1886.field_9082, class_1304.values());
        MANAFUSED = new Manafused(class_1887.class_1888.field_9088, class_1886.field_9082, class_1304.values());
        MANASTABILIZED = new ManaStabilized(class_1887.class_1888.field_9088, class_1886.field_9082, class_1304.values());
        RESPLENDENT = new Resplendent(class_1887.class_1888.field_9088, class_1886.field_9082, class_1304.values());
        MINDOVERMATTER = new MindOverMatter(class_1887.class_1888.field_9088, class_1886.field_9082, class_1304.values());
        configSerialized = PacketByteBufs.create();
        MANA = new class_1329("attribute.name.rpgmana.mana", 0.0, 0.0, 999999.0);
        MANAREGEN = new class_1329("attribute.name.rpgmana.manaregen", 4.0, -999999.0, 999999.0);
        MANACOST = new class_1329("attribute.name.rpgmana.manacost", 100.0, 0.0, 999999.0);
    }
}

