/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.config;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.config.DefaultValues;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;

public class SeasonHudClient {
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static ForgeConfigSpec.ConfigValue<Boolean> enableMod;
    private static ForgeConfigSpec.ConfigValue<Location> hudLocation;
    private static ForgeConfigSpec.ConfigValue<Integer> hudX;
    private static ForgeConfigSpec.ConfigValue<Integer> hudY;
    private static ForgeConfigSpec.ConfigValue<Double> hudScale;
    private static ForgeConfigSpec.ConfigValue<Boolean> enableSeasonNameColor;
    private static ForgeConfigSpec.ConfigValue<Integer> springColor;
    private static ForgeConfigSpec.ConfigValue<Integer> summerColor;
    private static ForgeConfigSpec.ConfigValue<Integer> autumnColor;
    private static ForgeConfigSpec.ConfigValue<Integer> winterColor;
    private static ForgeConfigSpec.ConfigValue<Integer> dryColor;
    private static ForgeConfigSpec.ConfigValue<Integer> wetColor;
    private static ForgeConfigSpec.ConfigValue<Boolean> showTropicalSeason;
    private static ForgeConfigSpec.ConfigValue<Boolean> showSubSeason;
    private static ForgeConfigSpec.ConfigValue<ShowDay> showDay;
    private static ForgeConfigSpec.ConfigValue<Boolean> showFertility;
    private static ForgeConfigSpec.ConfigValue<Boolean> enableMinimapIntegration;
    private static ForgeConfigSpec.ConfigValue<Boolean> showDefaultWhenMinimapHidden;
    private static ForgeConfigSpec.ConfigValue<Boolean> journeyMapAboveMap;
    private static ForgeConfigSpec.ConfigValue<Boolean> journeyMapMacOS;

    private SeasonHudClient() {
    }

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("SeasonHUD");
        enableMod = builder.comment("Enable the mod?\n(true/false)\nDefault is true.").define("enable_mod", true);
        builder.push("HUD");
        hudLocation = builder.comment("Where to display the Hud when no minimap is installed.\nDefault is " + String.valueOf((Object)DefaultValues.Client.DEFAULT_HUD_LOCATION) + ".").defineEnum("hud_location", (Enum)DefaultValues.Client.DEFAULT_HUD_LOCATION);
        hudX = builder.comment("The horizontal offset of the HUD when no minimap is installed (in pixels)\n'hudLocation' must be set to 'CUSTOM'\nDefault is 2.").define("hud_x_position", (Object)2);
        hudY = builder.comment("The vertical offset of the HUD when no minimap is installed (in pixels)\n'hudLocation' must be set to 'CUSTOM'\nDefault is 2.").define("hud_y_position", (Object)2);
        hudScale = builder.comment("The scale of the HUD when no minimap is installed.\nDefault is 1.0.").defineInRange("hud_scale", 1.0, 0.5, 10.0);
        builder.push("Colors");
        enableSeasonNameColor = builder.comment("Display the season name in a color?\n(true/false)Default is true.").define("season_name_color", true);
        springColor = builder.comment("The RGB color (decimal) for spring.\n(256 * 256 * r) + (256 * g) + (b) is the formula.\nDefault is 16753595.").defineInRange("spring_color", 16753595, 0, 0xFFFFFF);
        summerColor = builder.comment("The RGB color (decimal) for summer.\n(256 * 256 * r) + (256 * g) + (b) is the formula.\nDefault is 16705834.").defineInRange("summer_color", 16705834, 0, 0xFFFFFF);
        autumnColor = builder.comment("The RGB color (decimal) for autumn.\n(256 * 256 * r) + (256 * g) + (b) is the formula.\nDefault is 12344871.").defineInRange("autumn_color", 12344871, 0, 0xFFFFFF);
        winterColor = builder.comment("The RGB color (decimal) for winter.\n(256 * 256 * r) + (256 * g) + (b) is the formula.\nDefault is 14679292.").defineInRange("winter_color", 0xDFFCFC, 0, 0xFFFFFF);
        dryColor = builder.comment(" The RGB color (decimal) for dry tropical season.\n(256 * 256 * r) + (256 * g) + (b) is the formula.\nDefault is 16745216.").defineInRange("dry_color", 16745216, 0, 0xFFFFFF);
        wetColor = builder.comment("The RGB color (decimal) for wet tropical season.\n(256 * 256 * r) + (256 * g) + (b) is the formula.\nDefault is 2068975.").defineInRange("wet_color", 2068975, 0, 0xFFFFFF);
        builder.pop();
        builder.pop();
        builder.push("Season");
        showTropicalSeason = builder.comment("Show the Tropical seasons (Wet/Dry) in Tropical Biomes.\nWill not change the season behavior in the biomes.\n(true/false)\nDefault is true.").define("enable_show_tropical_season", true);
        showSubSeason = builder.comment("Show sub-season (i.e. Early Winter, Mid Autumn, Late Spring) instead of basic season?\n(true/false)\n Default is true.").define("enable_show_sub_season", true);
        if (Common.fabricSeasonsLoaded()) {
            showDay = builder.comment("Show the current day of the season/sub-season?\nDefault is " + String.valueOf((Object)DefaultValues.Client.DEFAULT_SHOW_DAY) + ".").defineEnum("enable_show_day", (Enum)ShowDay.SHOW_DAY, Arrays.asList(ShowDay.NONE, ShowDay.SHOW_DAY, ShowDay.SHOW_WITH_TOTAL_DAYS, ShowDay.SHOW_WITH_MONTH));
        }
        if (!Common.fabricSeasonsLoaded()) {
            showDay = builder.comment("Show the day of the current Season/Sub-Season?\nDefault is " + String.valueOf((Object)DefaultValues.Client.DEFAULT_SHOW_DAY) + ".").defineEnum("enable_show_day", (Enum)DefaultValues.Client.DEFAULT_SHOW_DAY, Arrays.asList(ShowDay.NONE, ShowDay.SHOW_DAY, ShowDay.SHOW_WITH_TOTAL_DAYS));
        }
        showFertility = builder.comment("Show the current fertility of the biome\nDefault is false.").define("enable_show_fertility", false);
        builder.pop();
        builder.push("Minimap");
        enableMinimapIntegration = builder.comment("Enable integration with minimap mods?\n(true/false)\nDefault is true.").define("enable_minimap_integration", true);
        showDefaultWhenMinimapHidden = builder.comment("Show the default SeasonHUD display when the minimap is hidden?\n(true/false)\nDefault is false.").define("enable_show_minimap_hidden", false);
        builder.push("Journeymap");
        journeyMapAboveMap = builder.comment("Display the season above the JourneyMap minimap, instead of below.\n(true/false)\nDefault is false.").define("enable_above_map", false);
        journeyMapMacOS = builder.comment("Toggle for macOS retina display scaling when using JourneyMap.\nEnable if the season line is rendering around the halfway point of the screen.\n(true/false)\nDefault is false.").define("enable_macOS", false);
        builder.pop();
        builder.pop();
        builder.pop();
    }

    private static <T> T getOrDefault(ForgeConfigSpec.ConfigValue<T> config) {
        if (CLIENT_SPEC.isLoaded()) {
            return (T)config.get();
        }
        return (T)config.getDefault();
    }

    public static boolean getEnableMod() {
        return SeasonHudClient.getOrDefault(enableMod);
    }

    public static void setEnableMod(boolean enable) {
        enableMod.set((Object)enable);
    }

    public static Location getHudLocation() {
        return SeasonHudClient.getOrDefault(hudLocation);
    }

    public static void setHudLocation(Location location) {
        hudLocation.set((Object)location);
    }

    public static int getHudX() {
        return SeasonHudClient.getOrDefault(hudX);
    }

    public static void setHudX(int x) {
        hudX.set((Object)x);
    }

    public static int getHudY() {
        return SeasonHudClient.getOrDefault(hudY);
    }

    public static void setHudY(int y) {
        hudY.set((Object)y);
    }

    public static double getHudScale() {
        return SeasonHudClient.getOrDefault(hudScale);
    }

    public static void setHudScale(double scale) {
        hudScale.set((Object)scale);
    }

    public static boolean getEnableSeasonNameColor() {
        return SeasonHudClient.getOrDefault(enableSeasonNameColor);
    }

    public static void setEnableSeasonNameColor(boolean enable) {
        enableSeasonNameColor.set((Object)enable);
    }

    public static int getSpringColor() {
        return SeasonHudClient.getOrDefault(springColor);
    }

    public static void setSpringColor(int rgbColor) {
        springColor.set((Object)rgbColor);
    }

    public static int getSummerColor() {
        return SeasonHudClient.getOrDefault(summerColor);
    }

    public static void setSummerColor(int rgbColor) {
        summerColor.set((Object)rgbColor);
    }

    public static int getAutumnColor() {
        return SeasonHudClient.getOrDefault(autumnColor);
    }

    public static void setAutumnColor(int rgbColor) {
        autumnColor.set((Object)rgbColor);
    }

    public static int getWinterColor() {
        return SeasonHudClient.getOrDefault(winterColor);
    }

    public static void setWinterColor(int rgbColor) {
        winterColor.set((Object)rgbColor);
    }

    public static int getDryColor() {
        return SeasonHudClient.getOrDefault(dryColor);
    }

    public static void setDryColor(int rgbColor) {
        dryColor.set((Object)rgbColor);
    }

    public static int getWetColor() {
        return SeasonHudClient.getOrDefault(wetColor);
    }

    public static void setWetColor(int rgbColor) {
        wetColor.set((Object)rgbColor);
    }

    public static boolean getShowTropicalSeason() {
        return SeasonHudClient.getOrDefault(showTropicalSeason);
    }

    public static void setShowTropicalSeason(boolean enable) {
        showTropicalSeason.set((Object)enable);
    }

    public static boolean getShowSubSeason() {
        return SeasonHudClient.getOrDefault(showSubSeason);
    }

    public static void setShowSubSeason(boolean enable) {
        showSubSeason.set((Object)enable);
    }

    public static ShowDay getShowDay() {
        return SeasonHudClient.getOrDefault(showDay);
    }

    public static void setShowDay(ShowDay showDay) {
        SeasonHudClient.showDay.set((Object)showDay);
    }

    public static boolean getShowFertility() {
        return SeasonHudClient.getOrDefault(showFertility);
    }

    public static void setShowFertility(boolean showFertility) {
        SeasonHudClient.showFertility.set((Object)showFertility);
    }

    public static boolean getShowDefaultWhenMinimapHidden() {
        return SeasonHudClient.getOrDefault(showDefaultWhenMinimapHidden);
    }

    public static void setShowDefaultWhenMinimapHidden(boolean enable) {
        showDefaultWhenMinimapHidden.set((Object)enable);
    }

    public static boolean getEnableMinimapIntegration() {
        return SeasonHudClient.getOrDefault(enableMinimapIntegration);
    }

    public static void setEnableMinimapIntegration(boolean enable) {
        enableMinimapIntegration.set((Object)enable);
    }

    public static boolean getJourneyMapAboveMap() {
        return SeasonHudClient.getOrDefault(journeyMapAboveMap);
    }

    public static void setJourneyMapAboveMap(boolean enable) {
        journeyMapAboveMap.set((Object)enable);
    }

    public static boolean getJourneyMapMacOS() {
        return SeasonHudClient.getOrDefault(journeyMapMacOS);
    }

    public static void setJourneyMapMacOS(boolean enable) {
        journeyMapMacOS.set((Object)enable);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SeasonHudClient.setupConfig(builder);
        CLIENT_SPEC = builder.build();
    }
}

