/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.khajiitos.servercountryflags.common.APITimeoutManager;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.util.APIResponse;
import me.khajiitos.servercountryflags.common.util.FlagRenderInfo;
import me.khajiitos.servercountryflags.common.util.InvalidAPIResponseException;
import me.khajiitos.servercountryflags.common.util.LocationInfo;
import me.khajiitos.servercountryflags.common.util.NetworkChangeDetector;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6368;
import net.minecraft.class_6369;
import net.minecraft.class_6371;
import net.minecraft.class_639;
import net.minecraft.class_641;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCountryFlags {
    public static final String MOD_ID = "servercountryflags";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"servercountryflags");
    public static final String API_NAME = "http://ip-api.com/json/";
    public static final int API_FIELDS = 541395;
    public static String apiLanguage = null;
    public static class_641 serverList;
    public static HashMap<String, APIResponse> servers;
    public static HashMap<String, Float> flagAspectRatios;
    public static Set<String> unknownCountryCodes;
    public static class_6371 redirectResolver;
    public static LocationInfo localLocation;

    static <T> T last(T[] arr) {
        return arr[arr.length - 1];
    }

    public static void init() {
        Config.init();
        NetworkChangeDetector.check();
        class_310.method_1551().execute(() -> {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            Map resourceLocations = resourceManager.method_14488("textures/flags", path -> true);
            Thread flagThread = new Thread(() -> {
                for (Map.Entry entry : resourceLocations.entrySet()) {
                    if (!((class_2960)entry.getKey()).method_12836().equals(MOD_ID)) continue;
                    try {
                        if (entry.getValue() == null) {
                            LOGGER.error("Failed to load resource " + ((class_2960)entry.getKey()).method_12832());
                            continue;
                        }
                        InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                        try {
                            class_1011 image = class_1011.method_4309((InputStream)inputStream);
                            String code = ServerCountryFlags.last(((class_2960)entry.getKey()).method_12832().split("/"));
                            code = code.substring(0, code.length() - 4);
                            flagAspectRatios.put(code, Float.valueOf((float)image.method_4307() / (float)image.method_4323()));
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            });
            flagThread.setName("Flag load thread");
            flagThread.start();
        });
        ServerCountryFlags.updateLocalLocationInfo();
    }

    public static void updateAPILanguage(String language) {
        String oldApiLanguage = apiLanguage;
        if (Config.cfg.forceEnglish) {
            apiLanguage = null;
        } else if (language != null) {
            apiLanguage = language.startsWith("en") ? null : (language.startsWith("de") ? "de" : (language.startsWith("es") ? "es" : (language.startsWith("pt") ? "pt-BR" : (language.startsWith("fr") ? "fr" : (language.startsWith("ja") ? "ja" : (language.startsWith("zn") ? "zn-CN" : (language.startsWith("ru") ? "ru" : null)))))));
        }
        if (!Objects.equals(apiLanguage, oldApiLanguage)) {
            servers.clear();
        }
    }

    @NotNull
    public static APIResponse getAPIResponse(String ip) {
        if (APITimeoutManager.isOnCooldown()) {
            return new APIResponse(APIResponse.Status.COOLDOWN, null);
        }
        String apiUrlStr = API_NAME + ip + "?fields=541395";
        if (apiLanguage != null) {
            apiUrlStr = apiUrlStr + "&lang=" + apiLanguage;
        }
        try {
            APITimeoutManager.incrementRequestsSent();
            URL apiUrl = new URL(apiUrlStr);
            HttpURLConnection con = (HttpURLConnection)apiUrl.openConnection();
            con.setConnectTimeout(3000);
            int requestsLeft = con.getHeaderFieldInt("X-Rl", -1);
            int secondsLeft = con.getHeaderFieldInt("X-Ttl", -1);
            APITimeoutManager.decrementRequestsSent();
            if (requestsLeft != -1 && secondsLeft != -1) {
                APITimeoutManager.setRequestsLeft(requestsLeft - APITimeoutManager.getRequestsSent());
                APITimeoutManager.setSecondsLeftUntilReset(secondsLeft);
            }
            if (con.getResponseCode() == 429) {
                return new APIResponse(APIResponse.Status.COOLDOWN, null);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            return new APIResponse(APIResponse.Status.SUCCESS, new LocationInfo(jsonElement));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Malformed API Url: " + apiUrlStr);
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unknown host - no internet?");
        }
        catch (IOException | InvalidAPIResponseException e) {
            LOGGER.error(e.getMessage());
        }
        APITimeoutManager.decrementRequestsSent();
        return new APIResponse(APIResponse.Status.UNKNOWN, null);
    }

    public static boolean isIpLocal(InetAddress address) {
        return address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || address.isAnyLocalAddress();
    }

    public static void updateServerLocationInfo(String serverAddress) {
        String cleanServerAddress = serverAddress.startsWith("raknet;") ? serverAddress.substring("raknet;".length()) : (serverAddress.startsWith("raknetl;") ? serverAddress.substring("raknetl;".length()) : serverAddress);
        CompletableFuture.runAsync(() -> {
            Optional resolvedAddress;
            Optional redirect;
            class_639 address = class_639.method_2950((String)cleanServerAddress);
            if (Config.cfg.resolveRedirects && (redirect = redirectResolver.lookupRedirect(address)).isPresent()) {
                address = (class_639)redirect.get();
            }
            if ((resolvedAddress = class_6369.field_33744.resolve(address)).isPresent()) {
                InetSocketAddress socketAddress = ((class_6368)resolvedAddress.get()).method_36902();
                String stringHostAddress = ServerCountryFlags.isIpLocal(socketAddress.getAddress()) ? "" : socketAddress.getAddress().getHostAddress();
                APIResponse response = ServerCountryFlags.getAPIResponse(stringHostAddress);
                APIResponse oldResponse = servers.get(serverAddress);
                if (oldResponse == null || oldResponse.unknown() || !response.unknown() || oldResponse.cooldown() && response.locationInfo() != null) {
                    servers.put(serverAddress, response);
                }
            }
        });
    }

    public static void updateLocalLocationInfo() {
        CompletableFuture.runAsync(() -> {
            APIResponse response = ServerCountryFlags.getAPIResponse("");
            if (response.locationInfo() != null) {
                localLocation = response.locationInfo();
                for (APIResponse serverResponse : servers.values()) {
                    if (serverResponse.cooldown()) continue;
                    serverResponse.locationInfo().updateDistanceFromLocal();
                }
            }
        });
    }

    public static FlagRenderInfo getFlagRenderInfo(APIResponse apiResponse) {
        double aspectRatio;
        String countryCode;
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (apiResponse == null || apiResponse.unknown()) {
            if (!Config.cfg.displayUnknownFlag) {
                return null;
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"servercountryflags.locationInfo.unknown"));
            countryCode = "unknown";
            aspectRatio = 1.5;
        } else if (apiResponse.cooldown()) {
            if (!Config.cfg.displayCooldownFlag) {
                return null;
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"servercountryflags.locationInfo.cooldown"));
            countryCode = "timeout";
            aspectRatio = 1.5;
        } else {
            double distanceFromLocal;
            LocationInfo locationInfo = apiResponse.locationInfo();
            if (flagAspectRatios.containsKey(locationInfo.countryCode)) {
                countryCode = locationInfo.countryCode;
                aspectRatio = flagAspectRatios.get(countryCode).floatValue();
            } else {
                if (!unknownCountryCodes.contains(locationInfo.countryCode)) {
                    LOGGER.error("Unknown country code: " + locationInfo.countryCode);
                    unknownCountryCodes.add(locationInfo.countryCode);
                }
                if (Config.cfg.displayUnknownFlag) {
                    countryCode = "unknown";
                    aspectRatio = 1.5;
                } else {
                    return null;
                }
            }
            tooltip.add((class_2561)class_2561.method_43470((String)((String)(Config.cfg.showDistrict && !locationInfo.districtName.equals("") ? locationInfo.districtName + ", " : "") + locationInfo.cityName + ", " + locationInfo.countryName)));
            if (Config.cfg.showISP && !locationInfo.ispName.equals("")) {
                tooltip.add((class_2561)class_2561.method_43469((String)"servercountryflags.locationInfo.isp", (Object[])new Object[]{locationInfo.ispName}));
            }
            if (Config.cfg.showDistance && (distanceFromLocal = locationInfo.getDistanceFromLocal(Config.cfg.useKm)) != -1.0) {
                tooltip.add((class_2561)class_2561.method_43469((String)"servercountryflags.locationInfo.distance", (Object[])new Object[]{(int)distanceFromLocal, class_2561.method_43471((String)(Config.cfg.useKm ? "servercountryflags.locationInfo.km" : "servercountryflags.locationInfo.mi"))}).method_27692(class_124.field_1056));
            }
        }
        return new FlagRenderInfo(countryCode, aspectRatio, tooltip);
    }

    static {
        servers = new HashMap();
        flagAspectRatios = new HashMap();
        unknownCountryCodes = new HashSet<String>();
        redirectResolver = class_6371.method_36909();
        localLocation = null;
    }
}

