/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.config;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.config.ConfigEntry;
import me.khajiitos.servercountryflags.common.config.Constraints;
import me.khajiitos.servercountryflags.common.util.Color;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ClothConfigScreenMaker {
    public static class_437 create(class_310 minecraft, class_437 parent) {
        return ClothConfigScreenMaker.create(parent);
    }

    public static class_437 create(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"servercountryflags.config.header")).setSavingRunnable(Config::save);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (Field field : Config.Values.class.getDeclaredFields()) {
            ClothConfigScreenMaker.addEntryForField(field, builder, entryBuilder);
        }
        return builder.build();
    }

    public static void addEntryForField(Field field, ConfigBuilder configBuilder, ConfigEntryBuilder entryBuilder) {
        ConfigEntry annotation = field.getAnnotation(ConfigEntry.class);
        if (annotation == null) {
            return;
        }
        ConfigCategory category = configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)annotation.configCategory()));
        try {
            Object object;
            String fieldName = field.getName();
            class_5250 name = class_2561.method_43471((String)String.format("servercountryflags.config.field.%s.name", fieldName));
            class_5250 description = class_2561.method_43471((String)String.format("servercountryflags.config.field.%s.description", fieldName));
            if (field.getType() == Integer.TYPE) {
                Optional<Constraints> constraints = Arrays.stream(annotation.constraints()).findFirst();
                category.addEntry((AbstractConfigListEntry)((IntFieldBuilder)((IntFieldBuilder)entryBuilder.startIntField((class_2561)name, field.getInt(Config.cfg)).setTooltip(new class_2561[]{description}).setDefaultValue(field.getInt(Config.DEFAULT)).setSaveConsumer(newValue -> ClothConfigScreenMaker.setCfgInt(field, newValue)).setMin(constraints.isPresent() ? Integer.valueOf(constraints.get().minValue()) : null)).setMax(constraints.isPresent() ? Integer.valueOf(constraints.get().maxValue()) : null)).build());
            } else if (field.getType() == Boolean.TYPE) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)name, field.getBoolean(Config.cfg)).setTooltip(new class_2561[]{description}).setDefaultValue(field.getBoolean(Config.DEFAULT)).setSaveConsumer(newValue -> ClothConfigScreenMaker.setCfgBoolean(field, newValue)).build());
            } else if (field.getType() == String.class) {
                if (annotation.stringValues().length != 0) {
                    category.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((class_2561)name, (String)field.get(Config.cfg), !annotation.stringValuesTranslatable() ? class_2561::method_43470 : s -> class_2561.method_43471((String)String.format("servercountryflags.config.field.%s.value.%s", fieldName, s))).setSelections(List.of(annotation.stringValues())).setTooltip(new class_2561[]{description}).setSuggestionMode(true).setDefaultValue((Object)((String)field.get(Config.DEFAULT))).setSaveConsumer(newValue -> ClothConfigScreenMaker.setCfgString(field, newValue)).build());
                } else {
                    category.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)name, (String)field.get(Config.cfg)).setTooltip(new class_2561[]{description}).setDefaultValue((String)field.get(Config.DEFAULT)).setSaveConsumer(newValue -> ClothConfigScreenMaker.setCfgString(field, newValue)).build());
                }
            } else if (field.getType() == Color.class) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startColorField((class_2561)name, ((Color)field.get(Config.cfg)).toARGB()).setAlphaMode(true).setTooltip(new class_2561[]{description}).setDefaultValue(((Color)field.get(Config.DEFAULT)).toARGB()).setSaveConsumer(newValue -> ClothConfigScreenMaker.setCfgColor(field, newValue)).build());
            } else if (field.getType().isEnum() && (object = field.get(Config.cfg)) instanceof Enum) {
                Enum enumValue = (Enum)object;
                category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)name, enumValue.getDeclaringClass(), enumValue).setEnumNameProvider(anEnum -> class_2561.method_43471((String)String.format("servercountryflags.config.field.%s.value.%s", fieldName, anEnum.toString()))).setTooltip(new class_2561[]{description}).setDefaultValue((Enum)field.get(Config.DEFAULT)).setSaveConsumer(newValue -> ClothConfigScreenMaker.setCfgEnum(field, newValue)).build());
            }
        }
        catch (IllegalAccessException e) {
            ServerCountryFlags.LOGGER.error("Failed to access a field", (Throwable)e);
        }
    }

    private static void setCfgInt(Field field, int value) {
        try {
            field.setInt(Config.cfg, value);
        }
        catch (IllegalAccessException e) {
            ServerCountryFlags.LOGGER.error("Failed to set value to a field", (Throwable)e);
        }
    }

    private static void setCfgBoolean(Field field, boolean value) {
        try {
            field.setBoolean(Config.cfg, value);
        }
        catch (IllegalAccessException e) {
            ServerCountryFlags.LOGGER.error("Failed to set value to a field", (Throwable)e);
        }
    }

    private static void setCfgString(Field field, String string) {
        try {
            field.set(Config.cfg, string);
        }
        catch (IllegalAccessException e) {
            ServerCountryFlags.LOGGER.error("Failed to set value to a field", (Throwable)e);
        }
    }

    private static void setCfgColor(Field field, int color) {
        try {
            field.set(Config.cfg, Color.fromARGB(color));
        }
        catch (IllegalAccessException e) {
            ServerCountryFlags.LOGGER.error("Failed to set value to a field", (Throwable)e);
        }
    }

    private static void setCfgEnum(Field field, Enum<?> enumValue) {
        try {
            field.set(Config.cfg, enumValue);
        }
        catch (IllegalAccessException e) {
            ServerCountryFlags.LOGGER.error("Failed to set value to a field", (Throwable)e);
        }
    }
}

