/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.mixin.serverbrowser;

import com.epherical.serverbrowser.client.list.ServerBrowserList;
import com.epherical.serverbrowser.client.screen.ServerBrowserScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.mixin.serverbrowser.ServerBrowserScreenAccessor;
import me.khajiitos.servercountryflags.common.util.APIResponse;
import me.khajiitos.servercountryflags.common.util.FlagPosition;
import me.khajiitos.servercountryflags.common.util.FlagRenderInfo;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_642;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={ServerBrowserList.BrowsedEntry.class})
public class BrowsedEntryMixin {
    @Shadow(remap=false)
    private class_642 serverData;
    @Shadow(remap=false)
    @Final
    private ServerBrowserScreen screen;
    @Shadow
    @Final
    private class_310 minecraft;

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;III)I", ordinal=0), method={"render"}, index=2)
    public int serverNameX(int oldX) {
        APIResponse apiResponse;
        FlagRenderInfo renderInfo;
        if (!Config.cfg.serverBrowserIntegration) {
            return oldX;
        }
        if (Config.cfg.flagPosition == FlagPosition.BEHIND_NAME && (renderInfo = ServerCountryFlags.getFlagRenderInfo(apiResponse = ServerCountryFlags.servers.get(this.serverData.field_3761))) != null) {
            return oldX + (int)(renderInfo.flagAspectRatio() * 8.0) + 3;
        }
        return oldX;
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void render(class_332 guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo info) {
        int startingX;
        if (!Config.cfg.serverBrowserIntegration) {
            return;
        }
        APIResponse apiResponse = ServerCountryFlags.servers.get(this.serverData.field_3761);
        FlagRenderInfo flagRenderInfo = ServerCountryFlags.getFlagRenderInfo(apiResponse);
        if (flagRenderInfo == null) {
            return;
        }
        if (Config.cfg.flagPosition == FlagPosition.TOOLTIP_SERVER_NAME) {
            int serverNameStartX = x + 35;
            int serverNameStartY = y + 1;
            int serverNameWidth = this.minecraft.field_1772.method_1727(this.serverData.field_3752);
            int serverNameHeight = 8;
            if (mouseX >= serverNameStartX && mouseX <= serverNameStartX + serverNameWidth && mouseY >= serverNameStartY && mouseY <= serverNameStartY + serverNameHeight) {
                this.screen.setToolTip(flagRenderInfo.tooltip());
            }
            return;
        }
        if (Config.cfg.flagPosition == FlagPosition.TOOLTIP_PING) {
            return;
        }
        int height = Config.cfg.flagPosition == FlagPosition.BEHIND_NAME ? 8 : 12;
        int width = (int)(flagRenderInfo.flagAspectRatio() * (double)height);
        int startingY = switch (Config.cfg.flagPosition) {
            case FlagPosition.LEFT -> {
                startingX = x - width - 6;
                yield y + entryHeight / 2 - height / 2;
            }
            case FlagPosition.RIGHT -> {
                startingX = x + entryWidth + 10;
                yield y + entryHeight / 2 - height / 2;
            }
            case FlagPosition.BEHIND_NAME -> {
                startingX = x + 35;
                yield y + 1;
            }
            default -> {
                startingX = x + entryWidth - width - 6;
                yield y + entryHeight - height - 4;
            }
        };
        class_2960 textureId = new class_2960("servercountryflags", "textures/flags/" + flagRenderInfo.countryCode() + ".png");
        RenderSystem.enableBlend();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_25291(textureId, startingX, startingY, 100, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.method_51448().method_22909();
        if (Config.cfg.flagBorder) {
            guiGraphics.method_49601(startingX - 1, startingY - 1, width + 2, height + 2, Config.cfg.borderColor.toARGB());
        }
        RenderSystem.disableBlend();
        if (mouseX >= startingX && mouseX <= startingX + width && mouseY >= startingY && mouseY <= startingY + height) {
            this.screen.setToolTip(flagRenderInfo.tooltip());
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/epherical/serverbrowser/client/screen/ServerBrowserScreen;setToolTip(Ljava/util/List;)V", ordinal=1, shift=At.Shift.AFTER)}, method={"render"})
    public void onSetTooltip(class_332 guiGraphics, int $$1, int $$2, int $$3, int $$4, int $$5, int $$6, int $$7, boolean $$8, float $$9, CallbackInfo ci) {
        if (Config.cfg.flagPosition == FlagPosition.TOOLTIP_PING) {
            ServerBrowserScreenAccessor accessor = (ServerBrowserScreenAccessor)this.screen;
            APIResponse apiResponse = ServerCountryFlags.servers.get(this.serverData.field_3761);
            FlagRenderInfo flagRenderInfo = ServerCountryFlags.getFlagRenderInfo(apiResponse);
            if (flagRenderInfo == null) {
                return;
            }
            ArrayList<class_2561> newTooltip = new ArrayList<class_2561>(accessor.getToolTip());
            newTooltip.add((class_2561)class_2561.method_43470((String)" "));
            newTooltip.addAll(flagRenderInfo.tooltip());
            this.screen.setToolTip(newTooltip);
        }
    }
}

