/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.util.APIResponse;
import me.khajiitos.servercountryflags.common.util.LocationInfo;
import me.khajiitos.servercountryflags.common.util.NetworkChangeDetector;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class ServerMapScreen
extends class_437 {
    public static final class_2960 MAP_TEXTURE = new class_2960("servercountryflags", "textures/misc/map.jpg");
    public static final class_2960 POINT_TEXTURE = new class_2960("servercountryflags", "textures/misc/point.png");
    public static final class_2960 POINT_HOVERED_TEXTURE = new class_2960("servercountryflags", "textures/misc/point_hovered.png");
    public static final class_2960 POINT_HOME_TEXTURE = new class_2960("servercountryflags", "textures/misc/point_home.png");
    public static final double MAP_TEXTURE_ASPECT = 2.0;
    public static final double POINT_TEXTURE_ASPECT = 0.6976127320954907;
    public static final double ZOOM_STRENGTH = 0.1;
    private int mapStartX;
    private int mapStartY;
    private int mapWidth;
    private int mapHeight;
    private final class_437 parent;
    private final ArrayList<Point> points = new ArrayList();
    private double zoomedAreaStartX = 0.0;
    private double zoomedAreaStartY = 0.0;
    private double zoomedAreaWidth = 1.0;
    private double zoomedAreaHeight = 1.0;
    private boolean movingMap = false;
    private double movingMapLastX = -1.0;
    private double movingMapLastY = -1.0;

    public ServerMapScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"servercountryflags.servermap.title"));
        this.parent = parent;
        if (Config.cfg.showHomeOnMap && ServerCountryFlags.localLocation != null) {
            this.addPoint(null, ServerCountryFlags.localLocation);
        }
        for (Map.Entry<String, APIResponse> entry : ServerCountryFlags.servers.entrySet()) {
            if (entry.getValue().locationInfo() == null) continue;
            this.addPoint(entry.getKey(), entry.getValue().locationInfo());
        }
    }

    public Point getPoint(double lon, double lat) {
        for (Point point : this.points) {
            if (point.locationInfo.longitude != lon || point.locationInfo.latitude != lat) continue;
            return point;
        }
        return null;
    }

    public double clampDouble(double value, double min, double max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        if (this.movingMap) {
            double deltaX = (this.movingMapLastX - mouseX) / (double)this.mapWidth * this.zoomedAreaWidth;
            double deltaY = (this.movingMapLastY - mouseY) / (double)this.mapHeight * this.zoomedAreaHeight;
            this.movingMapLastX = mouseX;
            this.movingMapLastY = mouseY;
            this.zoomedAreaStartX = this.clampDouble(this.zoomedAreaStartX + deltaX, 0.0, 1.0 - this.zoomedAreaWidth);
            this.zoomedAreaStartY = this.clampDouble(this.zoomedAreaStartY + deltaY, 0.0, 1.0 - this.zoomedAreaHeight);
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.movingMap = false;
            this.movingMapLastX = -1.0;
            this.movingMapLastY = -1.0;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.mapStartX && mouseX <= (double)(this.mapStartX + this.mapWidth) && mouseY >= (double)this.mapStartY && mouseY <= (double)(this.mapStartY + this.mapHeight)) {
            this.movingMap = true;
            this.movingMapLastX = mouseX;
            this.movingMapLastY = mouseY;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (mouseX >= (double)this.mapStartX && mouseX <= (double)(this.mapStartX + this.mapWidth) && mouseY >= (double)this.mapStartY && mouseY <= (double)(this.mapStartY + this.mapHeight)) {
            double oldWidth = this.zoomedAreaWidth;
            double oldHeight = this.zoomedAreaHeight;
            this.zoomedAreaWidth = this.clampDouble(this.zoomedAreaWidth - amount * 0.1, 0.05, 1.0);
            this.zoomedAreaHeight = this.clampDouble(this.zoomedAreaHeight - amount * 0.1, 0.05, 1.0);
            double widthDelta = oldWidth - this.zoomedAreaWidth;
            double heightDelta = oldHeight - this.zoomedAreaHeight;
            this.zoomedAreaStartX = this.clampDouble(this.zoomedAreaStartX + (mouseX - (double)this.mapStartX) / (double)this.mapWidth * widthDelta, 0.0, 1.0 - this.zoomedAreaWidth);
            this.zoomedAreaStartY = this.clampDouble(this.zoomedAreaStartY + (mouseY - (double)this.mapStartY) / (double)this.mapHeight * heightDelta, 0.0, 1.0 - this.zoomedAreaHeight);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void addPoint(String name, LocationInfo locationInfo) {
        Point point = this.getPoint(locationInfo.longitude, locationInfo.latitude);
        if (point != null) {
            point.addServer(name);
        } else {
            this.points.add(new Point(name, locationInfo));
        }
    }

    public void method_25426() {
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"selectServer.refresh"), button -> {
            this.method_37067();
            this.method_25426();
            if (ServerCountryFlags.serverList == null) {
                return;
            }
            if (Config.cfg.reloadOnRefresh) {
                this.points.clear();
                ServerCountryFlags.servers.clear();
                ServerCountryFlags.localLocation = null;
            }
            if (ServerCountryFlags.localLocation == null || NetworkChangeDetector.check()) {
                ServerCountryFlags.updateLocalLocationInfo();
            }
            for (int i = 0; i < ServerCountryFlags.serverList.method_2984(); ++i) {
                if (ServerCountryFlags.servers.containsKey(ServerCountryFlags.serverList.method_2982((int)i).field_3761)) continue;
                ServerCountryFlags.updateServerLocationInfo(ServerCountryFlags.serverList.method_2982((int)i).field_3761);
            }
        }).method_46434(this.field_22789 / 2 - 105, this.field_22790 - 26, 100, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.back"), button -> class_310.method_1551().method_1507(this.parent)).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 26, 100, 20).method_46431());
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_35719(this.field_22793, this.method_25440().method_30937(), this.field_22789 / 2, 12, -1);
        context.method_25294(0, 32, this.field_22789, this.field_22790 - 32, -1442840576);
        this.mapHeight = this.field_22790 - 64;
        this.mapWidth = (int)((double)this.mapHeight * 2.0);
        if (this.mapWidth > this.field_22789) {
            this.mapWidth = this.field_22789;
            this.mapHeight = (int)((double)this.mapWidth / 2.0);
        }
        this.mapStartX = this.field_22789 / 2 - this.mapWidth / 2;
        this.mapStartY = 32 + ((this.field_22790 - 64) / 2 - this.mapHeight / 2);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        context.method_25293(MAP_TEXTURE, this.mapStartX, this.mapStartY, this.mapWidth, this.mapHeight, (float)((double)this.mapWidth * this.zoomedAreaStartX), (float)((double)this.mapHeight * this.zoomedAreaStartY), (int)((double)this.mapWidth * this.zoomedAreaWidth), (int)((double)this.mapHeight * this.zoomedAreaHeight), this.mapWidth, this.mapHeight);
        Point hoveredPoint = null;
        int pointHeight = this.mapHeight / 20;
        int pointWidth = (int)((double)pointHeight * 0.6976127320954907);
        for (int i = this.points.size() - 1; i >= 0; --i) {
            Point point = this.points.get(i);
            Coordinates coords = this.latlonToPos(point.locationInfo.latitude, point.locationInfo.longitude, this.mapWidth, this.mapHeight);
            int pointStartX = this.mapStartX + coords.x - pointWidth / 2;
            int pointStartY = this.mapStartY + coords.y - pointHeight;
            if (coords.x < 0 || coords.x > this.mapWidth - pointWidth / 2 || coords.y < pointHeight || coords.y > this.mapHeight || mouseX < pointStartX || mouseX > pointStartX + pointWidth || mouseY < pointStartY || mouseY > pointStartY + pointHeight) continue;
            hoveredPoint = point;
            break;
        }
        for (Point point : this.points) {
            point.render(context, hoveredPoint == point);
        }
        if (hoveredPoint != null) {
            this.method_47414(hoveredPoint.getTooltip());
        }
        RenderSystem.disableBlend();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    private static boolean doesServerListHaveServer(String serverIp) {
        if (ServerCountryFlags.serverList == null) {
            return false;
        }
        return ServerCountryFlags.serverList.method_44295(serverIp) != null;
    }

    public void method_25393() {
        super.method_25393();
        this.points.clear();
        if (Config.cfg.showHomeOnMap && ServerCountryFlags.localLocation != null) {
            this.addPoint(null, ServerCountryFlags.localLocation);
        }
        for (Map.Entry<String, APIResponse> entry : ServerCountryFlags.servers.entrySet()) {
            if (!ServerMapScreen.doesServerListHaveServer(entry.getKey()) || entry.getValue().locationInfo() == null) continue;
            this.addPoint(entry.getKey(), entry.getValue().locationInfo());
        }
    }

    private Coordinates latlonToPos(double lat, double lon, int width, int height) {
        int x = (int)((double)width * (((180.0 + lon) / 360.0 - this.zoomedAreaStartX) / this.zoomedAreaHeight));
        int y = (int)((double)height * (((90.0 - lat) / 180.0 - this.zoomedAreaStartY) / this.zoomedAreaWidth));
        return new Coordinates(x, y);
    }

    public class Point {
        LocationInfo locationInfo;
        List<String> servers = new ArrayList<String>();
        public boolean hasHome;

        public Point(String beginningName, LocationInfo beginningLocationInfo) {
            this.locationInfo = beginningLocationInfo;
            this.addServer(beginningName);
        }

        public void addServer(String name) {
            if (name == null) {
                this.hasHome = true;
            }
            this.servers.add(name);
        }

        public List<class_5481> getTooltip() {
            ArrayList<class_5481> list = new ArrayList<class_5481>();
            list.add(class_2561.method_43470((String)((String)(Config.cfg.showDistrict && !this.locationInfo.districtName.equals("") ? this.locationInfo.districtName + ", " : "") + this.locationInfo.cityName + ", " + this.locationInfo.countryName)).method_27692(class_124.field_1067).method_30937());
            list.add(class_2561.method_30163(null).method_30937());
            for (String server : this.servers) {
                if (server == null) {
                    list.add(class_2561.method_43471((String)"servercountryflags.servermap.home").method_27692(class_124.field_1067).method_30937());
                    continue;
                }
                list.add(class_2561.method_43470((String)server).method_30937());
            }
            return list;
        }

        private void render(class_332 context, boolean hovered) {
            Coordinates coords = ServerMapScreen.this.latlonToPos(this.locationInfo.latitude, this.locationInfo.longitude, ServerMapScreen.this.mapWidth, ServerMapScreen.this.mapHeight);
            int pointHeight = ServerMapScreen.this.mapHeight / 20;
            int pointWidth = (int)((double)pointHeight * 0.6976127320954907);
            int pointStartX = ServerMapScreen.this.mapStartX + coords.x - pointWidth / 2;
            int pointStartY = ServerMapScreen.this.mapStartY + coords.y - pointHeight;
            if (coords.x < 0 || coords.x > ServerMapScreen.this.mapWidth - pointWidth / 2 || coords.y < pointHeight || coords.y > ServerMapScreen.this.mapHeight) {
                return;
            }
            class_2960 texture = POINT_TEXTURE;
            if (this.hasHome) {
                texture = POINT_HOME_TEXTURE;
            } else if (hovered) {
                texture = POINT_HOVERED_TEXTURE;
            }
            context.method_25290(texture, pointStartX, pointStartY, 0.0f, 0.0f, pointWidth, pointHeight, pointWidth, pointHeight);
        }
    }

    public static class Coordinates {
        public int x;
        public int y;

        public Coordinates(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

