/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.shadowmounts_common_forge.mixin;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.natamus.shadowmounts_common_forge.rendering.ShadowMountRenderFunctions;
import com.natamus.shadowmounts_common_forge.util.Util;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class}, priority=1001)
public abstract class LivingEntityRendererMixin {
    @Shadow
    protected EntityModel<LivingEntity> f_115290_;
    @Shadow
    protected final List<RenderLayer<LivingEntity, EntityModel<LivingEntity>>> f_115291_ = Lists.newArrayList();

    @Shadow
    protected abstract RenderType m_7225_(LivingEntity var1, boolean var2, boolean var3, boolean var4);

    @Shadow
    protected abstract float m_6931_(LivingEntity var1, float var2);

    @Shadow
    protected abstract void m_7523_(LivingEntity var1, PoseStack var2, float var3, float var4, float var5);

    @Shadow
    protected abstract void m_7546_(LivingEntity var1, PoseStack var2, float var3);

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    public void render(LivingEntity livingEntity, float livingEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, CallbackInfo ci) {
        Direction direction;
        float i;
        Entity var11;
        Optional<Player> optionalPlayer;
        if (!(livingEntity instanceof AbstractHorse)) {
            return;
        }
        AbstractHorse abstractHorse = (AbstractHorse)livingEntity;
        if (!Util.wearsShadowSaddle(abstractHorse)) {
            return;
        }
        Player player = null;
        List passengers = abstractHorse.m_20197_();
        if (!passengers.isEmpty() && (optionalPlayer = passengers.stream().filter(passenger -> passenger instanceof Player).map(passenger -> (Player)passenger).findFirst()).isPresent()) {
            player = optionalPlayer.get();
        }
        poseStack.m_85836_();
        this.f_115290_.f_102608_ = livingEntity.m_21324_(partialTicks);
        this.f_115290_.f_102609_ = livingEntity.m_20159_();
        this.f_115290_.f_102610_ = livingEntity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
        float g = Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
        float h = g - f;
        if (livingEntity.m_20159_() && (var11 = livingEntity.m_20202_()) instanceof LivingEntity) {
            LivingEntity passengerlivingEntity = (LivingEntity)var11;
            f = Mth.m_14189_((float)partialTicks, (float)passengerlivingEntity.f_20884_, (float)passengerlivingEntity.f_20883_);
            h = g - f;
            i = Mth.m_14177_((float)h);
            if (i < -85.0f) {
                i = -85.0f;
            }
            if (i >= 85.0f) {
                i = 85.0f;
            }
            f = g - i;
            if (i * i > 2500.0f) {
                f += i * 0.2f;
            }
            h = g - f;
        }
        float j = Mth.m_14179_((float)partialTicks, (float)livingEntity.f_19860_, (float)livingEntity.m_146909_());
        if (LivingEntityRenderer.m_194453_((LivingEntity)livingEntity)) {
            j *= -1.0f;
            h *= -1.0f;
        }
        h = Mth.m_14177_((float)h);
        if (livingEntity.m_217003_(Pose.SLEEPING) && (direction = livingEntity.m_21259_()) != null) {
            float k = livingEntity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-direction.m_122429_()) * k, 0.0f, (float)(-direction.m_122431_()) * k);
        }
        i = livingEntity.m_6134_();
        poseStack.m_85841_(i, i, i);
        float k = (float)livingEntity.f_19797_ + partialTicks;
        this.m_7523_(livingEntity, poseStack, k, f, partialTicks);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_(livingEntity, poseStack, partialTicks);
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        float l = 0.0f;
        float m = 0.0f;
        if (!livingEntity.m_20159_() && livingEntity.m_6084_()) {
            l = livingEntity.f_267362_.m_267711_(partialTicks);
            m = livingEntity.f_267362_.m_267590_(partialTicks);
            if (livingEntity.m_6162_()) {
                m *= 3.0f;
            }
            if (l > 1.0f) {
                l = 1.0f;
            }
        }
        this.f_115290_.m_6839_((Entity)livingEntity, m, l, partialTicks);
        this.f_115290_.m_6973_((Entity)livingEntity, m, l, k, h, j);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = !livingEntity.m_20145_();
        boolean bl2 = !bl && !livingEntity.m_20177_((Player)minecraft.f_91074_);
        boolean bl3 = minecraft.m_91314_((Entity)livingEntity);
        RenderType renderType = this.m_7225_(livingEntity, bl, bl2, bl3);
        if (renderType != null) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
            int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)livingEntity, (float)this.m_6931_(livingEntity, partialTicks));
            ShadowMountRenderFunctions.renderDarkerToBuffer(this.f_115290_, poseStack, vertexConsumer, packedLight, overlayCoords, bl2);
        }
        if (!livingEntity.m_5833_()) {
            for (RenderLayer<LivingEntity, EntityModel<LivingEntity>> layer : this.f_115291_) {
                layer.m_6494_(poseStack, multiBufferSource, packedLight, (Entity)livingEntity, m, l, partialTicks, k, h, j);
            }
        }
        poseStack.m_85849_();
        ShadowMountRenderFunctions.renderTrailingParticles(abstractHorse, player);
    }

    @ModifyVariable(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;getRenderType(Lnet/minecraft/world/entity/LivingEntity;ZZZ)Lnet/minecraft/client/renderer/RenderType;"))
    public RenderType modifyRenderType(RenderType originalRenderType, LivingEntity livingEntity, float livingEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        AbstractHorse abstractHorse;
        if (livingEntity instanceof AbstractHorse && Util.wearsShadowSaddle(abstractHorse = (AbstractHorse)livingEntity)) {
            return null;
        }
        return originalRenderType;
    }
}

