/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.shadowmounts_common_forge.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.natamus.shadowmounts_common_forge.config.ConfigHandler;
import com.natamus.shadowmounts_common_forge.data.Constants;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ShadowMountRenderFunctions {
    private static final List<Pair<SimpleParticleType, Integer>> trailParticles = Arrays.asList(new Pair((Object)ParticleTypes.f_123783_, (Object)1), new Pair((Object)ParticleTypes.f_123784_, (Object)8), new Pair((Object)ParticleTypes.f_123745_, (Object)32), new Pair((Object)ParticleTypes.f_123756_, (Object)64));

    public static void renderDarkerToBuffer(EntityModel<?> entityModel, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int overlayCoords, boolean visible) {
        if (ConfigHandler.darkenHorseTexture) {
            entityModel.m_7695_(poseStack, vertexConsumer, packedLight / 5, overlayCoords, 1.0f, 1.0f, 1.0f, visible ? 0.15f : 1.0f);
            return;
        }
        entityModel.m_7695_(poseStack, vertexConsumer, packedLight, overlayCoords, 1.0f, 1.0f, 1.0f, visible ? 0.15f : 1.0f);
    }

    public static void renderLayerDarkerToBuffer(EntityModel<?> entityModel, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int overlayCoords, boolean visible) {
        if (ConfigHandler.darkenHorseTexture) {
            entityModel.m_7695_(poseStack, vertexConsumer, packedLight, overlayCoords, 1.0f, 1.0f, 1.0f, visible ? 0.15f : 1.0f);
            return;
        }
        entityModel.m_7695_(poseStack, vertexConsumer, packedLight, overlayCoords, 1.0f, 1.0f, 1.0f, visible ? 0.15f : 1.0f);
    }

    public static void renderTrailingParticles(AbstractHorse abstractHorse, @Nullable Player player) {
        if (!ConfigHandler.showShadowHorseParticles) {
            return;
        }
        Level level = abstractHorse.m_9236_();
        if (!level.f_46443_) {
            return;
        }
        if (player == null && ConfigHandler.onlyShowParticlesWhenRiding) {
            return;
        }
        double particleBehindoffsetDistance = -1.0;
        float yRot = abstractHorse.m_146908_() * ((float)Math.PI / 180);
        double xBaseOffset = particleBehindoffsetDistance * -Math.sin(yRot);
        double zBaseOffset = particleBehindoffsetDistance * Math.cos(yRot);
        double xBaseParticleVelocity = Math.sin(yRot) * 0.1;
        double zBaseParticleVelocity = -Math.cos(yRot) * 0.1;
        boolean isMoving = abstractHorse.m_20184_().m_165925_() > 1.0E-4;
        for (Pair<SimpleParticleType, Integer> particlePair : trailParticles) {
            int tickDelay = (Integer)particlePair.getSecond();
            if ((!isMoving || tickDelay != 32) && abstractHorse.f_19797_ % tickDelay != 0) continue;
            SimpleParticleType particle = (SimpleParticleType)particlePair.getFirst();
            double randomXOffset = xBaseOffset + (Constants.random.nextDouble() - 0.5) * 0.2;
            double randomYOffset = 0.5 + (Constants.random.nextDouble() - 0.5) * 0.2;
            double randomZOffset = zBaseOffset + (Constants.random.nextDouble() - 0.5) * 0.2;
            double xRandomParticleVelocity = xBaseParticleVelocity + (Constants.random.nextDouble() - 0.5) * 0.02;
            double zrandomParticleVelocity = zBaseParticleVelocity + (Constants.random.nextDouble() - 0.5) * 0.02;
            level.m_7106_((ParticleOptions)particle, abstractHorse.m_20185_() + randomXOffset, abstractHorse.m_20186_() + randomYOffset, abstractHorse.m_20189_() + randomZOffset, xRandomParticleVelocity, -abstractHorse.m_20184_().f_82480_ * 0.5, zrandomParticleVelocity);
        }
    }
}

