/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class UpgradeUniqueRecipe
extends class_1869 {
    private final int upgradableItemSlot;
    private final class_1799 output;

    public UpgradeUniqueRecipe(class_2960 id, String group, class_7710 category, int width, int height, class_2371<class_1856> input, class_1799 output, int upgradableItemSlot) {
        super(id, group, category, width, height, input, output);
        this.upgradableItemSlot = upgradableItemSlot;
        this.output = output;
    }

    public class_1799 method_17727(class_8566 inventory, class_5455 registryManager) {
        class_1799 output = this.output.method_7972();
        output.method_7980(inventory.method_5438(this.upgradableItemSlot).method_7948().method_10553());
        return output;
    }

    static class_3545<class_2371<class_1856>, Integer> createPatternMatrix(String[] pattern, Map<String, class_3545<class_1856, Boolean>> symbols, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        int slot = -1;
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = (class_1856)symbols.get(string).method_15442();
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                if (((Boolean)symbols.get(string).method_15441()).booleanValue()) {
                    if (slot < 0) {
                        slot = j + i * pattern[i].length();
                    } else {
                        throw new JsonSyntaxException("Pattern attempted to define slot #" + j + " as upgradable, but slot #" + slot + " is already upgradable");
                    }
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (slot < 0) {
            throw new JsonSyntaxException("Pattern does not define a slot as upgradable");
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return new class_3545((Object)defaultedList, (Object)slot);
    }

    static Map<String, class_3545<class_1856, Boolean>> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            boolean isSlot = class_3518.method_15258((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"upgradable", (boolean)false);
            map.put((String)entry.getKey(), new class_3545((Object)class_1856.method_52177((JsonElement)((JsonElement)entry.getValue())), (Object)isSlot));
        }
        map.put(" ", new class_3545((Object)class_1856.field_9017, (Object)false));
        return map;
    }

    static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        int a = strings[0].length();
        int b = strings.length;
        int c = 0;
        int d = 0;
        for (int y = 0; y < strings.length; ++y) {
            for (int x = 0; x < strings[0].length(); ++x) {
                if (strings[y].charAt(x) == ' ') continue;
                if (x < a) {
                    a = x;
                }
                if (x > c) {
                    c = x;
                }
                if (y < b) {
                    b = y;
                }
                if (y <= d) continue;
                d = y;
            }
        }
        ArrayList<String> strippedStrings = new ArrayList<String>();
        for (int y = 0; y < strings.length; ++y) {
            if (y < b || y > d) continue;
            strippedStrings.add(strings[y].substring(a, c + 1));
        }
        return strippedStrings.toArray(new String[0]);
    }

    public class_1865<?> method_8119() {
        return class_1865.field_9028;
    }

    public static class Serializer
    implements class_1865<UpgradeUniqueRecipe> {
        public UpgradeUniqueRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String string = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            class_7710 craftingRecipeCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)jsonObject, (String)"category", null), (Enum)class_7710.field_40251);
            Map<String, class_3545<class_1856, Boolean>> map = UpgradeUniqueRecipe.readSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            String[] strings = UpgradeUniqueRecipe.getPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            class_3545<class_2371<class_1856>, Integer> patternMatrix = UpgradeUniqueRecipe.createPatternMatrix(strings, map, i, j);
            class_2371 defaultedList = (class_2371)patternMatrix.method_15442();
            class_1799 itemStack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new UpgradeUniqueRecipe(identifier, string, craftingRecipeCategory, i, j, (class_2371<class_1856>)defaultedList, itemStack, (Integer)patternMatrix.method_15441());
        }

        public UpgradeUniqueRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            int i = packetByteBuf.method_10816();
            int j = packetByteBuf.method_10816();
            String string = packetByteBuf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)packetByteBuf.method_10818(class_7710.class);
            class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            defaultedList.replaceAll(ing -> class_1856.method_8086((class_2540)packetByteBuf));
            class_1799 itemStack = packetByteBuf.method_10819();
            int slot = packetByteBuf.method_10816();
            return new UpgradeUniqueRecipe(identifier, string, craftingRecipeCategory, i, j, (class_2371<class_1856>)defaultedList, itemStack, slot);
        }

        public void write(class_2540 packetByteBuf, UpgradeUniqueRecipe shapedRecipe) {
            packetByteBuf.method_10804(shapedRecipe.method_8158());
            packetByteBuf.method_10804(shapedRecipe.method_8150());
            packetByteBuf.method_10814(shapedRecipe.method_8112());
            packetByteBuf.method_10817((Enum)shapedRecipe.method_45441());
            for (class_1856 ingredient : shapedRecipe.method_8117()) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapedRecipe.output);
            packetByteBuf.method_10804(shapedRecipe.upgradableItemSlot);
        }
    }
}

