/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords;

import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.io.File;
import java.io.IOException;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4505;
import net.minecraft.class_5321;
import net.minecraft.class_5601;
import net.minecraft.class_7924;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.client.renderer.BattleStandardDarkRenderer;
import net.sweenus.simplyswords.client.renderer.BattleStandardRenderer;
import net.sweenus.simplyswords.client.renderer.model.BattleStandardDarkModel;
import net.sweenus.simplyswords.client.renderer.model.BattleStandardModel;
import net.sweenus.simplyswords.compat.EldritchEndCompat;
import net.sweenus.simplyswords.compat.eldritch_end.EldritchEndCompatRegistry;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigWrapper;
import net.sweenus.simplyswords.config.GemEffectsConfig;
import net.sweenus.simplyswords.config.GeneralConfig;
import net.sweenus.simplyswords.config.LootConfig;
import net.sweenus.simplyswords.config.RunicEffectsConfig;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.config.StatusEffectsConfig;
import net.sweenus.simplyswords.config.UniqueEffectsConfig;
import net.sweenus.simplyswords.config.WeaponAttributesConfig;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.entity.SimplySwordsBeeEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.FileCopier;
import net.sweenus.simplyswords.util.ModLootTableModifiers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplySwords {
    public static final String MOD_ID = "simplyswords";
    public static final DeferredRegister<class_1761> TABS = DeferredRegister.create((String)"simplyswords", (class_5321)class_7924.field_44688);
    public static final RegistrySupplier<class_1761> SIMPLYSWORDS = TABS.register("simplyswords", () -> CreativeTabRegistry.create((class_2561)class_2561.method_43471((String)"itemGroup.simplyswords.simplyswords"), () -> new class_1799((class_1935)ItemsRegistry.RUNIC_TABLET.get())));
    public static final Logger LOGGER = LogManager.getLogger((String)"simplyswords");
    public static boolean isConfigOutdated;
    public static GeneralConfig generalConfig;
    public static LootConfig lootConfig;
    public static GemEffectsConfig gemEffectsConfig;
    public static RunicEffectsConfig runicEffectsConfig;
    public static StatusEffectsConfig statusEffectsConfig;
    public static UniqueEffectsConfig uniqueEffectsConfig;
    public static WeaponAttributesConfig weaponAttributesConfig;
    public static String minimumEldritchEndVersion;
    public static String minimumSpellPowerVersion;

    public static void init() {
        SimplySwordsConfig.init();
        AutoConfig.register(ConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        generalConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).general;
        lootConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).loot;
        gemEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).gem_effects;
        runicEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).runic_effects;
        statusEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).status_effects;
        uniqueEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).unique_effects;
        weaponAttributesConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).weapon_attributes;
        String version = SimplySwordsExpectPlatform.getVersion();
        String defaultConfig = String.format("{\n  \"regen_simplyswords_config_file\": false,\n  \"config_version\": %s\n}", version.substring(0, 4));
        File configFile = Config.createFile("config/simplyswords_extra/backupconfig.json", defaultConfig, false);
        JsonObject json = Config.getJsonObject(Config.readFile(configFile));
        isConfigOutdated = !json.has("config_version") || !version.startsWith(json.get("config_version").getAsString());
        SimplySwordsConfig.generateConfigs(json == null || !json.has("regen_simplyswords_config_file") || json.get("regen_simplyswords_config_file").getAsBoolean());
        SimplySwordsConfig.loadConfig();
        TABS.register();
        ItemsRegistry.ITEM.register();
        SoundRegistry.SOUND.register();
        EffectRegistry.EFFECT.register();
        EntityRegistry.ENTITIES.register();
        EntityAttributeRegistry.register(EntityRegistry.BATTLESTANDARD, BattleStandardEntity::createBattleStandardAttributes);
        EntityAttributeRegistry.register(EntityRegistry.BATTLESTANDARDDARK, BattleStandardDarkEntity::createBattleStandardDarkAttributes);
        EntityAttributeRegistry.register(EntityRegistry.SIMPLYBEEENTITY, SimplySwordsBeeEntity::createSimplyBeeAttributes);
        ModLootTableModifiers.init();
        if (SimplySwords.passVersionCheck("eldritch_end", minimumEldritchEndVersion)) {
            EldritchEndCompat.registerModItems();
            EldritchEndCompatRegistry.EFFECT.register();
        }
        try {
            FileCopier.copyFileToConfigDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(SimplySwordsExpectPlatform.getConfigDirectory().toAbsolutePath().normalize().toString());
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::initializeClient);
    }

    public static boolean passVersionCheck(String modId, String requiredVersion) {
        return Platform.isModLoaded((String)modId) && Platform.getMod((String)modId).getVersion().compareTo(requiredVersion) >= 0;
    }

    static {
        minimumEldritchEndVersion = "0.2.40";
        minimumSpellPowerVersion = "0.10.0+1.20.1";
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static final class_5601 BATTLESTANDARD_MODEL = new class_5601(new class_2960("battlestandard", "cube"), "main");
        public static final class_5601 BATTLESTANDARD_DARK_MODEL = new class_5601(new class_2960("battlestandarddark", "cube"), "main");

        @Environment(value=EnvType.CLIENT)
        public static void initializeClient() {
            EntityRendererRegistry.register(EntityRegistry.BATTLESTANDARD, BattleStandardRenderer::new);
            EntityModelLayerRegistry.register((class_5601)BATTLESTANDARD_MODEL, BattleStandardModel::getTexturedModelData);
            EntityRendererRegistry.register(EntityRegistry.BATTLESTANDARDDARK, BattleStandardDarkRenderer::new);
            EntityModelLayerRegistry.register((class_5601)BATTLESTANDARD_DARK_MODEL, BattleStandardDarkModel::getTexturedModelData);
            EntityRendererRegistry.register(EntityRegistry.SIMPLYBEEENTITY, class_4505::new);
        }
    }
}

