/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.entitystats;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_4048;
import net.soulsweaponry.api.entitystats.EntityStats;
import net.soulsweaponry.api.entitystats.EntityStatsUtil;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.registry.AttributeRegistry;

public class EntityPosture {
    public static final int BASE_POSTURE = (int)ConfigConstructor.base_posture_unit;

    public static int getMaxPostureLoss(class_1309 entity) {
        class_1324 inst;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (entity.method_37908().field_9236) {
                return PostureData.getMaxPosture(player);
            }
        }
        Optional<EntityStats> op = EntityStatsUtil.getStats((class_1297)entity);
        int base = BASE_POSTURE;
        if (op.isPresent()) {
            EntityStats stats = op.get();
            if (stats.max_posture_loss != 0.0f) {
                return Math.round(stats.max_posture_loss);
            }
            if (stats.base_posture_unit > 0.0f) {
                base = Math.round(stats.base_posture_unit);
            }
        }
        double bonus = (inst = entity.method_5996(AttributeRegistry.BASE_POSTURE_INCREASE)) != null ? inst.method_6194() : 0.0;
        class_4048 dimensions = entity.method_18377(entity.method_18376());
        float volume = dimensions.field_18068 * dimensions.field_18067 * dimensions.field_18067;
        int value = (int)((double)(base += (int)bonus) * (1.0 + Math.log1p(volume) / 3.5));
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PostureData.updateMaxPosture(player, value);
        }
        return value;
    }

    public static boolean isPostureDisabled(class_1309 entity) {
        Optional<EntityStats> op = EntityStatsUtil.getStats((class_1297)entity);
        if (op.isPresent()) {
            EntityStats stats = op.get();
            return stats.max_posture_loss < 0.0f || ConfigConstructor.disable_posture_mechanic_for_all_mobs;
        }
        return ConfigConstructor.disable_posture_mechanic_for_all_mobs;
    }

    public static int getPostureLoss(class_1309 entity, int amount) {
        float resistance = EntityPosture.getPostureResistance(entity);
        return Math.round(EntityStatsUtil.calculateResistance(resistance, amount));
    }

    public static float getPostureResistance(class_1309 entity) {
        float base = EntityStatsUtil.getStats((class_1297)entity).map(s -> Float.valueOf(s.posture_loss_buildup_resistance)).orElse(Float.valueOf(ConfigConstructor.base_posture_buildup_resistance_unless_overridden)).floatValue();
        class_1324 inst = entity.method_5996(AttributeRegistry.POSTURE_BUILDUP_RESISTANCE);
        float bonus = inst != null ? (float)inst.method_6194() : 0.0f;
        return base + bonus;
    }
}

