/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.entitystats;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import net.soulsweaponry.api.entitystats.EntityStats;

public class EntityStatsUtil
implements IdentifiableResourceReloadListener {
    private static final String FOLDER = "entitystats";
    private static final class_2960 ID = new class_2960("soulsweapons", "entity_attributes");
    private static final Gson GSON = new Gson();
    private static final Map<class_2960, EntityStats> statsMap = new HashMap<class_2960, EntityStats>();

    public static Optional<EntityStats> getStats(class_2960 entityId) {
        return Optional.ofNullable(statsMap.get(entityId));
    }

    public static class_2960 getEntityIdentifier(class_1297 entity) {
        return class_7923.field_41177.method_10221((Object)entity.method_5864());
    }

    public static Optional<EntityStats> getStats(class_1297 entity) {
        return EntityStatsUtil.getStats(EntityStatsUtil.getEntityIdentifier(entity));
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Map> loadFuture = CompletableFuture.supplyAsync(() -> {
            HashMap newStats = new HashMap();
            manager.method_14488(FOLDER, id -> id.method_12832().endsWith(".json")).forEach((resId, resource) -> {
                String path = resId.method_12832();
                String fileName = path.substring(FOLDER.length() + 1);
                String entityName = fileName.substring(0, fileName.length() - 5);
                class_2960 entityId = new class_2960(resId.method_12836(), entityName);
                try (InputStream stream = ((class_3298)manager.method_14486(resId).get()).method_14482();
                     InputStreamReader reader = new InputStreamReader(stream);){
                    EntityStats stats = (EntityStats)GSON.fromJson(JsonParser.parseReader((Reader)reader), EntityStats.class);
                    newStats.put(entityId, stats);
                }
                catch (JsonSyntaxException | IOException e) {
                    System.err.println("Error loading entitystats JSON '" + String.valueOf(resId) + "': " + e.getMessage());
                }
            });
            return newStats;
        }, prepareExecutor);
        return loadFuture.thenComposeAsync(loaded -> synchronizer.method_18352((Object)this.getFabricId()).thenRunAsync(() -> {
            statsMap.clear();
            statsMap.putAll((Map<class_2960, EntityStats>)loaded);
        }, applyExecutor), applyExecutor);
    }

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new EntityStatsUtil());
    }

    public static float calculateResistance(float resistance, float amountToReduce) {
        return Math.round((double)amountToReduce * Math.pow(2.0, (double)(-resistance) * 0.01));
    }
}

