/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.mobs;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.soulsweaponry.client.model.entity.mobs.MoonknightModel;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MoonknightRenderer
extends GeoEntityRenderer<Moonknight> {
    int[] rgbColorOne = new int[]{254, 200, 203};
    int[] rgbColorTwo = new int[]{254, 254, 218};
    int[] rgbColorThree = new int[]{106, 73, 156};
    int[] rgbColorFour = new int[]{176, 253, 252};
    double[] translation = new double[]{0.0, 4.0, 0.0};
    public static final class_2960 CRYSTAL_BEAM_TEXTURE = new class_2960("soulsweapons", "textures/entity/core_beam.png");
    private static final class_1921 CRYSTAL_BEAM_LAYER = class_1921.method_23584((class_2960)CRYSTAL_BEAM_TEXTURE);
    private int currentTick = -1;
    private static final int FULLBRIGHT_LIGHT = 0xF000F0;

    public MoonknightRenderer(class_5617.class_5618 ctx) {
        super(ctx, (GeoModel)new MoonknightModel());
        this.field_4673 = 2.5f;
    }

    protected float getDeathMaxRotation(Moonknight entityLivingBaseIn) {
        return 0.0f;
    }

    public boolean shouldRender(Moonknight entity, class_4604 frustum, double x, double y, double z) {
        return entity.getCanBeam() || super.method_3933((class_1297)entity, frustum, x, y, z);
    }

    public void render(Moonknight entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        CustomDeathHandler.renderDeathLight((class_1309)entity, entityYaw, partialTicks, stack, this.translation, bufferIn, packedLightIn, entity.deathTicks, this.rgbColorOne, this.rgbColorTwo, this.rgbColorThree, this.rgbColorFour);
        class_2338 blockPos = entity.getBeamLocation();
        if (entity.getCanBeam() && blockPos != null && !entity.method_29504()) {
            float yOffset = 6.0f;
            float exactTarget = class_3532.method_16439((float)partialTicks, (float)entity.prevBeamHeight, (float)entity.getBeamHeight());
            if (exactTarget < entity.renderBeamHeight) {
                entity.renderBeamHeight = exactTarget;
            }
            entity.renderBeamHeight += (exactTarget - entity.renderBeamHeight) * 0.1f;
            float m = (float)blockPos.method_10263() + 0.5f;
            float n = (float)blockPos.method_10264() + entity.renderBeamHeight;
            float o = (float)blockPos.method_10260() + 0.5f;
            float p = (float)((double)m - entity.method_23317());
            float q = (float)((double)n - entity.method_23318());
            float r = (float)((double)o - entity.method_23321());
            stack.method_46416(p, q, r);
            this.renderCoreBeam(-p, -q + yOffset, -r, partialTicks, entity.field_6012, stack, bufferIn, packedLightIn);
        }
    }

    private void renderCoreBeam(float dx, float dy, float dz, float tickDelta, int age, class_4587 matrices, class_4597 consumers, int packedLight) {
        MoonknightRenderer.renderBeamRing(dx, dy, dz, tickDelta, age, matrices, consumers, packedLight, 1.0f, 255, 255, 255, 255);
        MoonknightRenderer.renderBeamRing(dx, dy, dz, tickDelta, age, matrices, consumers, packedLight, 0.8f, 200, 200, 255, 200);
        MoonknightRenderer.renderBeamRing(dx, dy, dz, tickDelta, age, matrices, consumers, packedLight, 0.4f, 255, 255, 255, 128);
    }

    private static void renderBeamRing(float dx, float dy, float dz, float tickDelta, int age, class_4587 matrices, class_4597 consumers, int packedLight, float radiusScale, int r, int g, int b, int a) {
        class_4588 vb = consumers.getBuffer(CRYSTAL_BEAM_LAYER);
        float xzLen = class_3532.method_15355((float)(dx * dx + dz * dz));
        float vecLen = class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotation((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrices.method_22907(class_7833.field_40714.rotation((float)(-Math.atan2(xzLen, dy)) - 1.5707964f));
        float vMin = 0.0f - ((float)age + tickDelta) * -0.05f;
        float vMax = vecLen / 32.0f - ((float)age + tickDelta) * -0.05f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        float prevU = 0.0f;
        for (int i = 1; i <= 8; ++i) {
            float theta = (float)i * ((float)Math.PI * 2) / 8.0f;
            float cx = class_3532.method_15374((float)theta) * 0.75f * radiusScale;
            float cy = class_3532.method_15362((float)theta) * 0.75f * radiusScale;
            float u = (float)i / 8.0f;
            vb.method_22918(matrices.method_23760().method_23761(), prevX * radiusScale, prevY * radiusScale, 0.0f).method_1336(r, g, b, a).method_22913(prevU, vMin).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrices.method_23760().method_23762(), 0.0f, -1.0f, 0.0f).method_1344();
            vb.method_22918(matrices.method_23760().method_23761(), prevX, prevY, vecLen).method_1336(r, g, b, a).method_22913(prevU, vMax).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrices.method_23760().method_23762(), 0.0f, -1.0f, 0.0f).method_1344();
            vb.method_22918(matrices.method_23760().method_23761(), cx, cy, vecLen).method_1336(r, g, b, a).method_22913(u, vMax).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrices.method_23760().method_23762(), 0.0f, -1.0f, 0.0f).method_1344();
            vb.method_22918(matrices.method_23760().method_23761(), cx * radiusScale, cy * radiusScale, 0.0f).method_1336(r, g, b, a).method_22913(u, vMin).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrices.method_23760().method_23762(), 0.0f, -1.0f, 0.0f).method_1344();
            prevX = cx;
            prevY = cy;
            prevU = u;
        }
        matrices.method_22909();
    }

    public void renderFinal(class_4587 poseStack, Moonknight animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (animatable.isPhaseTwo() && !animatable.method_29504() && animatable.isSwordCharging() && (this.currentTick < 0 || this.currentTick != animatable.field_6012)) {
            this.currentTick = animatable.field_6012;
            this.model.getBone("particle1").ifPresent(sword1 -> this.model.getBone("particle2").ifPresent(sword2 -> {
                class_5819 rand = animatable.method_6051();
                Vector3d pos1 = sword1.getWorldPosition();
                Vector3d pos2 = sword2.getWorldPosition();
                int segments = 8;
                for (int i = 0; i <= segments; ++i) {
                    double t = (double)i / (double)segments;
                    double interpolatedX = pos1.x() + t * (pos2.x() - pos1.x());
                    double interpolatedY = pos1.y() + t * (pos2.y() - pos1.y());
                    double interpolatedZ = pos1.z() + t * (pos2.z() - pos1.z());
                    for (int j = 0; j < 4; ++j) {
                        animatable.method_5770().method_8406((class_2394)ParticleRegistry.NIGHTFALL_PARTICLE, interpolatedX, interpolatedY, interpolatedZ, (rand.method_43058() - 0.5) * 0.25, (rand.method_43058() - 0.5) * 0.25, (rand.method_43058() - 0.5) * 0.25);
                    }
                }
            }));
        }
        super.renderFinal(poseStack, (class_1297)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

