/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.mobs;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.soulsweaponry.client.SoulsWeaponryClient;
import net.soulsweaponry.client.model.entity.mobs.NightProwlerModel;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.util.CustomDeathHandler;
import org.joml.Matrix4f;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class NightProwlerRenderer
extends GeoEntityRenderer<NightProwler> {
    int[] rgbColorOne = new int[]{54, 122, 156};
    int[] rgbColorTwo = new int[]{147, 188, 210};
    int[] rgbColorThree = new int[]{221, 255, 254};
    int[] rgbColorFour = new int[]{235, 185, 232};
    double[] translation = new double[]{0.0, 3.0, 0.0};

    public NightProwlerRenderer(class_5617.class_5618 ctx) {
        super(ctx, (GeoModel)new NightProwlerModel());
        this.field_4673 = 1.0f;
    }

    protected float getDeathMaxRotation(NightProwler entityLivingBaseIn) {
        return 0.0f;
    }

    public void render(NightProwler entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        CustomDeathHandler.renderDeathLight((class_1309)entity, entityYaw, partialTicks, stack, this.translation, bufferIn, packedLightIn, entity.deathTicks, this.rgbColorOne, this.rgbColorTwo, this.rgbColorThree, this.rgbColorFour);
        if (this.shouldRenderPortal(entity)) {
            stack.method_22903();
            stack.method_46416(0.0f, this.getBottomYOffset(), 0.0f);
            Matrix4f matrix = stack.method_23760().method_23761();
            class_4588 vertexConsumer = bufferIn.getBuffer(this.getLayer());
            float radius = NightProwlerRenderer.calculatePortalRadius(16.0f, entity.getOpenPortalTicks(), partialTicks);
            int segments = 32;
            this.renderCircle(matrix, vertexConsumer, radius, segments);
            stack.method_22909();
        }
    }

    public static float calculatePortalRadius(float maxRadius, float ticks, float partialTicks) {
        float smoothTicks = ticks + partialTicks;
        if (smoothTicks < 0.0f) {
            return 0.0f;
        }
        if (smoothTicks <= 30.0f) {
            return maxRadius * (smoothTicks / 30.0f);
        }
        if (smoothTicks <= 190.0f) {
            return maxRadius;
        }
        if (smoothTicks <= 200.0f) {
            return maxRadius * (1.0f - (smoothTicks - 190.0f) / 10.0f);
        }
        return 0.0f;
    }

    private void renderCircle(Matrix4f matrix, class_4588 vertexConsumer, float radius, int segments) {
        int rings = 8;
        float epsilon = 0.01f;
        for (int ring = 0; ring < rings; ++ring) {
            float innerRadius = ring == 0 ? epsilon : radius * (float)ring / (float)rings;
            float outerRadius = radius * (float)(ring + 1) / (float)rings;
            for (int seg = 0; seg < segments; ++seg) {
                double angle1 = Math.PI * 2 * (double)seg / (double)segments;
                double angle2 = Math.PI * 2 * (double)(seg + 1) / (double)segments;
                float innerX1 = (float)((double)innerRadius * Math.cos(angle1));
                float innerZ1 = (float)((double)innerRadius * Math.sin(angle1));
                float innerX2 = (float)((double)innerRadius * Math.cos(angle2));
                float innerZ2 = (float)((double)innerRadius * Math.sin(angle2));
                float outerX1 = (float)((double)outerRadius * Math.cos(angle1));
                float outerZ1 = (float)((double)outerRadius * Math.sin(angle1));
                float outerX2 = (float)((double)outerRadius * Math.cos(angle2));
                float outerZ2 = (float)((double)outerRadius * Math.sin(angle2));
                vertexConsumer.method_22918(matrix, innerX1, 0.0f, innerZ1).method_1344();
                vertexConsumer.method_22918(matrix, outerX1, 0.0f, outerZ1).method_1344();
                vertexConsumer.method_22918(matrix, outerX2, 0.0f, outerZ2).method_1344();
                vertexConsumer.method_22918(matrix, innerX2, 0.0f, innerZ2).method_1344();
            }
        }
    }

    public boolean shouldRender(NightProwler entity, class_4604 frustum, double x, double y, double z) {
        return this.shouldRenderPortal(entity) || super.method_3933((class_1297)entity, frustum, x, y, z);
    }

    protected float getBottomYOffset() {
        return 8.0f;
    }

    protected class_1921 getLayer() {
        return SoulsWeaponryClient.NIGHT_PROWLER_PORTAL;
    }

    private boolean shouldRenderPortal(NightProwler entity) {
        return entity.getAttackAnimation().equals((Object)NightProwler.Attacks.ECLIPSE) && entity.getParticleState() == 4;
    }
}

