/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1538;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1670;
import net.minecraft.class_1673;
import net.minecraft.class_1674;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1678;
import net.minecraft.class_1679;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1683;
import net.minecraft.class_1685;
import net.minecraft.class_1687;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.entity.projectile.Cannonball;
import net.soulsweaponry.entity.projectile.ChaosSkull;
import net.soulsweaponry.entity.projectile.CometSpearEntity;
import net.soulsweaponry.entity.projectile.DragonslayerSwordspearEntity;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.entity.projectile.arrow.ChargedArrow;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;

public class ChaosMonarchGoal
extends class_1352 {
    private final ChaosMonarch boss;
    private int attackCooldown;
    private int attackStatus;
    private boolean randomOrNot;
    private int controlledProjectile = 0;
    private class_2338 blockPos;

    public ChaosMonarchGoal(ChaosMonarch boss) {
        this.boss = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.chaos_monarch_damage_modifier;
    }

    public boolean method_6264() {
        class_1309 target = this.boss.method_5968();
        return target != null && target.method_5805() && this.boss.method_18395(target);
    }

    public void method_6270() {
        super.method_6270();
        this.boss.setAttack(0);
        this.boss.method_19540(false);
    }

    public void resetAttack(float cooldownModifier) {
        this.attackStatus = 0;
        this.attackCooldown = this.adjustCooldown(cooldownModifier);
        this.boss.setAttack(0);
        this.randomOrNot = this.boss.method_6051().method_43056();
        this.controlledProjectile = this.boss.method_6051().method_43048(5);
        this.blockPos = null;
    }

    private int adjustCooldown(float cooldownModifier) {
        int reducedCooldown = class_3532.method_15375((float)(this.boss.method_6063() / this.boss.method_6032())) * 4;
        return class_3532.method_15375((float)(ConfigConstructor.chaos_monarch_attack_cooldown_ticks * cooldownModifier - (float)reducedCooldown));
    }

    public void randomAttack() {
        int attack = this.boss.method_6051().method_43048(5) + 2;
        if (attack == 3 && this.boss.method_5968() != null && this.boss.method_5858((class_1297)this.boss.method_5968()) > 40.0) {
            this.boss.setAttack(0);
        } else {
            this.boss.setAttack(attack);
        }
    }

    public void method_6268() {
        --this.attackCooldown;
        class_1309 target = this.boss.method_5968();
        if (target != null) {
            this.boss.method_19540(true);
            this.boss.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
            if (this.attackCooldown < 0) {
                if (this.boss.getAttack() == ChaosMonarch.Attack.IDLE) {
                    this.randomAttack();
                }
                switch (this.boss.getAttack()) {
                    case TELEPORT: {
                        ++this.attackStatus;
                        if (this.attackStatus % 2 == 0 && this.attackStatus < 10 && !this.boss.method_37908().field_9236) {
                            ParticleHandler.particleSphere(this.boss.method_37908(), 1000, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), (class_2394)class_2398.field_11214, 6.0f);
                        }
                        if (this.attackStatus == 23) {
                            this.boss.method_37908().method_43128(null, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f);
                            boolean bl = this.teleportAway();
                            if (!bl) {
                                this.explode();
                            } else if (!this.boss.method_37908().field_9236) {
                                ParticleHandler.particleSphereList(this.boss.method_37908(), 1000, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), 1.0f, new class_2394[]{class_2398.field_11216, class_2398.field_11216});
                            }
                        }
                        if (this.attackStatus < 30) break;
                        this.resetAttack(0.5f);
                        break;
                    }
                    case MELEE: {
                        ++this.attackStatus;
                        if (this.attackStatus < 5) {
                            this.blockPos = target.method_24515();
                        }
                        if (this.blockPos != null) {
                            this.boss.method_5988().method_20248((double)this.blockPos.method_10263(), (double)this.blockPos.method_10264(), (double)this.blockPos.method_10260());
                            if (this.attackStatus == 8) {
                                this.hitBox(this.blockPos, HitboxType.SWIPE);
                            }
                            if (this.attackStatus == 16) {
                                this.hitBox(this.blockPos, HitboxType.SWIPE);
                            }
                            if (this.attackStatus == 27) {
                                this.hitBox(this.blockPos, HitboxType.THRUST);
                            }
                            if (this.attackStatus == 39) {
                                this.hitBox(this.blockPos, HitboxType.BONK);
                            }
                        }
                        if (this.attackStatus < 45) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                    case LIGHTNING: {
                        ++this.attackStatus;
                        int[] triggers = new int[]{15, 20, 25};
                        if (this.attackStatus == 5) {
                            this.boss.method_37908().method_43128(null, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), class_3417.field_15168, class_3419.field_15251, 1.0f, 1.5f);
                        }
                        for (int i = 1; i < triggers.length + 1; ++i) {
                            if (this.attackStatus != triggers[i - 1]) continue;
                            this.spawnLightning(i);
                        }
                        if (this.attackStatus < 30) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                    case SHOOT: {
                        ++this.attackStatus;
                        if (this.attackStatus % 6 == 0) {
                            this.chaosSkull(target);
                        }
                        if (this.attackStatus < 40) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                    case BARRAGE: {
                        ++this.attackStatus;
                        if (this.attackStatus >= 9 && this.attackStatus < 25) {
                            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14970, class_3419.field_15251, 2.0f, 1.0f);
                            if (this.randomOrNot) {
                                this.randomProjectiles();
                            } else {
                                this.controlledProjectiles(target);
                            }
                        }
                        if (this.attackStatus < 30) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                }
            }
        }
    }

    private void hitBox(class_2338 blockPos, HitboxType type) {
        switch (type.ordinal()) {
            case 0: {
                this.boss.method_37908().method_8396(null, blockPos, class_3417.field_14706, class_3419.field_15251, 1.0f, 1.0f);
                this.generateHitbox(blockPos, 3.0, 15.0f);
                break;
            }
            case 1: {
                this.boss.method_37908().method_8396(null, blockPos, class_3417.field_14840, class_3419.field_15251, 1.0f, 1.0f);
                this.generateHitbox(blockPos, 2.0, 20.0f);
                break;
            }
            case 2: {
                this.generateHitbox(blockPos, 2.0, 30.0f);
                this.boss.method_37908().method_8396(null, blockPos, class_3417.field_15236, class_3419.field_15251, 1.0f, 1.0f);
                if (this.boss.method_37908().field_9236) break;
                ParticleHandler.particleSphereList(this.boss.method_37908(), 100, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            }
        }
    }

    private void generateHitbox(class_2338 blockPos, double expand, float damage) {
        class_238 box = new class_238(blockPos).method_1014(expand);
        List intersectingEntities = this.boss.method_37908().method_8335((class_1297)this.boss, box);
        for (class_1297 entity : intersectingEntities) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(damage));
            livingEntity.method_6005(this.boss.method_6051().method_43058(), this.boss.method_23317() - livingEntity.method_23317(), this.boss.method_23321() - livingEntity.method_23321());
        }
    }

    private void chaosSkull(class_1309 target) {
        double e = target.method_23317() - this.boss.method_23317();
        double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
        double g = target.method_23321() - this.boss.method_23321();
        ChaosSkull skull = new ChaosSkull(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321(), e, f + 1.0, g, this.boss.method_37908());
        skull.method_7432((class_1297)this.boss);
        this.boss.method_37908().method_8649((class_1297)skull);
        this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14588, class_3419.field_15251, 1.0f, 1.0f);
    }

    private void controlledProjectiles(class_1309 target) {
        double e = target.method_23317() - this.boss.method_23317();
        double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
        double g = target.method_23321() - this.boss.method_23321();
        class_243 vel = new class_243(e, f, g).method_1021(0.15);
        switch (this.controlledProjectile) {
            case 1: {
                class_1678 bullet = new class_1678(this.boss.method_37908(), (class_1309)this.boss, (class_1297)target, this.boss.method_5755().method_10166());
                bullet.method_33574(this.getBossPos());
                this.boss.method_37908().method_8649((class_1297)bullet);
                break;
            }
            case 2: {
                class_1683 bottle = new class_1683(class_1299.field_6064, this.boss.method_37908());
                bottle.method_33574(this.getBossPos());
                bottle.method_18799(vel);
                this.boss.method_37908().method_8649((class_1297)bottle);
                break;
            }
            case 3: {
                if (this.attackStatus % 2 == 0 && this.attackStatus > 18) {
                    class_1674 fireball = new class_1674(this.boss.method_37908(), (class_1309)this.boss, e, f, g, this.boss.method_6051().method_43048(3) + 1);
                    fireball.method_33574(this.getBossPos());
                    this.boss.method_37908().method_8649((class_1297)fireball);
                    break;
                }
                if (this.attackStatus >= 16) break;
                class_1677 fireball = new class_1677(this.boss.method_37908(), this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321(), e, f, g);
                this.boss.method_37908().method_8649((class_1297)fireball);
                break;
            }
            case 4: {
                class_1680 snow = new class_1680(class_1299.field_6068, this.boss.method_37908());
                snow.method_33574(this.getBossPos());
                snow.method_18799(vel);
                this.boss.method_37908().method_8649((class_1297)snow);
                break;
            }
            default: {
                class_1679 arrow = new class_1679(class_1299.field_6135, this.boss.method_37908());
                arrow.method_33574(this.getBossPos());
                arrow.method_7438(8.0);
                arrow.method_18800(vel.method_10216(), vel.method_10214() + (double)0.2f, vel.method_10215());
                this.boss.method_37908().method_8649((class_1297)arrow);
            }
        }
    }

    private class_243 getBossPos() {
        return new class_243(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
    }

    private void randomProjectiles() {
        class_1676[] projectiles = new class_1676[]{new class_1667(this.boss.method_37908(), (class_1309)this.boss), new class_1670(class_1299.field_6129, this.boss.method_37908()), new class_1674(class_1299.field_6066, this.boss.method_37908()), new class_1673(class_1299.field_6124, this.boss.method_37908()), new class_1677(class_1299.field_6049, this.boss.method_37908()), new class_1679(this.boss.method_37908(), (class_1309)this.boss), new class_1687(class_1299.field_6130, this.boss.method_37908()), new class_1681(class_1299.field_6144, this.boss.method_37908()), new class_1683(class_1299.field_6064, this.boss.method_37908()), new class_1680(class_1299.field_6068, this.boss.method_37908()), new class_1685(class_1299.field_6127, this.boss.method_37908()), new Cannonball(this.boss.method_37908(), (class_1309)this.boss), new ChargedArrow((class_1299<? extends ChargedArrow>)EntityRegistry.CHARGED_ARROW_ENTITY_TYPE, this.boss.method_37908()), new CometSpearEntity((class_1299<? extends CometSpearEntity>)EntityRegistry.COMET_SPEAR_ENTITY_TYPE, this.boss.method_37908()), new DragonslayerSwordspearEntity((class_1299<? extends DragonslayerSwordspearEntity>)EntityRegistry.SWORDSPEAR_ENTITY_TYPE, this.boss.method_37908()), new MoonlightProjectile(EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE, this.boss.method_37908()), new SilverBulletEntity((class_1299<? extends SilverBulletEntity>)EntityRegistry.SILVER_BULLET_ENTITY_TYPE, this.boss.method_37908())};
        if (this.boss.method_5968() != null) {
            class_1309 target = this.boss.method_5968();
            double e = target.method_23317() - this.boss.method_23317();
            double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
            double g = target.method_23321() - this.boss.method_23321();
            int random = this.boss.method_6051().method_43048(projectiles.length);
            class_1676 entity = projectiles[random];
            if (entity instanceof class_1674) {
                entity = new class_1674(this.boss.method_37908(), (class_1309)this.boss, e, f, g, this.boss.method_6051().method_43048(3) + 1);
            }
            entity.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            if (entity instanceof class_1665) {
                ((class_1665)entity).method_7438(6.0);
            }
            entity.method_18799(new class_243(e, f + 1.0, g).method_1021(0.15));
            this.boss.method_37908().method_8649((class_1297)entity);
        }
    }

    private void spawnLightning(int multiplier) {
        int r = 5 * multiplier;
        for (int theta = 0; theta < 360; theta += 30) {
            double x0 = this.boss.method_23317();
            double z0 = this.boss.method_23321();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            class_2338 pos = class_2338.method_49637((double)x, (double)this.boss.method_23318(), (double)z);
            class_1538 entity = new class_1538(class_1299.field_6112, this.boss.method_37908());
            entity.method_23327((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            this.boss.method_37908().method_8649((class_1297)entity);
        }
    }

    protected boolean teleportAway() {
        if (this.boss.method_37908().method_8608() || !this.boss.method_5805()) {
            return false;
        }
        double d = this.boss.method_23317() + (this.boss.method_6051().method_43058() - 0.5) * 64.0;
        double e = this.boss.method_23318() + (double)(this.boss.method_6051().method_43048(64) - 16);
        double f = this.boss.method_23321() + (this.boss.method_6051().method_43058() - 0.5) * 64.0;
        return this.teleportTo(d, e, f);
    }

    private boolean teleportTo(double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (mutable.method_10264() > this.boss.method_37908().method_31607() && !this.boss.method_37908().method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.boss.method_37908().method_8320((class_2338)mutable);
        boolean bl = blockState.method_51366();
        boolean bl2 = blockState.method_26227().method_15767(class_3486.field_15517);
        if (!bl || bl2) {
            return false;
        }
        class_243 vec3d = this.boss.method_19538();
        boolean bl3 = this.boss.method_6082(x, y, z, true);
        if (bl3) {
            this.boss.method_37908().method_32888(class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)this.boss));
            if (!this.boss.method_5701()) {
                this.boss.method_37908().method_43128(null, this.boss.field_6014, this.boss.field_6036, this.boss.field_5969, class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f);
                this.boss.method_5783(class_3417.field_14879, 1.0f, 1.0f);
            }
        }
        return bl3;
    }

    private void explode() {
        this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_15152, class_3419.field_15251, 5.0f, 1.0f);
        class_238 chunkBox = new class_238(this.boss.method_24515()).method_1014(5.0);
        List nearbyEntities = this.boss.method_37908().method_8335((class_1297)this.boss, chunkBox);
        for (class_1297 nearbyEntity : nearbyEntities) {
            if (!(nearbyEntity instanceof class_1309)) continue;
            class_1309 closestTarget = (class_1309)nearbyEntity;
            double x = closestTarget.method_23317() - this.boss.method_23317();
            double z = closestTarget.method_23321() - this.boss.method_23321();
            closestTarget.method_6005(10.0, -x, -z);
            closestTarget.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(30.0f));
        }
        if (!this.boss.method_37908().field_9236) {
            ParticleHandler.particleSphereList(this.boss.method_37908(), 1000, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), 1.0f, new class_2394[]{class_2398.field_22246, class_2398.field_11237});
        }
    }

    static enum HitboxType {
        SWIPE,
        THRUST,
        BONK;

    }
}

