/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.ArrayList;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.WarmthEntity;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.UntargetableFireball;
import net.soulsweaponry.entity.projectile.noclip.AirCombustion;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntityEvents;
import net.soulsweaponry.entity.projectile.noclip.FlamePillar;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class DayStalkerGoal
extends class_1366 {
    private final DayStalker boss;
    private int attackCooldown;
    private int specialCooldown;
    private int attackStatus;
    private int attackLength;
    private final int[] flamethrowerMeleeFrames = new int[]{18, 27, 41, 50, 58, 63};
    private float attackRotation;
    private double targetMaxY;
    private boolean hasExploded;
    private int changeFlightTargetTimer;
    private class_243 flightPosAdder;
    private float flyY = 6.0f;
    private float fallDistance = 0.0f;

    public DayStalkerGoal(DayStalker boss, double speed, boolean pauseWhenMobIdle) {
        super((class_1314)boss, speed, pauseWhenMobIdle);
        this.boss = boss;
    }

    public boolean method_6264() {
        if (this.boss.isFlying() && this.boss.method_5968() != null) {
            return true;
        }
        return super.method_6264();
    }

    public void method_6270() {
        super.method_6270();
        int remainingTicks = this.attackLength - this.attackStatus;
        if (remainingTicks > 0) {
            this.boss.setWaitAnimation(true);
        }
        this.boss.setRemainingAniTicks(remainingTicks);
        this.attackCooldown = 20;
        this.specialCooldown = 20;
        this.attackStatus = 0;
        this.attackLength = 0;
        this.boss.setParticleState(0);
        this.hasExploded = false;
        this.boss.setFlying(false);
        this.changeFlightTargetTimer = 0;
        this.flyY = 6.0f;
        this.fallDistance = 0.0f;
        this.boss.flightTimer = 0;
    }

    private void checkAndSetAttack(class_1309 target) {
        double distanceToEntity = this.boss.method_5858((class_1297)target);
        int rand = this.boss.method_6051().method_43048(DayStalker.ATTACKS_LENGTH);
        DayStalker.Attacks attack = DayStalker.Attacks.values()[rand];
        switch (attack) {
            case AIR_COMBUSTION: {
                this.boss.setAttackAnimation(attack);
                break;
            }
            case BLAZE_BARRAGE: 
            case SUNFIRE_RUSH: {
                if (!this.boss.isFlying() && !this.boss.isPhaseTwo() || this.isInMeleeRange(target)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case CONFLAGRATION: {
                if (!this.boss.isFlying() && (!this.boss.isPhaseTwo() || this.specialCooldown > 0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DECIMATE: 
            case DAWNBREAKER: {
                if ((!this.isInMeleeRange(target) || this.boss.isFlying()) && !this.boss.isPhaseTwo()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case FLAMES_EDGE: {
                double d = this.boss.isPhaseTwo() ? 80.0 : 55.0;
                if (!(distanceToEntity < d) || this.boss.isFlying()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case CHAOS_STORM: {
                if (this.boss.isFlying() || !(distanceToEntity < 80.0) || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case FLAMETHROWER: {
                if (!this.boss.isFlying() && !this.boss.isPhaseTwo() || !(distanceToEntity < 260.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case RADIANCE: {
                if (!this.boss.isPhaseTwo() || !this.isInMeleeRange(target) || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case WARMTH: {
                if (!this.boss.isPhaseTwo() || this.specialCooldown > 0 || !this.boss.method_6051().method_43056()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case OVERHEAT: 
            case INFERNO: {
                if (!this.boss.isPhaseTwo() || !(distanceToEntity < 200.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case FLAMES_REACH: {
                if (this.boss.isFlying()) break;
                double d = this.boss.isPhaseTwo() ? 140.0 : 120.0;
                if (!(distanceToEntity < d)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case SKY_HIGH: {
                if (!this.boss.isPhaseTwo() || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            default: {
                this.boss.setAttackAnimation(DayStalker.Attacks.IDLE);
            }
        }
    }

    public void method_6268() {
        class_1309 target;
        if (this.boss.getRemainingAniTicks() > 0 || this.boss.getAttackAnimation().equals((Object)DayStalker.Attacks.SPAWN)) {
            return;
        }
        if (this.boss.isInitiatingPhaseTwo()) {
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 255));
            return;
        }
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.specialCooldown = Math.max(this.specialCooldown - 1, 0);
        if (!this.boss.isFlying() && this.boss.shouldChaseTarget()) {
            super.method_6268();
        }
        if ((target = this.boss.method_5968()) != null) {
            if (!this.boss.isPhaseTwo()) {
                this.tickPartnerSwitch();
            }
            if (this.boss.isFlying()) {
                this.moveAboveTarget(target);
            }
            double distanceToEntity = this.boss.method_5858((class_1297)target);
            if (this.attackCooldown <= 0 && this.boss.getAttackAnimation().equals((Object)DayStalker.Attacks.IDLE)) {
                this.checkAndSetAttack(target);
            }
            switch (this.boss.getAttackAnimation()) {
                case AIR_COMBUSTION: {
                    this.attackLength = 55;
                    this.airCombustion(target);
                    break;
                }
                case DECIMATE: {
                    this.attackLength = 60;
                    this.decimate(target);
                    break;
                }
                case DAWNBREAKER: {
                    this.attackLength = 40;
                    this.dawnbreaker(target);
                    break;
                }
                case CHAOS_STORM: {
                    this.attackLength = 90;
                    this.chaosStorm();
                    break;
                }
                case FLAMETHROWER: {
                    this.attackLength = 90;
                    this.flamethrower(target, distanceToEntity);
                    break;
                }
                case SUNFIRE_RUSH: {
                    this.attackLength = 117;
                    this.sunfireRush(target);
                    break;
                }
                case CONFLAGRATION: {
                    this.attackLength = this.boss.isPhaseTwo() ? 140 : 60;
                    this.conflagration(target);
                    break;
                }
                case BLAZE_BARRAGE: {
                    this.attackLength = 100;
                    this.blazeBarrage(target);
                    break;
                }
                case FLAMES_EDGE: {
                    this.attackLength = this.boss.isPhaseTwo() ? 90 : 60;
                    this.flamesEdge();
                    break;
                }
                case RADIANCE: {
                    this.attackLength = 120;
                    this.radiance();
                    break;
                }
                case WARMTH: {
                    this.attackLength = 100;
                    this.warmth();
                    break;
                }
                case OVERHEAT: {
                    this.attackLength = 100;
                    this.overheat(target);
                    break;
                }
                case INFERNO: {
                    this.attackLength = 160;
                    this.inferno();
                    break;
                }
                case FLAMES_REACH: {
                    this.attackLength = 60;
                    this.flamesReach(target, distanceToEntity);
                    break;
                }
                case SKY_HIGH: {
                    this.attackLength = 210;
                    this.skyHigh();
                }
            }
        }
    }

    private void tickPartnerSwitch() {
        NightProwler partner;
        int timer = Math.max(0, this.boss.flightTimer--);
        if (!this.boss.method_37908().field_9236 && (partner = this.boss.getPartner((class_3218)this.boss.method_37908())) != null) {
            if (timer == 0) {
                partner.setFlying(!partner.isFlying());
                this.boss.setFlying(!this.boss.isFlying());
                this.boss.flightTimer = (int)ConfigConstructor.duo_fight_time_before_switch;
            } else if (partner.isFlying() == this.boss.isFlying()) {
                boolean bl = this.boss.method_6051().method_43056();
                this.boss.setFlying(bl);
                partner.setFlying(!bl);
                this.boss.flightTimer = (int)ConfigConstructor.duo_fight_time_before_switch;
            }
        }
    }

    private class_243 randomizeVecAdder() {
        return new class_243((double)(this.boss.method_6051().method_39332(3, 10) * (this.boss.method_6051().method_43056() ? -1 : 1)), 0.0, (double)(this.boss.method_6051().method_39332(3, 10) * (this.boss.method_6051().method_43056() ? -1 : 1)));
    }

    private void moveAboveTarget(class_1309 target) {
        class_243 vec3d2;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
        class_243 vec3d = this.boss.method_18798().method_18805((double)0.8f, (double)0.6f, (double)0.8f);
        double d = vec3d.field_1351;
        if (this.boss.method_23318() < target.method_23318() || this.boss.method_23318() < target.method_23318() + (double)this.flyY) {
            d = Math.max(0.0, d);
            d += 0.3 - d * (double)0.6f;
        }
        vec3d = new class_243(vec3d.field_1352, d, vec3d.field_1350);
        if (this.flightPosAdder != null) {
            ++this.changeFlightTargetTimer;
            if (this.changeFlightTargetTimer >= 40) {
                this.flightPosAdder = this.randomizeVecAdder();
                this.changeFlightTargetTimer = 0;
            }
        } else {
            this.flightPosAdder = this.randomizeVecAdder();
        }
        if ((vec3d2 = new class_243(target.method_23317() - this.boss.method_23317() + this.flightPosAdder.field_1352, 0.0, target.method_23321() - this.boss.method_23321() + this.flightPosAdder.field_1350)).method_37268() > 9.0) {
            class_243 vec3d3 = vec3d2.method_1029();
            vec3d = vec3d.method_1031(vec3d3.field_1352 * 0.3 - vec3d.field_1352 * 0.6, 0.0, vec3d3.field_1350 * 0.3 - vec3d.field_1350 * 0.6);
        }
        this.boss.method_18799(vec3d);
    }

    private void checkAndReset(int attackCooldown, int specialCooldown) {
        if (this.attackStatus > this.attackLength) {
            this.attackStatus = 0;
            this.attackCooldown = class_3532.method_15357((double)((double)attackCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.day_stalker_cooldown_modifier_phase_2 : ConfigConstructor.day_stalker_cooldown_modifier_phase_1)));
            if (specialCooldown != 0) {
                this.specialCooldown = class_3532.method_15357((double)((double)specialCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.day_stalker_special_cooldown_modifier_phase_2 : ConfigConstructor.day_stalker_special_cooldown_modifier_phase_1)));
            }
            this.attackLength = 0;
            this.boss.setAttackAnimation(DayStalker.Attacks.IDLE);
            this.boss.setChaseTarget(true);
            this.hasExploded = false;
            this.flyY = 6.0f;
            this.fallDistance = 0.0f;
        }
    }

    private float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.day_stalker_damage_modifier;
    }

    private boolean damageTarget(class_1309 target, float damage) {
        if (this.boss.isPartner(target) || target instanceof WarmthEntity) {
            return false;
        }
        if (target.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(damage))) {
            if (this.boss.isEmpowered()) {
                target.method_5639(2);
            }
            return true;
        }
        return false;
    }

    private void airCombustion(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus < 24 && target.method_24515() != null) {
            this.boss.setTargetPos(new class_2338(target.method_31477(), target.method_31478(), target.method_31479()));
        }
        this.boss.setChaseTarget(false);
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 255));
        this.boss.method_5988().method_19615(this.boss.getTargetPos().method_46558());
        if (this.attackStatus == 25) {
            class_243 pos = class_243.method_24953((class_2382)this.boss.getTargetPos());
            AirCombustion airCombustion = new AirCombustion(this.boss.method_37908(), (class_1309)this.boss, this.getModifiedDamage(35.0f), this.boss.isPhaseTwo() ? 5.0f : 3.0f, 12);
            airCombustion.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
            airCombustion.setEmpowered(this.boss.isEmpowered());
            this.boss.method_37908().method_8649((class_1297)airCombustion);
        }
        this.checkAndReset(15, 0);
    }

    private void decimate(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 255));
        this.boss.method_5988().method_35111((class_1297)target);
        if (this.attackStatus == 17) {
            this.playSound(this.boss.method_24515(), SoundRegistry.DAY_STALKER_DECIMATE, 1.0f, 1.0f);
        }
        if (this.attackStatus == 29) {
            if (this.isInMeleeRange(target) && this.damageTarget(target, 30.0f)) {
                target.method_5762(0.0, 1.0, 0.0);
            }
            if (this.boss.isPhaseTwo()) {
                double maxY = Math.min(target.method_23318(), this.boss.method_23318());
                float rotation = (float)Math.toDegrees(class_3532.method_15349((double)(target.method_23321() - this.boss.method_23321()), (double)(target.method_23317() - this.boss.method_23317())));
                WeaponUtil.doConsumerOnLine(this.boss.method_37908(), rotation, this.boss.method_19538(), maxY, 16, 1.25f, (TriConsumer<class_243, Integer, Float>)((TriConsumer)(vec, warmup, yaw) -> this.boss.method_37908().method_8501(class_2338.method_49638((class_2374)vec), class_2246.field_10036.method_9564())));
            }
        }
        if (this.attackStatus == 42) {
            boolean phase2 = this.boss.isPhaseTwo();
            this.shootSunlight(target, phase2 ? 1 : 0, phase2 ? 25.0f : 15.0f, 0);
        }
        this.checkAndReset(30, 0);
    }

    private void shootProjectile(class_1309 target, class_1676 projectile, class_3414 sound) {
        double x = target.method_23317() - this.boss.method_23317();
        double y = target.method_23320() - this.boss.method_23323(1.0);
        double z = target.method_23321() - this.boss.method_23321();
        this.boss.method_37908().method_8396(null, this.boss.method_24515(), sound, class_3419.field_15251, 1.0f, 1.0f);
        if (target.method_24515() != null) {
            this.boss.method_37908().method_8396(null, target.method_24515(), sound, class_3419.field_15251, 1.0f, 1.0f);
        }
        projectile.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
        projectile.method_7485(x, y, z, 1.5f, 1.0f);
        this.boss.method_37908().method_8649((class_1297)projectile);
    }

    private void chaosStorm() {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 255));
        this.field_6503.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == 18) {
            this.playSound(this.boss.method_24515(), class_3417.field_14880, 1.0f, 1.0f);
            int i = 0;
            ArrayList<class_2338> list = new ArrayList<class_2338>();
            list.add(new class_2338(0, 0, 0));
            float radius = phase2 ? 2.1f : 1.85f;
            while (i < (phase2 ? 32 : 16)) {
                int x = this.boss.method_31477() + this.boss.method_6051().method_43048(16) - 8;
                int y = this.boss.method_31478();
                int z = this.boss.method_31479() + this.boss.method_6051().method_43048(16) - 8;
                class_2338 pos = new class_2338(x, y, z);
                for (class_2338 listPos : list) {
                    if (listPos == pos) continue;
                    FlamePillar pillar = new FlamePillar(this.boss.method_37908(), (class_1309)this.boss, radius, i * 2, this.boss.isPhaseTwo() ? DamagingWarmupEntityEvents.SPAWN_MOLTEN_METAL : DamagingWarmupEntityEvents.SPAWN_FIRE);
                    pillar.setOtherAttributes(new DamagingWarmupEntityEvents.OtherAttributes(this.getModifiedDamage(6.0f), 3.0f));
                    pillar.method_7438(this.getModifiedDamage(48.0f));
                    pillar.method_23327(x, y, z);
                    this.boss.method_37908().method_8649((class_1297)pillar);
                    ++i;
                }
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 40, this.boss.isPhaseTwo() ? 0 : 60);
    }

    private void dawnbreaker(class_1309 target) {
        ++this.attackStatus;
        this.field_6503.method_5942().method_6340();
        if (this.attackStatus == 11 || this.attackStatus == 21) {
            this.playSound(null, class_3417.field_14706, 1.0f, 1.0f);
            if (this.isInMeleeRange(target)) {
                this.damageTarget(target, 10.0f + (float)this.attackStatus / 2.0f);
                if (!this.boss.method_37908().field_9236) {
                    ParticleHandler.singleParticle(this.boss.method_37908(), (class_2394)class_2398.field_11227, target.method_23317(), target.method_23320(), target.method_23321(), 0.0, 0.0, 0.0);
                }
            }
            if (this.boss.isPhaseTwo()) {
                this.shootSunlight(target, 0, 20.0f, 0);
            }
        }
        if (this.attackStatus == 32) {
            this.playSound(null, class_3417.field_14706, 1.0f, 0.75f);
            if (this.isInMeleeRange(target)) {
                this.damageTarget(target, 25.0f);
                if (!this.boss.method_37908().field_9236) {
                    ParticleHandler.singleParticle(this.boss.method_37908(), (class_2394)class_2398.field_11227, target.method_23317(), target.method_23320(), target.method_23321(), 0.0, 0.0, 0.0);
                }
            }
            if (this.boss.isPhaseTwo()) {
                this.shootSunlight(target, 2, 30.0f, 0);
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 20, 0);
    }

    private void shootSunlight(class_1309 target, int typeIndex, float damage, int rotationDegrees) {
        if (typeIndex == 0) {
            MoonlightProjectile projectile = this.getMoonlightProjectile(EntityRegistry.SUNLIGHT_PROJECTILE_SMALL, damage, rotationDegrees, 15, 30, 2, 20);
            this.shootProjectile(target, (class_1676)projectile, class_3417.field_14970);
        } else if (typeIndex == 1) {
            MoonlightProjectile projectile = this.getMoonlightProjectile(EntityRegistry.SUNLIGHT_PROJECTILE_BIG, damage, rotationDegrees, 30, 75, 2, 40);
            this.shootProjectile(target, (class_1676)projectile, class_3417.field_14970);
        } else {
            MoonlightProjectile projectile = this.getMoonlightProjectile(EntityRegistry.VERTICAL_SUNLIGHT_PROJECTILE, damage, rotationDegrees, 30, 150, 5, 60);
            projectile.setDespawnParticleExpansion(0.5f);
            this.shootProjectile(target, (class_1676)projectile, class_3417.field_14970);
        }
    }

    private MoonlightProjectile getMoonlightProjectile(class_1299<? extends MoonlightProjectile> type, float damage, int rotationDegrees, int maxAge, int explosionParticleCount, int trailParticleCount, int fireTicksApplied) {
        MoonlightProjectile projectile = new MoonlightProjectile(type, this.boss.method_37908(), (class_1309)this.boss);
        if (this.boss.isEmpowered()) {
            projectile.setAppliedEffectDuration(fireTicksApplied);
        }
        projectile.setAgeAndPoints(maxAge, explosionParticleCount, trailParticleCount);
        projectile.method_7438(this.getModifiedDamage(damage));
        projectile.setModelRotation(rotationDegrees);
        projectile.setDespawnParticle((class_2394)class_2398.field_11240);
        projectile.setTrailParticle((class_2394)class_2398.field_29642);
        return projectile;
    }

    private void flamethrower(class_1309 target, double distance) {
        ++this.attackStatus;
        if (this.attackStatus >= 20 && this.attackStatus < 65 && target.method_24515() != null) {
            class_2338 targetPos;
            double length = 260.0;
            if (distance < length) {
                this.boss.setFlamethrowerTarget(target.method_24515());
                targetPos = new class_2338(target.method_31477(), (int)target.method_23323(0.5), target.method_31479());
            } else {
                double x = target.method_31477() - this.boss.method_31477();
                double y = target.method_23323(0.5) - (double)this.boss.method_31478();
                double z = target.method_31479() - this.boss.method_31479();
                int newX = class_3532.method_15357((double)this.getPointBetweenTwoPos(length, distance, x, this.boss.method_31477()));
                int newY = class_3532.method_15384((double)this.getPointBetweenTwoPos(length, distance, y, this.boss.method_31478()));
                int newZ = class_3532.method_15357((double)this.getPointBetweenTwoPos(length, distance, z, this.boss.method_31479()));
                targetPos = new class_2338(newX, newY, newZ);
                this.boss.setFlamethrowerTarget(targetPos);
            }
            this.boss.setParticleState(1);
            if (this.attackStatus % 4 == 0) {
                class_238 box = new class_238(targetPos.method_46558(), this.boss.method_19538()).method_1014(1.0);
                for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, box)) {
                    class_1309 living;
                    if (!(entity instanceof class_1309) || this.boss.isPartner(living = (class_1309)entity)) continue;
                    living.method_5643(this.boss.method_48923().method_48831(), this.getModifiedDamage(this.boss.isPhaseTwo() ? 2.0f : 1.0f));
                    living.method_5639(3);
                }
                this.playSound(targetPos, class_3417.field_14970, 0.9f, 1.0f);
            }
            if (this.boss.isPhaseTwo()) {
                for (int frame : this.flamethrowerMeleeFrames) {
                    if (this.attackStatus != frame) continue;
                    this.aoeMelee(target, distance, 2.0, 15.0f);
                    this.playSound(null, class_3417.field_14706, 1.0f, 1.0f);
                }
            }
        }
        if (this.attackStatus >= 65) {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 50, 0);
    }

    private double getPointBetweenTwoPos(double maxDistance, double currentDistance, double vecValToTarget, int origin) {
        return (double)origin + maxDistance / currentDistance * vecValToTarget;
    }

    private class_2338 getPosBetweenTwoPos(double maxDistance, double currentDistance, class_243 vecToTarget) {
        int newX = class_3532.method_15357((double)this.getPointBetweenTwoPos(maxDistance, currentDistance, vecToTarget.method_10216(), this.boss.method_31477()));
        int newY = class_3532.method_15357((double)this.getPointBetweenTwoPos(maxDistance, currentDistance, vecToTarget.method_10214(), this.boss.method_31478()));
        int newZ = class_3532.method_15357((double)this.getPointBetweenTwoPos(maxDistance, currentDistance, vecToTarget.method_10215(), this.boss.method_31479()));
        return new class_2338(newX, newY, newZ);
    }

    private void aoeMelee(class_1309 target, double distanceToTarget, double expansion, float damage) {
        class_2338 pos;
        double maxDistance = this.method_6289(target);
        if (this.isInMeleeRange(target)) {
            pos = target.method_24515();
        } else {
            double x = target.method_31477() - this.boss.method_31477();
            double y = target.method_23320() - (double)this.boss.method_31478();
            double z = target.method_31479() - this.boss.method_31479();
            pos = this.getPosBetweenTwoPos(maxDistance, distanceToTarget, new class_243(x, y, z));
        }
        for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(pos).method_1014(expansion))) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity;
            this.damageTarget(living, damage);
        }
    }

    private void sunfireRush(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus == 45 || this.attackStatus == 60) {
            this.shootSunlight(target, 0, 15.0f, 0);
        } else if (this.attackStatus == 71) {
            this.shootSunlight(target, 1, 20.0f, -45);
        } else if (this.attackStatus == 83) {
            this.shootSunlight(target, 1, 20.0f, 45);
        } else if (this.attackStatus == 96) {
            this.shootSunlight(target, 2, 25.0f, 0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 70, 0);
    }

    private void conflagration(class_1309 target) {
        ++this.attackStatus;
        boolean phase2 = this.boss.isPhaseTwo();
        if (!phase2) {
            if (this.attackStatus >= 20 && this.attackStatus <= 40 && this.attackStatus % 4 == 0) {
                double f = target.method_23317() - this.boss.method_23317();
                double g = target.method_23323(0.5) - (this.boss.method_23320() + 1.5);
                double h = target.method_23321() - this.boss.method_23321();
                UntargetableFireball fireballEntity = new UntargetableFireball(this.boss.method_37908(), (class_1309)this.boss, f, g, h, 2);
                fireballEntity.method_5814(this.boss.method_23317(), this.boss.method_23320() + 1.0, fireballEntity.method_23321());
                this.boss.method_37908().method_8649((class_1297)fireballEntity);
            }
        } else {
            this.boss.method_5942().method_6340();
            if (this.attackStatus == 15) {
                GrowingFireball fireballEntity = new GrowingFireball(this.boss.method_37908(), (class_1297)this.boss);
                fireballEntity.method_5814(this.boss.method_23317(), this.boss.method_23320() + 4.0, this.boss.method_23321());
                fireballEntity.setTargetUuid(target.method_5667());
                fireballEntity.setRadiusGrowth(5.0f / (float)fireballEntity.getMaxAge());
                this.boss.method_37908().method_8649((class_1297)fireballEntity);
            }
        }
        this.checkAndReset(phase2 ? 20 : 80, phase2 ? 160 : 0);
    }

    private void blazeBarrage(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        for (int i = 0; i < (this.boss.isPhaseTwo() ? 2 : 1); ++i) {
            double x = target.method_23317() - this.boss.method_23317();
            double y = target.method_23320() - this.boss.method_23323(1.0);
            double z = target.method_23321() - this.boss.method_23321();
            class_243 vec3d = this.boss.method_5828(1.0f);
            class_1677 fireball = new class_1677(this.boss.method_37908(), this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), x, y, z);
            fireball.method_5814(this.boss.method_23317() + vec3d.field_1352 * (double)this.boss.method_6051().method_43048(6) * (double)(this.boss.method_6051().method_43056() ? -1 : 1), this.boss.method_23323(0.5) + (double)this.boss.method_6051().method_43048(4) - 1.0, this.boss.method_23321() + vec3d.field_1350 * (double)this.boss.method_6051().method_43048(6) * (double)(this.boss.method_6051().method_43056() ? -1 : 1));
            this.boss.method_37908().method_8649((class_1297)fireball);
            if (this.attackStatus % 4 != 0) continue;
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14970, class_3419.field_15251, 1.0f, 1.0f);
        }
        this.checkAndReset(40, 0);
    }

    private void flamesEdge() {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (!this.boss.isPhaseTwo()) {
            this.boss.setFlamesEdgeRadius(6.0f);
            if (this.attackStatus >= 5 && this.attackStatus < 22) {
                this.boss.setParticleState(2);
            } else if (this.attackStatus >= 22 && this.attackStatus <= 24) {
                this.boss.setParticleState(3);
            } else if (this.attackStatus >= 25) {
                this.boss.setParticleState(0);
            }
            if (this.attackStatus == 22) {
                this.playSound(null, SoundRegistry.DAY_STALKER_FLAMES_EDGE_NORMAL, 1.0f, 1.0f);
                this.aoe(4.3, 35.0f, 1.0f);
            }
        } else {
            this.boss.setFlamesEdgeRadius(8.0f);
            if (this.attackStatus >= 20 && this.attackStatus < 41) {
                this.boss.setParticleState(2);
            } else if (this.attackStatus >= 41 && this.attackStatus <= 43) {
                this.boss.setParticleState(3);
            } else if (this.attackStatus >= 44) {
                this.boss.setParticleState(0);
            }
            if (this.attackStatus == 41) {
                this.playSound(null, SoundRegistry.DAY_STALKER_FLAMES_EDGE_EMPOWERED, 1.0f, 1.0f);
                this.aoe(6.2, 40.0f, 1.5f);
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 30, 0);
    }

    public void aoe(double expansion, float damage, float knockback) {
        for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(expansion))) {
            class_1309 target;
            if (!(entity instanceof class_1309) || !this.damageTarget(target = (class_1309)entity, damage) || !(knockback > 0.0f)) continue;
            double x = target.method_23317() - this.boss.method_23317();
            double z = target.method_23321() - this.boss.method_23321();
            target.method_6005((double)knockback, -x, -z);
        }
    }

    private void radiance() {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 75) {
            this.playSound(null, SoundRegistry.DAY_STALKER_RADIANCE, 1.0f, 1.0f);
        }
        if (this.attackStatus == 80) {
            CustomDeathHandler.deathExplosionEvent(this.boss.method_37908(), this.boss.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{class_2398.field_11237, class_2398.field_11240});
            this.aoe(4.0, 60.0f, 4.0f);
        }
        this.checkAndReset(40, 140);
    }

    private void warmth() {
        ++this.attackStatus;
        if (this.attackStatus == 84) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_19198, class_3419.field_15251, 1.0f, 1.0f);
            for (int i = 0; i < 4; ++i) {
                WarmthEntity entity = new WarmthEntity(EntityRegistry.WARMTH_ENTITY, this.boss.method_37908());
                class_243 pos = new class_243(this.boss.method_23317() + (double)(this.boss.method_6051().method_39332(2, 5) * (this.boss.method_6051().method_43056() ? -1 : 1)), this.boss.method_23318() + (double)this.boss.method_6051().method_43048(4) + 2.0, this.boss.method_23321() + (double)(this.boss.method_6051().method_39332(2, 5) * (this.boss.method_6051().method_43056() ? -1 : 1)));
                entity.method_33574(this.getAirBlockPos(pos, 0));
                this.boss.method_37908().method_8649((class_1297)entity);
            }
        }
        this.checkAndReset(20, 160);
    }

    private void overheat(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 1) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.OVERHEAT_CHARGE_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            this.boss.method_37908().method_8396(null, target.method_24515(), SoundRegistry.OVERHEAT_CHARGE_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus <= 57) {
            this.targetMaxY = Math.min(target.method_23318(), this.boss.method_23318());
            this.attackRotation = (float)Math.toDegrees(class_3532.method_15349((double)(target.method_23321() - this.boss.method_23321()), (double)(target.method_23317() - this.boss.method_23317())));
        }
        if (this.attackStatus == 67 && this.attackRotation != 0.0f && this.targetMaxY != 0.0) {
            float yaw = this.attackRotation;
            class_243 origin = this.boss.method_19538();
            class_1937 world = this.boss.method_37908();
            double maxYOffset = 10.0;
            int amount = 20;
            float spacing = 2.0f;
            int spreadCount = 4;
            float rad = (float)Math.toRadians(yaw);
            class_243 forward = new class_243(Math.cos(rad), 0.0, Math.sin(rad));
            class_243 rightDir = forward.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            int i = -spreadCount;
            while (i <= spreadCount) {
                class_243 start = origin.method_1019(rightDir.method_1021((double)((float)i * spacing)));
                int finalI = i++;
                WeaponUtil.doConsumerOnLine(world, yaw, start, maxYOffset, amount, spacing, (TriConsumer<class_243, Integer, Float>)((TriConsumer)(vec3d, warmup, y) -> this.spawnFlamePillar((class_243)vec3d, -6 + Math.abs(finalI * 6), (Float)y)));
            }
        }
        this.checkAndReset(40, 0);
    }

    private void inferno() {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 23) {
            this.playSound(null, class_3417.field_14970, 1.0f, 1.0f);
            this.boss.setFlying(true);
            this.boss.method_5762(0.0, 0.75, 0.0);
        }
        if (this.attackStatus == 69) {
            this.boss.setFlying(false);
            this.boss.method_18800(0.0, -2.0, 0.0);
        }
        if (this.attackStatus >= 70 && this.attackStatus <= 100 && this.boss.method_24828() && !this.hasExploded) {
            this.boss.method_37908().method_8437((class_1297)this.boss, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), 6.0f, class_1937.class_7867.field_40888);
            this.hasExploded = true;
        }
        if (this.attackStatus == 125) {
            this.boss.method_37908().method_8437((class_1297)this.boss, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), 8.0f, class_1937.class_7867.field_40888);
        }
        this.checkAndReset(30, 0);
    }

    private void skyHigh() {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 23) {
            this.playSound(null, class_3417.field_14970, 1.0f, 1.0f);
            this.playSound(null, SoundRegistry.NIGHT_PROWLER_SCREAM, 1.0f, 1.0f);
            this.boss.setFlying(true);
            this.flyY = 30.0f;
            this.boss.method_5762(0.0, 1.5, 0.0);
        }
        if (this.attackStatus == 142) {
            this.boss.setFlying(false);
            this.boss.method_18800(0.0, -3.0, 0.0);
        }
        if (this.boss.field_6017 > this.fallDistance) {
            this.fallDistance = this.boss.field_6017;
        }
        if (this.attackStatus >= 146 && this.attackStatus <= 190 && this.boss.method_24828() && !this.hasExploded) {
            float pDistance;
            float power = 20.0f + this.fallDistance;
            float expansion = this.fallDistance / 2.5f;
            class_238 box = this.boss.method_5829().method_1014((double)expansion);
            for (class_1297 targets : this.boss.method_37908().method_8335((class_1297)this.boss, box)) {
                if (!(targets instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)targets;
                this.damageTarget(livingEntity, power);
            }
            WeaponUtil.doConsumerOnCircle(this.boss.method_37908(), this.boss.method_36454(), this.boss.method_19538(), 10.0, 10, new class_241(1.5f, 1.75f), (TriConsumer<class_243, Integer, Float>)((TriConsumer)(vec3d, warmup, yaw) -> this.spawnFlamePillar((class_243)vec3d, warmup - 6, (Float)yaw)));
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
            float f = pDistance = this.fallDistance >= 10.0f ? this.fallDistance / 10.0f : 1.0f;
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), class_3532.method_15375((float)(200.0f * pDistance)), this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), ParticleEvents.DEFAULT_GRAND_SKYFALL_MAP, pDistance);
            }
            this.hasExploded = true;
        }
        this.checkAndReset(5, 80);
    }

    private void flamesReach(class_1309 target, double distance) {
        double maxDistance;
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        double d = maxDistance = this.boss.isPhaseTwo() ? 140.0 : 120.0;
        if (this.attackStatus == 5) {
            this.playSound(null, SoundRegistry.DAY_STALKER_WINDUP, 1.0f, 1.0f);
        }
        if (this.attackStatus == 29) {
            class_2338 targetPos;
            if (distance < maxDistance) {
                targetPos = target.method_24515();
            } else {
                double x = target.method_31477() - this.boss.method_31477();
                double y = target.method_23320() - (double)this.boss.method_31478();
                double z = target.method_31479() - this.boss.method_31479();
                int newX = class_3532.method_15357((double)this.getPointBetweenTwoPos(maxDistance, distance, x, this.boss.method_31477()));
                int newY = class_3532.method_15357((double)this.getPointBetweenTwoPos(maxDistance, distance, y, this.boss.method_31478()));
                int newZ = class_3532.method_15357((double)this.getPointBetweenTwoPos(maxDistance, distance, z, this.boss.method_31479()));
                targetPos = new class_2338(newX, newY, newZ);
            }
            class_238 box = new class_238(targetPos.method_46558(), this.boss.method_19538()).method_1014(1.0);
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, box)) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                this.damageTarget(living, 20.0f);
                double x = target.method_23317() - this.boss.method_23317();
                double z = target.method_23321() - this.boss.method_23321();
                target.method_6005(3.0, x, z);
            }
            this.playSound(targetPos, SoundRegistry.DAY_STALKER_PULL, 1.0f, 1.0f);
        }
        if (this.attackStatus == 43) {
            class_243 vec3d = this.boss.method_5828(1.0f);
            class_243 pos = new class_243((double)this.boss.method_31477() + vec3d.field_1352 * 3.0, (double)this.boss.method_31478(), (double)this.boss.method_31479() + vec3d.field_1350 * 3.0);
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 150, pos.method_10216(), pos.method_10214(), pos.method_10215(), ParticleEvents.DARKIN_BLADE_SLAM_MAP, 1.0f);
            }
            this.playSound(blockPos, class_3417.field_15152, 1.0f, 1.0f);
            if (this.boss.isPhaseTwo()) {
                this.spawnFlamePillar(pos, -6, Float.valueOf(this.boss.method_36454()));
            }
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(blockPos).method_1014(3.0))) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                this.damageTarget(living, 25.0f);
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 40, 0);
    }

    private void playSound(@Nullable class_2338 pos, class_3414 sound, float volume, float pitch) {
        if (pos == null) {
            pos = this.boss.method_24515();
        }
        this.boss.method_37908().method_8396(null, pos, sound, class_3419.field_15251, volume, pitch);
    }

    private class_243 getAirBlockPos(class_243 start, int counter) {
        if (this.boss.method_37908().method_8320(class_2338.method_49638((class_2374)start)).method_26215() || counter >= 5) {
            return start;
        }
        return this.getAirBlockPos(start.method_1031(0.0, 1.0, 0.0), counter + 1);
    }

    protected void method_6288(class_1309 target, double squaredDistance) {
    }

    protected boolean isInMeleeRange(class_1309 target) {
        double distanceToEntity = this.boss.method_5858((class_1297)target);
        return distanceToEntity <= this.method_6289(target);
    }

    private void spawnFlamePillar(class_243 vec, Integer warmup, Float yaw) {
        FlamePillar pillar = new FlamePillar(this.boss.method_37908(), (class_1309)this.boss, 2.5f, warmup, DamagingWarmupEntityEvents.SPAWN_FIRE);
        pillar.method_36456(yaw.floatValue());
        pillar.method_7438(this.getModifiedDamage(40.0f));
        pillar.method_23327(vec.method_10216(), vec.method_10214(), vec.method_10215());
        pillar.setParticleAmountMod(1.5f);
        this.boss.method_37908().method_8649((class_1297)pillar);
        this.boss.method_37908().method_8396(null, class_2338.method_49638((class_2374)vec), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
    }
}

