/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.DraugrBossGoal;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.ShadowOrb;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class NightShadeGoal
extends class_1352 {
    private int attackCooldown;
    private int attackStatus;
    private final NightShade boss;

    public NightShadeGoal(NightShade boss) {
        this.boss = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.boss.method_5968();
        return target != null && target.method_5805() && this.boss.method_18395(target) && this.boss.method_6051().method_43048(7) == 0 && !this.boss.isSpawning();
    }

    public boolean method_6266() {
        return this.boss.getCharging() && this.boss.method_5968() != null && this.boss.method_5968().method_5805();
    }

    public void method_6269() {
        class_1309 livingEntity = this.boss.method_5968();
        if (livingEntity == null) {
            return;
        }
        class_243 vec3d = livingEntity.method_33571();
        this.boss.method_5962().method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
        this.boss.setCharging(true);
    }

    public void method_6270() {
        this.boss.setCharging(false);
        this.reset(0.0f);
    }

    private void reset(float cooldownModifier) {
        this.attackStatus = 0;
        this.attackCooldown = (int)Math.floor(ConfigConstructor.frenzied_shade_cooldown * cooldownModifier);
    }

    private void damageTarget(class_1309 target, float damage) {
        if (target instanceof NightShade) {
            return;
        }
        target.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(damage));
    }

    private float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.frenzied_shade_damage_modifier * (this.boss.isCopy() ? 0.35f : 1.0f);
    }

    private void randomAttack(class_1309 target) {
        if (target == null) {
            this.boss.setAttackState(NightShade.AttackStates.IDLE);
            return;
        }
        int rand = this.boss.method_6051().method_43048(NightShade.AttackStates.values().length);
        NightShade.AttackStates attack = NightShade.AttackStates.values()[rand];
        switch (attack) {
            case GENERIC_CHARGE: 
            case AOE: 
            case BIG_SWIPES: {
                this.boss.setCharging(true);
                this.boss.setAttackState(attack);
                break;
            }
            case THROW_MOONLIGHT: 
            case SHADOW_ORBS: {
                if (this.boss.method_5757()) break;
                this.boss.setCharging(true);
                this.boss.setAttackState(attack);
                break;
            }
            default: {
                this.boss.setAttackState(NightShade.AttackStates.IDLE);
            }
        }
    }

    public void method_6268() {
        if (this.boss.method_29504() || this.boss.getAttackState().equals((Object)NightShade.AttackStates.DUPLICATE) || this.boss.isSpawning()) {
            return;
        }
        --this.attackCooldown;
        class_1309 target = this.boss.method_5968();
        if (target != null) {
            class_243 vec3d = target.method_33571();
            if (this.attackCooldown > 0) {
                this.boss.setAttackState(NightShade.AttackStates.IDLE);
                this.moveRandomSpot(vec3d);
            }
            if (this.attackCooldown < 0 && this.boss.getAttackState().equals((Object)NightShade.AttackStates.IDLE)) {
                this.randomAttack(target);
                this.boss.method_5962().method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
            }
            switch (this.boss.getAttackState()) {
                case BIG_SWIPES: {
                    this.bigSwipes(target);
                    break;
                }
                case GENERIC_CHARGE: {
                    this.genericCharge(target);
                    break;
                }
                case AOE: {
                    this.aoe(target);
                    break;
                }
                case THROW_MOONLIGHT: {
                    this.throwMoonlight(target);
                    break;
                }
                case SHADOW_ORBS: {
                    this.boss.method_5942().method_6340();
                    this.shadowBall(target);
                }
            }
        }
    }

    private void moveRandomSpot(class_243 vec3d) {
        this.boss.method_5962().method_6239(vec3d.field_1352 + (double)this.boss.method_6051().method_43048(60) - 30.0, vec3d.field_1351 + (double)this.boss.method_6051().method_43048(20) - 10.0, vec3d.field_1350 + (double)this.boss.method_6051().method_43048(60) - 30.0, 1.5);
    }

    private void bigSwipes(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus == 1 && target.method_24515() != null) {
            this.boss.setTargetPos(target.method_24515());
        }
        if (DraugrBossGoal.isPosNotNullish(this.boss.getTargetPos())) {
            class_2338 pos = this.boss.getTargetPos();
            this.boss.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            this.boss.method_5962().method_6239((double)((float)pos.method_10263() + 2.5f), (double)((float)pos.method_10264() + 2.0f), (double)((float)pos.method_10260() + 0.5f), 3.0);
            if (this.attackStatus == 9 || this.attackStatus == 16) {
                this.boss.method_37908().method_8396(null, target.method_24515(), class_3417.field_14706, class_3419.field_15251, 1.0f, 1.0f);
                if (!this.boss.method_37908().field_9236) {
                    for (int i = 0; i < 3; ++i) {
                        for (int j = -10; j <= 10; ++j) {
                            ParticleHandler.singleParticle(this.boss.method_37908(), (class_2394)class_2398.field_28479, pos.method_10263(), (float)pos.method_10264() + 0.3f + (float)i / 1.5f, (float)pos.method_10260() + (float)j / 10.0f, 0.0, 0.0, 0.0);
                        }
                    }
                }
                for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(pos).method_1014(2.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = (class_1309)entity;
                    this.damageTarget(living, 20.0f);
                    living.method_6092(new class_1293(class_1294.field_5909, 40, 3));
                }
            }
        }
        if (this.attackStatus >= 22) {
            this.reset(1.0f);
        }
    }

    private void genericCharge(class_1309 target) {
        ++this.attackStatus;
        class_243 vec3d = target.method_33571();
        if (this.attackStatus == 1) {
            this.moveRandomSpot(vec3d);
        } else {
            this.boss.method_5962().method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
        }
        if (this.attackStatus > 6 && this.attackStatus % 2 == 0 && this.attackStatus <= 14) {
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(1.0))) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                this.damageTarget(living, this.attackStatus == 14 ? 18.0f : 12.0f);
            }
        }
        if (this.attackStatus >= 20) {
            this.reset(1.0f);
        }
    }

    private void aoe(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus == 1 && target.method_24515() != null) {
            this.boss.setTargetPos(target.method_24515());
        }
        if (DraugrBossGoal.isPosNotNullish(this.boss.getTargetPos())) {
            class_2338 pos = this.boss.getTargetPos();
            this.boss.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (this.attackStatus < 10) {
                this.boss.method_5962().method_6239((double)pos.method_10263(), (double)((float)pos.method_10264() + 10.0f), (double)pos.method_10260(), 3.0);
            }
            if (this.attackStatus > 10) {
                this.boss.method_5962().method_6239((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 4.0);
                if (this.attackStatus == 16) {
                    if (!this.boss.method_37908().field_9236) {
                        HashMap<class_2394, class_243> map = new HashMap<class_2394, class_243>();
                        map.put((class_2394)class_2398.field_11237, new class_243(1.0, 1.0, 1.0));
                        map.put((class_2394)class_2398.field_22246, new class_243(1.0, 1.0, 1.0));
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 600, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), map, 1.0f);
                    }
                    this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14742, class_3419.field_15251, 0.8f, 1.0f);
                    for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(pos).method_1014(3.0))) {
                        if (!(entity instanceof class_1309)) continue;
                        class_1309 living = (class_1309)entity;
                        this.damageTarget(living, 25.0f);
                        double x = living.method_23317() - this.boss.method_23317();
                        double z = living.method_23321() - this.boss.method_23321();
                        living.method_6005(2.0, -x, -z);
                    }
                }
            }
        }
        if (this.attackStatus >= 22) {
            this.reset(1.0f);
        }
    }

    private void throwMoonlight(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 6) {
            double e = target.method_23317() - this.boss.method_23317();
            double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
            double g = target.method_23321() - this.boss.method_23321();
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15251, 1.0f, 0.75f);
            MoonlightProjectile projectile = new MoonlightProjectile(EntityRegistry.VERTICAL_MOONLIGHT_ENTITY_TYPE, this.boss.method_37908(), (class_1309)this.boss);
            projectile.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            projectile.method_7485(e, f, g, 1.5f, 1.0f);
            projectile.method_7438(this.getModifiedDamage(25.0f));
            projectile.setDespawnParticleExpansion(0.5f);
            projectile.setAgeAndPoints(30, 150, 10);
            this.boss.method_37908().method_8649((class_1297)projectile);
        }
        if (this.attackStatus >= 10) {
            this.reset(1.0f);
        }
    }

    private void shadowBall(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5942().method_6340();
        double e = target.method_23317() - this.boss.method_23317();
        double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
        double g = target.method_23321() - this.boss.method_23321();
        if (this.attackStatus >= 6 && this.attackStatus <= 15) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14970, class_3419.field_15251, 1.0f, 1.0f);
            ShadowOrb orb = new ShadowOrb(this.boss.method_37908(), (class_1309)this.boss, e, f, g, new class_1291[0]);
            orb.method_5814(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            orb.method_7485(e, f, g, 2.0f, 1.0f);
            this.boss.method_37908().method_8649((class_1297)orb);
        }
        if (this.attackStatus == 16) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            MoonlightProjectile projectile = new MoonlightProjectile(EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE, this.boss.method_37908(), (class_1309)this.boss);
            projectile.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            projectile.method_7485(e, f, g, 2.0f, 1.0f);
            projectile.setAgeAndPoints(30, 75, 4);
            projectile.method_7438(this.getModifiedDamage(18.0f));
            this.boss.method_37908().method_8649((class_1297)projectile);
        }
        if (this.attackStatus >= 25) {
            this.reset(1.0f);
        }
    }
}

