/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.FreyrSwordGoal;
import net.soulsweaponry.entitydata.FreyrSwordSummonData;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FreyrSwordEntity
extends class_1321
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final class_1799 stack;
    public static final class_2338 NULLISH_POS = new class_2338(0, 0, 0);
    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(FreyrSwordEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2338> STATIONARY = class_2945.method_12791(FreyrSwordEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> IS_STATIONARY = class_2945.method_12791(FreyrSwordEntity.class, (class_2941)class_2943.field_13323);
    private static final String STACK_NBT = "enchants_list";

    public FreyrSwordEntity(class_1299<? extends FreyrSwordEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.stack = new class_1799((class_1935)WeaponRegistry.FREYR_SWORD);
    }

    public FreyrSwordEntity(class_1937 world, class_1657 owner, class_1799 stack) {
        super(EntityRegistry.FREYR_SWORD_ENTITY_TYPE, world);
        this.stack = stack.method_7972();
        this.method_6173(true);
        this.method_6170(owner);
    }

    public PlayState attack(AnimationState<?> state) {
        if (this.getAnimationAttacking()) {
            state.getController().setAnimation(RawAnimation.begin().then("attack_east", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().stop();
        return PlayState.STOP;
    }

    private PlayState idle(AnimationState<?> state) {
        if (!this.getAnimationAttacking()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController attackController = new AnimationController((GeoAnimatable)this, "attackController", 0, this::attack);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 0, this::idle);
        controllers.add(new AnimationController[]{attackController});
        controllers.add(new AnimationController[]{idleController});
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FreyrSwordGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1588.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1621.class, true));
        super.method_5959();
    }

    public boolean method_5722(class_1297 other) {
        class_6025 tameableOther;
        if (!ConfigConstructor.sword_of_freyr_friendly_fire && other instanceof class_1657) {
            return true;
        }
        if (other instanceof class_6025 && (tameableOther = (class_6025)other).method_35057() != null && this.method_35057() != null && tameableOther.method_35057().equals((Object)this.method_35057())) {
            return true;
        }
        return super.method_5722(other);
    }

    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
    }

    public void method_5958() {
        super.method_5958();
        if (this.method_35057() != null) {
            if (!this.isBlockPosNullish(this.getStationaryPos())) {
                if (this.method_5968() == null || this.method_5707(this.stationaryAsVec3d()) > this.getFollowRange()) {
                    this.method_30634(this.getStationaryPos().method_10263(), this.getStationaryPos().method_10264(), this.getStationaryPos().method_10260());
                    this.setAnimationAttacking(false);
                }
            } else if (this.method_5968() == null || this.method_5858((class_1297)this.method_35057()) > this.getFollowRange()) {
                class_243 vecOwner = this.method_35057().method_5720();
                double xAdd = 0.0;
                if (this.method_35057().method_36455() < -50.0f || this.method_35057().method_36455() > 50.0f) {
                    xAdd = vecOwner.method_10216() > 0.0 ? -1.0 : 1.0;
                }
                class_243 vecEdited = vecOwner.method_1021(-1.5).method_1019(this.method_35057().method_19538()).method_1031(xAdd, 0.0, 0.0);
                this.method_5641(vecEdited.method_10216(), this.method_35057().method_23318(), vecEdited.method_10215(), this.method_35057().method_36454() / 2.0f, this.method_35057().method_36455());
                this.setAnimationAttacking(false);
            }
        }
    }

    public class_1924 method_48926() {
        return super.method_37908();
    }

    public int method_5669() {
        return 300;
    }

    @Nullable
    public class_1309 method_35057() {
        try {
            class_1657 owner;
            UUID uUID = this.method_6139();
            class_1657 class_16572 = owner = uUID == null ? null : this.method_37908().method_18470(uUID);
            if (owner instanceof class_1657) {
                class_1657 player = owner;
                UUID swordUuid = FreyrSwordSummonData.getSummonUuid((class_1309)player);
                if (swordUuid != null && swordUuid.equals(this.method_5667())) {
                    return owner;
                }
                return null;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_35057() == null || this.method_35057() != null && this.method_35057().equals((Object)player)) {
            if (!this.insertStack(player)) {
                this.method_23327(player.method_23317(), player.method_23320(), player.method_23321());
                this.dropStack();
            }
            this.method_31472();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public boolean insertStack(class_1657 player) {
        int slot = player.method_31548().field_7545;
        if (!player.method_31548().method_7391().method_7960()) {
            slot = -1;
        }
        return player.method_31548().method_7367(slot, this.asItemStack());
    }

    public void dropStack() {
        class_1542 entity = this.method_5775(this.stack);
        if (entity != null) {
            entity.method_6976();
        }
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.method_37908().field_9236 && this.method_24515() != null) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15075, class_3419.field_15248, 1.0f, 1.0f);
            this.stack.method_7970(10, this.method_6051(), null);
            if (this.stack.method_7936() - this.stack.method_7919() > 0) {
                class_1309 class_13092;
                if (this.method_35057() != null && (class_13092 = this.method_35057()) instanceof class_1657) {
                    class_1657 player = (class_1657)class_13092;
                    if (!this.insertStack(player)) {
                        this.method_23327(player.method_23317(), player.method_23320(), player.method_23321());
                        this.dropStack();
                    }
                } else {
                    this.dropStack();
                }
            }
        }
        super.method_6078(damageSource);
    }

    public boolean method_5822() {
        return false;
    }

    public boolean isBlockPosNullish(class_2338 pos) {
        return pos.method_10263() == 0 && pos.method_10264() == 0 && pos.method_10260() == 0;
    }

    public void method_6007() {
        super.method_6007();
        if (this.field_6012 % 4 == 0) {
            double random = this.method_6051().method_43058();
            this.method_37908().method_8466((class_2394)class_2398.field_28479, false, this.method_23317() + random / 4.0 - random / 8.0, this.method_23320() - random * 6.0 + random * 6.0 / 2.0, this.method_23321() + random / 4.0 - random / 8.0, random / 16.0 - random / 32.0, random - random / 2.0, random / 16.0 - random / 32.0);
        }
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5740() {
        return true;
    }

    public int getNoOwnerAge() {
        return 60;
    }

    public static class_5132.class_5133 createEntityAttributes() {
        return class_1314.method_26827().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23716, ConfigConstructor.sword_of_freyr_health).method_26868(class_5134.field_23724, ConfigConstructor.sword_of_freyr_armor).method_26868(class_5134.field_23721, (double)ConfigConstructor.sword_of_freyr_damage);
    }

    public double getFollowRange() {
        return this.method_26825(class_5134.field_23717);
    }

    public class_1799 asItemStack() {
        return this.stack;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setAnimationAttacking(boolean bl) {
        this.field_6011.method_12778(ATTACKING, (Object)bl);
    }

    private boolean getAnimationAttacking() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    public class_2338 getStationaryPos() {
        return (class_2338)this.field_6011.method_12789(STATIONARY);
    }

    public void setStationaryPos(class_2338 pos) {
        if (((Boolean)this.field_6011.method_12789(IS_STATIONARY)).booleanValue()) {
            this.field_6011.method_12778(STATIONARY, (Object)NULLISH_POS);
            this.field_6011.method_12778(IS_STATIONARY, (Object)false);
        } else {
            this.field_6011.method_12778(STATIONARY, (Object)pos);
            this.field_6011.method_12778(IS_STATIONARY, (Object)true);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() != null && this.method_35057() != null && source.method_5529().equals((Object)this.method_35057())) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public class_243 stationaryAsVec3d() {
        return new class_243((double)this.getStationaryPos().method_10263(), (double)this.getStationaryPos().method_10264(), (double)this.getStationaryPos().method_10260());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(STATIONARY, (Object)NULLISH_POS);
        this.field_6011.method_12784(IS_STATIONARY, (Object)Boolean.FALSE);
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14670;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14742;
    }

    public class_1296 method_5613(class_3218 var1, class_1296 var2) {
        return null;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_1799 itemStack = this.asItemStack();
        if (itemStack.method_7969() != null) {
            nbt.method_10566(STACK_NBT, (class_2520)itemStack.method_7969());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(STACK_NBT)) {
            this.stack.method_7980((class_2487)nbt.method_10580(STACK_NBT));
        }
    }
}

