/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.MoonknightGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.networking.PacketHelper;
import net.soulsweaponry.networking.PacketIds;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Moonknight
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private int phaseTransitionTicks;
    private final int phaseTransitionMaxTicks = 120;
    private int blockBreakingCooldown;
    private final List<class_1299<?>> absorbedProjectileTypes = new ArrayList();
    private final List<Float> absorbedProjectileDamage = new ArrayList<Float>();
    public float prevBeamHeight;
    @Environment(value=EnvType.CLIENT)
    public float renderBeamHeight;
    private static final class_2940<Boolean> SPAWNING = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> INITIATE_PHASE_2 = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PHASE_2 = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_BEAM = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SWORD_CHARGING = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ATTACK = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> BEAM_LOCATION = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Float> BEAM_HEIGHT = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> INITIATED_PHASE_2 = class_2945.method_12791(Moonknight.class, (class_2941)class_2943.field_13323);

    public Moonknight(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5786);
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 50.0).method_26868(class_5134.field_23716, ConfigConstructor.fallen_icon_health).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, 15.0).method_26868(class_5134.field_23718, 10.0).method_26868(class_5134.field_23724, ConfigConstructor.fallen_icon_armor);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return fallDistance > 6.0f ? super.method_23329(fallDistance, damageMultiplier) : 0;
    }

    public void setSpawning(boolean bl) {
        this.field_6011.method_12778(SPAWNING, (Object)bl);
    }

    @Override
    public boolean isSpawning() {
        return (Boolean)this.field_6011.method_12789(SPAWNING);
    }

    public void initiatePhaseTwo(boolean bl) {
        this.field_6011.method_12778(INITIATE_PHASE_2, (Object)bl);
    }

    public boolean isInitiatingPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(INITIATE_PHASE_2);
    }

    public void setPhaseTwo(boolean bl) {
        this.field_6011.method_12778(PHASE_2, (Object)bl);
    }

    public boolean isPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(PHASE_2);
    }

    public void setCanBeam(boolean bl) {
        this.field_6011.method_12778(CAN_BEAM, (Object)bl);
    }

    public boolean getCanBeam() {
        return (Boolean)this.field_6011.method_12789(CAN_BEAM);
    }

    public void setBeamLocation(class_2338 pos) {
        this.field_6011.method_12778(BEAM_LOCATION, (Object)pos);
    }

    public class_2338 getBeamLocation() {
        return (class_2338)this.field_6011.method_12789(BEAM_LOCATION);
    }

    public void setBeamHeight(float fl) {
        this.field_6011.method_12778(BEAM_HEIGHT, (Object)Float.valueOf(fl));
    }

    public float getBeamHeight() {
        return ((Float)this.field_6011.method_12789(BEAM_HEIGHT)).floatValue();
    }

    public void setChargingSword(boolean bl) {
        this.field_6011.method_12778(IS_SWORD_CHARGING, (Object)bl);
    }

    public boolean isSwordCharging() {
        return (Boolean)this.field_6011.method_12789(IS_SWORD_CHARGING);
    }

    public void setInitiatedPhaseTwo(boolean bl) {
        this.field_6011.method_12778(INITIATED_PHASE_2, (Object)bl);
    }

    public boolean initiatedPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(INITIATED_PHASE_2);
    }

    public List<class_1299<?>> getAbsorbedProjectileTypes() {
        return this.absorbedProjectileTypes;
    }

    public List<Float> getAbsorbedProjectileDamage() {
        return this.absorbedProjectileDamage;
    }

    public void clearAbsorbedProjectiles() {
        this.absorbedProjectileTypes.clear();
        this.absorbedProjectileDamage.clear();
    }

    public void setPhaseOneAttack(MoonknightPhaseOne phaseOneAttack) {
        for (int i = 0; i < MoonknightPhaseOne.values().length; ++i) {
            if (!MoonknightPhaseOne.values()[i].equals((Object)phaseOneAttack)) continue;
            this.field_6011.method_12778(ATTACK, (Object)i);
            return;
        }
    }

    public MoonknightPhaseOne getPhaseOneAttack() {
        return MoonknightPhaseOne.values()[(Integer)this.field_6011.method_12789(ATTACK)];
    }

    public void setPhaseTwoAttack(MoonknightPhaseTwo phaseTwoAttack) {
        for (int i = 0; i < MoonknightPhaseTwo.values().length; ++i) {
            if (!MoonknightPhaseTwo.values()[i].equals((Object)phaseTwoAttack)) continue;
            this.field_6011.method_12778(ATTACK, (Object)i);
            return;
        }
    }

    public MoonknightPhaseTwo getPhaseTwoAttack() {
        return MoonknightPhaseTwo.values()[(Integer)this.field_6011.method_12789(ATTACK)];
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1676 projectile;
        if (this.blockBreakingCooldown <= 0) {
            this.blockBreakingCooldown = 20;
        }
        if (this.isInitiatingPhaseTwo()) {
            return false;
        }
        if (!this.isPhaseTwo() && this.method_6032() - amount < 1.0f) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_2540 buf = PacketByteBufs.create();
                buf.method_10812(this.getBossMusic().method_14833());
                PacketHelper.sendToAllPlayersS2C(serverWorld, this.method_24515(), PacketIds.STOP_BOSS_MUSIC, buf);
                this.setPlayingMusic(false);
            }
            this.method_6012();
            this.initiatePhaseTwo(true);
            this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.KNIGHT_DEATH_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        class_1297 entity = source.method_5526();
        if (entity instanceof class_1676 && !this.isProjectileWhitelisted((class_1297)(projectile = (class_1676)entity)) && entity.method_24515() != null) {
            ParticleHandler.particleSphereList(this.method_37908(), 10, entity.method_23317(), entity.method_23318(), entity.method_23321(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            if (projectile.method_24921() != null && projectile.method_24921().equals((Object)this)) {
                projectile.method_31472();
                return false;
            }
            for (int i = 0; i < 3; ++i) {
                this.absorbedProjectileTypes.add(projectile.method_5864());
                this.absorbedProjectileDamage.add(Float.valueOf(amount));
            }
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public String[] getWhitelistedProjectiles() {
        return ConfigConstructor.fallen_icon_projectile_immunity_whitelist;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.fallen_icon_status_effect_blacklist;
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.fallen_icon_xp;
    }

    @Override
    public void method_5773() {
        this.prevBeamHeight = this.getBeamHeight();
        super.method_5773();
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        if (this.isInitiatingPhaseTwo()) {
            ++this.phaseTransitionTicks;
            this.tryToPlayBossMusic();
            if (this.phaseTransitionTicks >= 40) {
                int maxHealTicks = this.phaseTransitionMaxTicks - 40;
                float healPerTick = this.method_6063() / (float)maxHealTicks;
                this.method_6025(healPerTick);
                if (this.phaseTransitionTicks <= 92 && !this.method_37908().field_9236) {
                    ParticleHandler.particleOutburstMap(this.method_37908(), 30, this.method_23317(), this.method_23318(), this.method_23321(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
            }
            if (this.phaseTransitionTicks == 89) {
                CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{ParticleRegistry.NIGHTFALL_PARTICLE, class_2398.field_22246, class_2398.field_11237});
            }
            if (this.phaseTransitionTicks == 96) {
                this.setInitiatedPhaseTwo(true);
            }
            if (this.phaseTransitionTicks >= this.phaseTransitionMaxTicks) {
                this.setPhaseTwo(true);
                this.initiatePhaseTwo(false);
                this.setPhaseTwoAttack(MoonknightPhaseTwo.IDLE);
                this.method_5665((class_2561)class_2561.method_43471((String)"entity.soulsweapons.moonknight_phase_2"));
                this.bossBar.method_5416(class_1259.class_1260.field_5780);
            }
        }
        if (ConfigConstructor.can_bosses_break_blocks && this.blockBreakingCooldown > 0) {
            --this.blockBreakingCooldown;
            if (this.blockBreakingCooldown == 0 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                int i = class_3532.method_15357((double)this.method_23318());
                int j = class_3532.method_15357((double)this.method_23317());
                int k = class_3532.method_15357((double)this.method_23321());
                for (int l = -3; l <= 3; ++l) {
                    for (int m = -3; m <= 3; ++m) {
                        for (int n = 0; n <= 8; ++n) {
                            if (this.method_37908().method_8320(new class_2338(j + l, i + n, k + m)).method_26204() instanceof class_2237) continue;
                            this.method_37908().method_22352(new class_2338(j + l, i + n, k + m), true);
                        }
                    }
                }
            }
        }
    }

    @Override
    public class_3414 getBossMusic() {
        return SoundRegistry.FALLEN_ICON_SONG;
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    public void method_6007() {
        super.method_6007();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            this.summonParticles();
            if (this.spawnTicks % 10 == 0) {
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14742, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.spawnTicks >= 80) {
                this.setSpawning(false);
                this.setPhaseOneAttack(MoonknightPhaseOne.IDLE);
            }
        }
        if (this.method_37908().field_9236 && !this.method_29504() && this.isPhaseTwo() && this.getPhaseTwoAttack().equals((Object)MoonknightPhaseTwo.CORE_BEAM) && this.getCanBeam() && !this.isPosNullish(this.getBeamLocation())) {
            class_243 start = this.method_19538().method_1031(0.0, 6.0, 0.0);
            class_243 end = this.getBeamLocation().method_46558().method_1031(0.0, (double)this.renderBeamHeight, 0.0);
            class_243 between = new class_243(end.method_10216() - start.method_10216(), end.method_10214() - start.method_10214(), end.method_10215() - start.method_10215());
            int numberOfParticles = 20;
            double stepSize = 1.0 / (double)numberOfParticles;
            for (double progress = 0.0; progress < 1.0; progress += stepSize) {
                class_243 particlePos = start.method_1019(between.method_1021(progress));
                this.method_37908().method_8406((class_2394)class_2398.field_22246, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215(), this.field_5974.method_43058() - (double)0.05f, this.field_5974.method_43058() - (double)0.05f, this.field_5974.method_43058() - (double)0.05f);
            }
            double d = this.field_5974.method_43059() * 0.05;
            double q = this.field_5974.method_43059() * 0.05;
            for (int i = 0; i < 2; ++i) {
                double newX = this.field_5974.method_43058() - 0.5 + this.field_5974.method_43059() * 0.15 + d;
                double newZ = this.field_5974.method_43058() - 0.5 + this.field_5974.method_43059() * 0.15 + q;
                double newY = this.field_5974.method_43058() - 0.5 + this.field_5974.method_43058() * 0.5;
                this.method_37908().method_8406((class_2394)class_2398.field_29643, this.method_23317(), this.method_23318() + 5.5, this.method_23321(), newX * 25.0, newY * 18.0, newZ * 25.0);
            }
        }
        if (this.isPhaseTwo() && !this.method_29504() && this.isSwordCharging() && this.getPhaseTwoAttack().equals((Object)MoonknightPhaseTwo.IDLE)) {
            this.setChargingSword(false);
        }
    }

    private boolean isPosNullish(class_2338 pos) {
        return pos.method_10263() == 0 && pos.method_10264() == 0 && pos.method_10260() == 0;
    }

    private void summonParticles() {
        if (this.method_37908().field_9236) {
            for (int i = 0; i < 50; ++i) {
                class_5819 random = this.method_6051();
                double d = random.method_43059() * 0.05;
                double e = random.method_43059() * 0.05;
                double newX = random.method_43058() - 0.5 + random.method_43059() * 0.15 + d;
                double newZ = random.method_43058() - 0.5 + random.method_43059() * 0.15 + e;
                double newY = random.method_43058() - 0.5 + random.method_43058() * 0.5;
                this.method_37908().method_8406((class_2394)class_2398.field_23114, this.method_23317(), this.method_23318(), this.method_23321(), newX / 2.0, newY / 2.0, newZ / 2.0);
                this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23317(), this.method_23318(), this.method_23321(), newX / 2.0, newY / 2.0, newZ / 2.0);
            }
        }
    }

    @Override
    public int getTicksUntilDeath() {
        return 100;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks == 40 && this.method_24515() != null) {
            this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.KNIGHT_DEATH_LAUGH_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{ParticleRegistry.NIGHTFALL_PARTICLE, class_2398.field_22246, class_2398.field_11237});
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public boolean method_5753() {
        return ConfigConstructor.fallen_icon_is_fire_immune;
    }

    @Override
    public boolean method_5999() {
        return ConfigConstructor.fallen_icon_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.fallen_icon_group_type;
    }

    @Override
    public boolean method_42149() {
        return ConfigConstructor.fallen_icon_disables_shields;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 0, this::mainAnimations);
        AnimationController cape = new AnimationController((GeoAnimatable)this, "cape", 0, this::cape);
        AnimationController phase = new AnimationController((GeoAnimatable)this, "phase", 0, this::phase);
        AnimationController heart = new AnimationController((GeoAnimatable)this, "heart", 0, this::heart);
        controllers.add(new AnimationController[]{main});
        controllers.add(new AnimationController[]{cape});
        controllers.add(new AnimationController[]{phase});
        controllers.add(new AnimationController[]{heart});
        main.setParticleKeyframeHandler(this::particleListener);
    }

    private void particleListener(ParticleKeyframeEvent<Moonknight> moonknightParticleKeyframeEvent) {
        this.setChargingSword(!this.isSwordCharging());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new MoonknightGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 12.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        super.method_5959();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected class_3414 method_5994() {
        return SoundRegistry.DEATH_SCREAMS_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundRegistry.KNIGHT_HIT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundRegistry.KNIGHT_DEATH_EVENT;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SPAWNING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(PHASE_2, (Object)Boolean.FALSE);
        this.field_6011.method_12784(INITIATE_PHASE_2, (Object)Boolean.FALSE);
        this.field_6011.method_12784(CAN_BEAM, (Object)Boolean.FALSE);
        this.field_6011.method_12784(IS_SWORD_CHARGING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(ATTACK, (Object)0);
        this.field_6011.method_12784(BEAM_LOCATION, (Object)new class_2338(0, 0, 0));
        this.field_6011.method_12784(BEAM_HEIGHT, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(INITIATED_PHASE_2, (Object)false);
    }

    private PlayState heart(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().thenPlay("idle_heart"));
        return PlayState.CONTINUE;
    }

    private PlayState phase(AnimationState<?> state) {
        if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        } else if (this.isPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("phase_2"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("phase_1"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState cape(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().thenPlay("idle_cape"));
        return PlayState.CONTINUE;
    }

    private PlayState mainAnimations(AnimationState<?> state) {
        if (this.method_29504()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("death_phase_2"));
        } else if (this.isSpawning()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("spawn_phase_1"));
        } else if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("initiate_phase_2"));
        } else if (this.isPhaseTwo()) {
            switch (this.getPhaseTwoAttack().ordinal()) {
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("blinding_light"));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("core_beam_phase_2"));
                    break;
                }
                case 0: {
                    if (this.method_6510()) {
                        state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
                        break;
                    }
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                    break;
                }
                case 2: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("obliterate_phase_2"));
                    break;
                }
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("moon_explosion_phase_2"));
                    break;
                }
                case 1: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("sword_of_light_phase_2"));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("thrust_phase_2"));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("rupture_phase_2"));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("heavy_swing_phase_2"));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("unbreakable"));
                }
            }
        } else {
            switch (this.getPhaseOneAttack().ordinal()) {
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("blinding_light"));
                    break;
                }
                case 0: {
                    if (this.method_6510()) {
                        state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
                        break;
                    }
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                    break;
                }
                case 1: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("mace_of_spades_phase_1"));
                    break;
                }
                case 2: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("obliterate_phase_1"));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("rupture_phase_1"));
                    break;
                }
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("summon_warriors_phase_1"));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("unbreakable"));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public static enum MoonknightPhaseOne {
        IDLE,
        MACE_OF_SPADES,
        OBLITERATE,
        SUMMON,
        RUPTURE,
        BLINDING_LIGHT,
        UNBREAKABLE;

    }

    public static enum MoonknightPhaseTwo {
        IDLE,
        SWORD_OF_LIGHT,
        MOONFALL,
        MOONVEIL,
        THRUST,
        BLINDING_LIGHT,
        CORE_BEAM,
        RUPTURE,
        HEAVY_SWING,
        UNBREAKABLE;

    }
}

