/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.soulsweaponry.entity.AreaEffectSphere;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.projectile.UntargetableFireball;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.registry.EntityRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GrowingFireball
extends UntargetableFireball
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int maxAge = 126;
    private boolean hasChangedCourse;
    private static final class_2940<Optional<UUID>> TARGET_UUID = class_2945.method_12791(GrowingFireball.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Float> RADIUS = class_2945.method_12791(GrowingFireball.class, (class_2941)class_2943.field_13320);
    private float radiusGrowth;

    public GrowingFireball(class_1299<? extends GrowingFireball> entityType, class_1937 world) {
        super(entityType, world);
    }

    public GrowingFireball(class_1937 world, class_1297 owner) {
        super(EntityRegistry.GROWING_FIREBALL_ENTITY, world);
        this.method_7432(owner);
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !(entity instanceof DayStalker) && !(entity instanceof NightProwler);
    }

    public void method_5773() {
        class_1297 target;
        super.method_5773();
        float radius = this.getRadius();
        if (this.method_37908().field_9236 && this.field_5974.method_43056()) {
            int points = class_3532.method_15375((float)(this.getRadius() * 4.0f));
            AreaEffectSphere.randomParticleBox(this.method_37908(), this.method_23317(), this.method_23318() + (double)(this.getRadius() / 2.0f), this.method_23321(), points, this.getRadius() * 0.5f, (class_2394)class_2398.field_11240, this.field_5974);
        }
        if (this.radiusGrowth != 0.0f) {
            if ((radius += this.radiusGrowth) < 0.5f) {
                this.method_31472();
                return;
            }
            this.setRadius(radius);
        }
        if (!this.method_37908().field_9236 && this.field_6012 >= this.getMaxAge() && !this.hasChangedCourse && (target = this.getSavedTarget((class_3218)this.method_37908())) != null) {
            double f = target.method_23317() - this.method_23317();
            double g = target.method_23323(0.5) - this.method_23323(0.5);
            double h = target.method_23321() - this.method_23321();
            this.method_7485(f, g, h, 1.0f, 1.0f);
            this.hasChangedCourse = true;
        }
        if (this.field_6012 >= this.getMaxAge() * 3) {
            this.detonate();
        }
        if (!(this.method_24921() instanceof DayStalker) && !this.method_37908().field_9236) {
            for (class_1297 entity : this.method_37908().method_8335((class_1297)this, this.method_5829())) {
                if (this.method_34714(entity) || !(entity instanceof class_1309)) continue;
                this.detonate();
            }
        }
    }

    public float getExplosionPower() {
        return 1.0f + this.getRadius();
    }

    protected float method_7466() {
        return 1.0f;
    }

    protected void method_7488(class_239 hitResult) {
        class_239.class_240 type = hitResult.method_17783();
        if (type == class_239.class_240.field_1331) {
            class_1657 player;
            class_1297 class_12972 = ((class_3966)hitResult).method_17782();
            if (class_12972 instanceof class_1657 && ParryData.successfulParry(player = (class_1657)class_12972, false, this.method_48923().method_48819((class_1297)this, this.method_24921())) && !this.method_37908().field_9236) {
                class_243 vec3d = player.method_5720();
                this.method_18799(vec3d);
                this.field_7601 = vec3d.field_1352 * 0.1;
                this.field_7600 = vec3d.field_1351 * 0.1;
                this.field_7599 = vec3d.field_1350 * 0.1;
                this.method_7432((class_1297)player);
                return;
            }
            this.method_7454((class_3966)hitResult);
            this.method_37908().method_32888(class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43286((class_1297)this, null));
        } else if (type == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.method_24920(blockHitResult);
            class_2338 blockPos = blockHitResult.method_17777();
            this.method_37908().method_43276(class_5712.field_28162, blockPos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockPos)));
        }
        this.detonate();
    }

    private void detonate() {
        if (!this.method_37908().field_9236) {
            boolean bl = this.method_37908().method_8450().method_8355(class_1928.field_19388);
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), this.getExplosionPower(), bl, class_1937.class_7867.field_40890);
            this.method_31472();
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TARGET_UUID, Optional.empty());
        this.method_5841().method_12784(RADIUS, (Object)Float.valueOf(0.5f));
    }

    public void setRadius(float radius) {
        if (!this.method_37908().field_9236) {
            this.method_5841().method_12778(RADIUS, (Object)Float.valueOf(class_3532.method_15363((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public float getRadius() {
        return ((Float)this.method_5841().method_12789(RADIUS)).floatValue();
    }

    public void setTargetUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(TARGET_UUID, Optional.ofNullable(uuid));
    }

    public UUID getTargetUuid() {
        return ((Optional)this.field_6011.method_12789(TARGET_UUID)).orElse(null);
    }

    @Nullable
    public class_1297 getSavedTarget(class_3218 world) {
        return world.method_14190(this.getTargetUuid());
    }

    public void setMaxAge(int age) {
        this.maxAge = age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setRadiusGrowth(float radiusGrowth) {
        this.radiusGrowth = radiusGrowth;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("MaxAge", this.getMaxAge());
        if (this.getTargetUuid() != null) {
            nbt.method_25927("TargetUuid", this.getTargetUuid());
        }
        nbt.method_10556("ChangedCourse", this.hasChangedCourse);
        nbt.method_10548("RadiusPerTick", this.radiusGrowth);
        nbt.method_10548("Radius", this.getRadius());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("MaxAge")) {
            this.setMaxAge(nbt.method_10550("MaxAge"));
        }
        UUID uUID = null;
        if (nbt.method_25928("TargetUuid")) {
            uUID = nbt.method_25926("TargetUuid");
        }
        if (uUID != null) {
            try {
                this.setTargetUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.method_10545("ChangedCourse")) {
            this.hasChangedCourse = nbt.method_10577("ChangedCourse");
        }
        if (nbt.method_10545("RadiusPerTick")) {
            this.radiusGrowth = nbt.method_10583("RadiusPerTick");
        }
        if (nbt.method_10545("Radius")) {
            this.setRadius(nbt.method_10583("Radius"));
        }
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("spin2", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

