/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.soulsweaponry.registry.ParticleRegistry;
import org.slf4j.Logger;

public abstract class ModPersistentProjectile
extends class_1665 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_1799 stack;
    private int maxAge;
    private static final class_2940<Float> WIDTH = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> HEIGHT = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> DESPAWN_PARTICLE_COUNT = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TRAIL_PARTICLE_COUNT = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> AREA_PARTICLE_COUNT = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DESPAWN_PARTICLE_EXPANSION = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_2394> DESPAWN_PARTICLE = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<class_2394> TRAIL_PARTICLE = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<class_2394> AREA_PARTICLE = class_2945.method_12791(ModPersistentProjectile.class, (class_2941)class_2943.field_13314);

    public ModPersistentProjectile(class_1299<? extends class_1665> type, class_1309 owner, class_1937 world) {
        super(type, owner, world);
        this.setBoundingBoxWidth(type.method_18386().field_18067);
        this.setBoundingBoxHeight(type.method_18386().field_18068);
    }

    public ModPersistentProjectile(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.setBoundingBoxWidth(entityType.method_18386().field_18067);
        this.setBoundingBoxHeight(entityType.method_18386().field_18068);
    }

    public ModPersistentProjectile(class_1299<? extends class_1665> type, double x, double y, double z, class_1937 world) {
        super(type, x, y, z, world);
        this.setBoundingBoxWidth(type.method_18386().field_18067);
        this.setBoundingBoxHeight(type.method_18386().field_18068);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(WIDTH, (Object)Float.valueOf(1.85f));
        this.field_6011.method_12784(HEIGHT, (Object)Float.valueOf(1.85f));
        this.field_6011.method_12784(DESPAWN_PARTICLE_COUNT, (Object)75);
        this.field_6011.method_12784(TRAIL_PARTICLE_COUNT, (Object)4);
        this.field_6011.method_12784(AREA_PARTICLE_COUNT, (Object)0);
        this.field_6011.method_12784(DESPAWN_PARTICLE_EXPANSION, (Object)Float.valueOf(0.125f));
        this.field_6011.method_12784(DESPAWN_PARTICLE, (Object)class_2398.field_22246);
        this.field_6011.method_12784(TRAIL_PARTICLE, (Object)class_2398.field_28479);
        this.field_6011.method_12784(AREA_PARTICLE, (Object)ParticleRegistry.NIGHTFALL_PARTICLE);
    }

    public void method_5674(class_2940<?> data) {
        if (WIDTH.equals(data) || HEIGHT.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)this.getBoundingBoxWidth(), (float)this.getBoundingBoxHeight());
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Stack", 10)) {
            this.stack = class_1799.method_7915((class_2487)nbt.method_10562("Stack"));
        }
        if (nbt.method_10545("BoundingBoxWidth")) {
            this.setBoundingBoxWidth(nbt.method_10583("BoundingBoxWidth"));
        }
        if (nbt.method_10545("BoundingBoxHeight")) {
            this.setBoundingBoxHeight(nbt.method_10583("BoundingBoxHeight"));
        }
        if (nbt.method_10545("MaxAge")) {
            this.maxAge = nbt.method_10550("MaxAge");
        }
        if (nbt.method_10573("AreaParticle", 8)) {
            try {
                this.setAreaParticle(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("AreaParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("AreaParticle"), (Object)var5);
            }
        }
        if (nbt.method_10573("TrailParticle", 8)) {
            try {
                this.setTrailParticle(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("TrailParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("TrailParticle"), (Object)var5);
            }
        }
        if (nbt.method_10573("DespawnParticle", 8)) {
            try {
                this.setDespawnParticle(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("DespawnParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("DespawnParticle"), (Object)var5);
            }
        }
        if (nbt.method_10545("AreaParticleCount")) {
            this.setAreaParticleCount(nbt.method_10550("AreaParticleCount"));
        }
        if (nbt.method_10545("TrailParticleCount")) {
            this.setTrailParticleCount(nbt.method_10550("TrailParticleCount"));
        }
        if (nbt.method_10545("DespawnParticleCount")) {
            this.setDespawnParticleCount(nbt.method_10550("DespawnParticleCount"));
        }
        if (nbt.method_10545("DespawnParticleExpansion")) {
            this.setDespawnParticleExpansion(nbt.method_10583("DespawnParticleExpansion"));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.stack != null) {
            nbt.method_10566("Stack", (class_2520)this.stack.method_7953(new class_2487()));
        }
        nbt.method_10548("BoundingBoxWidth", this.getBoundingBoxWidth());
        nbt.method_10548("BoundingBoxHeight", this.getBoundingBoxHeight());
        nbt.method_10569("MaxAge", this.maxAge);
        nbt.method_10582("AreaParticle", this.getAreaParticle().method_10293());
        nbt.method_10582("TrailParticle", this.getTrailParticle().method_10293());
        nbt.method_10582("DespawnParticle", this.getDespawnParticle().method_10293());
        nbt.method_10569("AreaParticleCount", this.getAreaParticleCount());
        nbt.method_10569("TrailParticleCount", this.getTrailParticleCount());
        nbt.method_10569("DespawnParticleCount", this.getDespawnParticleCount());
        nbt.method_10548("DespawnParticleExpansion", this.getDespawnParticleExpansion());
    }

    protected class_1799 method_7445() {
        return this.stack;
    }

    public void setItemStack(class_1799 stackShotFrom) {
        this.stack = stackShotFrom;
    }

    public void setRadius(float radius) {
        this.field_6011.method_12778(WIDTH, (Object)Float.valueOf(radius));
        this.field_6011.method_12778(HEIGHT, (Object)Float.valueOf(radius));
    }

    public float getBoundingBoxWidth() {
        return ((Float)this.field_6011.method_12789(WIDTH)).floatValue();
    }

    public float getBoundingBoxHeight() {
        return ((Float)this.field_6011.method_12789(HEIGHT)).floatValue();
    }

    public void setBoundingBoxWidth(float width) {
        this.field_6011.method_12778(WIDTH, (Object)Float.valueOf(width));
    }

    public void setBoundingBoxHeight(float height) {
        this.field_6011.method_12778(HEIGHT, (Object)Float.valueOf(height));
    }

    public float getRadius() {
        return Math.max(this.getBoundingBoxWidth(), this.getBoundingBoxHeight());
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getAreaParticleCount() {
        return (Integer)this.field_6011.method_12789(AREA_PARTICLE_COUNT);
    }

    public void setAreaParticleCount(int areaParticleCount) {
        this.field_6011.method_12778(AREA_PARTICLE_COUNT, (Object)areaParticleCount);
    }

    public class_2394 getAreaParticle() {
        return (class_2394)this.field_6011.method_12789(AREA_PARTICLE);
    }

    public void setAreaParticle(class_2394 areaParticle) {
        this.field_6011.method_12778(AREA_PARTICLE, (Object)areaParticle);
    }

    public int getTrailParticleCount() {
        return (Integer)this.field_6011.method_12789(TRAIL_PARTICLE_COUNT);
    }

    public void setTrailParticleCount(int trailParticleCount) {
        this.field_6011.method_12778(TRAIL_PARTICLE_COUNT, (Object)trailParticleCount);
    }

    public class_2394 getTrailParticle() {
        return (class_2394)this.field_6011.method_12789(TRAIL_PARTICLE);
    }

    public void setTrailParticle(class_2394 trailParticle) {
        this.field_6011.method_12778(TRAIL_PARTICLE, (Object)trailParticle);
    }

    public int getDespawnParticleCount() {
        return (Integer)this.field_6011.method_12789(DESPAWN_PARTICLE_COUNT);
    }

    public void setDespawnParticleCount(int despawnParticleCount) {
        this.field_6011.method_12778(DESPAWN_PARTICLE_COUNT, (Object)despawnParticleCount);
    }

    public class_2394 getDespawnParticle() {
        return (class_2394)this.field_6011.method_12789(DESPAWN_PARTICLE);
    }

    public void setDespawnParticle(class_2394 despawnParticle) {
        this.field_6011.method_12778(DESPAWN_PARTICLE, (Object)despawnParticle);
    }

    public float getDespawnParticleExpansion() {
        return ((Float)this.field_6011.method_12789(DESPAWN_PARTICLE_EXPANSION)).floatValue();
    }

    public void setDespawnParticleExpansion(float despawnParticleExpansion) {
        this.field_6011.method_12778(DESPAWN_PARTICLE_EXPANSION, (Object)Float.valueOf(despawnParticleExpansion));
    }
}

