/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntityEvents;
import net.soulsweaponry.entity.projectile.noclip.NoClipWarmupEntity;

public abstract class DamagingWarmupEntity
extends NoClipWarmupEntity {
    private boolean startedAttack;
    private int ticksLeft = 20;
    private static final class_2940<Boolean> EMERGE = class_2945.method_12791(DamagingWarmupEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> PARTICLE_MOD = class_2945.method_12791(DamagingWarmupEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> EVENT_ID = class_2945.method_12791(DamagingWarmupEntity.class, (class_2941)class_2943.field_13327);
    private DamagingWarmupEntityEvents.OtherAttributes otherAttributes = new DamagingWarmupEntityEvents.OtherAttributes();

    public DamagingWarmupEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.ticksLeft = this.getMaxTicks();
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.reduceWarmup(1);
            if (this.getWarmup() < 0) {
                if (this.getWarmup() == -7) {
                    this.setEmerge(true);
                    List list = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(0.2));
                    for (class_1309 livingEntity : list) {
                        boolean wasHit;
                        if (!livingEntity.method_5805() || livingEntity.method_5655() || this.method_24921() != null && (livingEntity.method_5722(this.method_24921()) || this.method_34714((class_1297)livingEntity))) continue;
                        class_1297 class_12972 = this.method_24921();
                        if (class_12972 instanceof class_1309) {
                            class_1309 owner = (class_1309)class_12972;
                            wasHit = livingEntity.method_5643(this.method_37908().method_48963().method_48800((class_1297)this, owner), (float)this.method_7448() + this.getBonusDamage(livingEntity));
                        } else {
                            wasHit = livingEntity.method_5643(this.method_37908().method_48963().method_48800((class_1297)this, null), (float)this.method_7448() + this.getBonusDamage(livingEntity));
                        }
                        this.applyDamageEffects(wasHit, livingEntity);
                    }
                    this.onTrigger();
                }
                if (!this.startedAttack) {
                    this.method_37908().method_8421((class_1297)this, (byte)4);
                    this.startedAttack = true;
                }
                if (--this.ticksLeft < 0) {
                    this.method_31472();
                }
            }
        }
    }

    public int getMaxTicks() {
        return 20;
    }

    public void method_5711(byte status) {
        super.method_5711(status);
        if (status == 4 && !this.method_5701()) {
            this.handleSoundStatus(status);
        }
    }

    public void setEmerge(boolean bl) {
        this.field_6011.method_12778(EMERGE, (Object)bl);
    }

    public boolean getEmerge() {
        return (Boolean)this.field_6011.method_12789(EMERGE);
    }

    public void setParticleAmountMod(float particleMod) {
        this.field_6011.method_12778(PARTICLE_MOD, (Object)Float.valueOf(particleMod));
    }

    public float getParticleAmountMod() {
        return ((Float)this.field_6011.method_12789(PARTICLE_MOD)).floatValue();
    }

    public void setEventId(int eventId) {
        this.field_6011.method_12778(EVENT_ID, (Object)eventId);
    }

    public int getEventId() {
        return (Integer)this.field_6011.method_12789(EVENT_ID);
    }

    public void setOtherAttributes(DamagingWarmupEntityEvents.OtherAttributes otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public DamagingWarmupEntityEvents.OtherAttributes getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(EMERGE, (Object)false);
        this.field_6011.method_12784(PARTICLE_MOD, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(EVENT_ID, (Object)-1);
    }

    public abstract void handleSoundStatus(byte var1);

    public abstract void applyDamageEffects(boolean var1, class_1309 var2);

    public void onTrigger() {
        BiConsumer<DamagingWarmupEntity, DamagingWarmupEntityEvents.OtherAttributes> consumer = DamagingWarmupEntityEvents.EVENTS.get(this.getEventId());
        if (consumer != null) {
            consumer.accept(this, this.otherAttributes);
        }
    }

    public float getBonusDamage(class_1309 target) {
        return 0.0f;
    }

    public class_243 getParticleVec() {
        return new class_243((double)1.2f, (double)0.34f, (double)1.2f);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("ParticleModifier")) {
            this.setParticleAmountMod(nbt.method_10583("ParticleModifier"));
        }
        if (nbt.method_10545("EventId")) {
            this.setEventId(nbt.method_10550("EventId"));
        }
        this.otherAttributes = DamagingWarmupEntityEvents.OtherAttributes.getInstanceFromNbt(nbt);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("ParticleModifier", this.getParticleAmountMod());
        nbt.method_10569("EventId", this.getEventId());
        this.otherAttributes.writeCustomDataToNbt(nbt);
    }
}

