/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.soulsweaponry.api.entitystats.EntityBleed;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.networking.PacketIds;

public class BleedData {
    public static final String BLEED_ID = "bleed";

    public static void addBleed(class_1309 entity, int amount) {
        if (!(EntityBleed.isBleedDisabled(entity) || entity.method_29504() || entity.method_37908().field_9236)) {
            int newAmount = EntityBleed.getBleedBuildup(entity, amount);
            BleedData.addBleed((IEntityDataSaver)entity, newAmount);
        }
    }

    private static int addBleed(IEntityDataSaver entity, int amount) {
        int value;
        class_2487 nbt = entity.getPersistentData();
        if (!nbt.method_10545(BLEED_ID)) {
            nbt.method_10569(BLEED_ID, 0);
        }
        value = (value = nbt.method_10550(BLEED_ID)) < 0 ? 0 : (value += amount);
        nbt.method_10569(BLEED_ID, value);
        if (entity instanceof class_3222) {
            BleedData.syncData(value, (class_3222)entity);
        }
        return value;
    }

    public static int getBleed(class_1309 entity) {
        IEntityDataSaver target = (IEntityDataSaver)entity;
        if (!target.getPersistentData().method_10545(BLEED_ID)) {
            target.getPersistentData().method_10569(BLEED_ID, 0);
        }
        return target.getPersistentData().method_10550(BLEED_ID);
    }

    public static int reduceBleed(IEntityDataSaver entity, int amount) {
        return BleedData.addBleed(entity, -amount);
    }

    public static int setBleed(IEntityDataSaver entity, int amount) {
        class_2487 nbt = entity.getPersistentData();
        nbt.method_10569(BLEED_ID, amount);
        if (entity instanceof class_3222) {
            BleedData.syncData(amount, (class_3222)entity);
        }
        return amount;
    }

    public static void syncData(int data, class_3222 entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(data);
        ServerPlayNetworking.send((class_3222)entity, (class_2960)PacketIds.BLEED_SYNC, (class_2540)buf);
    }
}

