/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.networking.PacketIds;

public class TargetPostureData {
    public static final String POSTURE_ID = "target_posture";
    public static final String MAX_POSTURE_ID = "target_max_posture";
    public static final String NAME_ID = "target_name";

    public static int getTargetPosture(class_1309 mainEntity) {
        IEntityDataSaver target = (IEntityDataSaver)mainEntity;
        if (!target.getPersistentData().method_10545(POSTURE_ID)) {
            target.getPersistentData().method_10569(POSTURE_ID, 0);
        }
        return target.getPersistentData().method_10550(POSTURE_ID);
    }

    public static String getTargetName(class_1309 mainEntity) {
        IEntityDataSaver target = (IEntityDataSaver)mainEntity;
        if (!target.getPersistentData().method_10545(NAME_ID)) {
            target.getPersistentData().method_10582(NAME_ID, "");
        }
        return target.getPersistentData().method_10558(NAME_ID);
    }

    public static int getTargetsMaxPosture(class_1309 mainEntity) {
        IEntityDataSaver target = (IEntityDataSaver)mainEntity;
        if (!target.getPersistentData().method_10545(MAX_POSTURE_ID)) {
            target.getPersistentData().method_10569(MAX_POSTURE_ID, 200);
        }
        return target.getPersistentData().method_10550(MAX_POSTURE_ID);
    }

    public static void updateTargetPosture(IEntityDataSaver mainEntity, class_1309 target) {
        class_2487 nbt = mainEntity.getPersistentData();
        int amount = PostureData.getPosture(target);
        String name = target.method_5477().getString();
        int max = EntityPosture.getMaxPostureLoss(target);
        nbt.method_10569(POSTURE_ID, amount);
        nbt.method_10582(NAME_ID, name);
        nbt.method_10569(MAX_POSTURE_ID, max);
        if (mainEntity instanceof class_3222) {
            TargetPostureData.syncData(amount, name, max, (class_3222)mainEntity);
        }
    }

    public static void resetValues(IEntityDataSaver mainEntity) {
        class_2487 nbt = mainEntity.getPersistentData();
        nbt.method_10569(POSTURE_ID, 0);
        nbt.method_10582(NAME_ID, "");
        nbt.method_10569(MAX_POSTURE_ID, 200);
        if (mainEntity instanceof class_3222) {
            TargetPostureData.syncData(0, "", 200, (class_3222)mainEntity);
        }
    }

    public static void syncData(int data, String name, int maxPosture, class_3222 entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(data);
        buf.method_10814(name);
        buf.writeInt(maxPosture);
        ServerPlayNetworking.send((class_3222)entity, (class_2960)PacketIds.TARGET_POSTURE_SYNC, (class_2540)buf);
    }
}

