/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;

public interface ICooldownItem {
    default public void applyItemCooldown(class_1657 player, int cooldown) {
        if (!player.method_7337()) {
            player.method_7357().method_7906((class_1792)this, cooldown);
        }
    }

    default public void applyItemCooldownNoCheck(class_1657 player, int cooldown) {
        player.method_7357().method_7906((class_1792)this, cooldown);
    }

    default public void applyEffectCooldown(class_1657 player, int cooldown) {
        if (!player.method_7337()) {
            player.method_6092(new class_1293(EffectRegistry.COOLDOWN, cooldown, 0));
        }
    }

    default public int getReduceCooldownEnchantLevel(class_1799 stack) {
        if (this.canEnchantReduceCooldown(stack)) {
            return this.getMaxLevel(this.getReduceCooldownEnchantIds(stack), stack);
        }
        return 0;
    }

    default public int getReduceLifeStealCooldownEnchantLevel(class_1799 stack) {
        if (ConfigConstructor.lifesteal_item_enchant_reduces_cooldown) {
            return this.getMaxLevel(ConfigConstructor.lifesteal_item_enchant_reduces_cooldown_ids, stack);
        }
        return 0;
    }

    default public int getMaxLevel(String[] ids, class_1799 stack) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (String id : ids) {
            levels.add(this.getReducedCooldownEnchantLevel(stack, id));
        }
        Optional op = levels.stream().max(Integer::compare);
        return op.orElse(0);
    }

    default public int getReducedCooldownEnchantLevel(class_1799 stack, String enchantId) {
        if (enchantId.equals("damage")) {
            return WeaponUtil.getEnchantDamageBonus(stack);
        }
        class_2960 id = new class_2960(enchantId);
        class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(id);
        if (enchantment != null) {
            return class_1890.method_8225((class_1887)enchantment, (class_1799)stack);
        }
        return 0;
    }

    public boolean canEnchantReduceCooldown(class_1799 var1);

    public String[] getReduceCooldownEnchantIds(class_1799 var1);

    default public void notifyCooldown(class_1309 user) {
        if (!ConfigConstructor.inform_player_about_cooldown_effect) {
            return;
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            player.method_7353((class_2561)class_2561.method_48321((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"), true);
        } else {
            user.method_43496((class_2561)class_2561.method_48321((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"));
        }
    }
}

