/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_572;
import net.soulsweaponry.client.renderer.armor.ChaosSetRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChaosCrown
extends ModdedArmor
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private static final UUID LUCK_MODIFIER_UUID = UUID.fromString("ea8c740d-dd7c-4e5e-80aa-41bf5a250f5a");
    private static final class_1322 LUCK_MODIFIER = new class_1322(LUCK_MODIFIER_UUID, "Helmet Luck Bonus", (double)ConfigConstructor.chaos_crown_luck_given, class_1322.class_1323.field_6328);
    private static final HashMap<class_1291, class_1291> FLIPPABLE_EFFECTS = new HashMap();

    public ChaosCrown(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.EMPEROR, TooltipAbilities.EFFECT_REVERSAL);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.isSlotActive(player, class_1304.field_6169)) {
                if (!player.method_5996(class_5134.field_23726).method_6196(LUCK_MODIFIER)) {
                    player.method_5996(class_5134.field_23726).method_26837(LUCK_MODIFIER);
                }
                if (!player.method_7357().method_7904(ArmorRegistry.CHAOS_CROWN) && !player.method_7357().method_7904(ArmorRegistry.CHAOS_HELMET)) {
                    this.flipEffects(player);
                }
            } else {
                Objects.requireNonNull(player.method_5996(class_5134.field_23726)).method_6202(LUCK_MODIFIER);
            }
        }
    }

    private void flipEffects(class_1657 player) {
        ArrayList statusEffectsCopy = new ArrayList(player.method_6026());
        ArrayList<class_1291> effectsToRemove = new ArrayList<class_1291>();
        boolean triggered = false;
        for (class_1293 instance : statusEffectsCopy) {
            class_1291 effect = instance.method_5579();
            if (effect.method_18792() != class_4081.field_18272) continue;
            int duration = (int)((float)instance.method_5584() / 3.0f);
            int amplifier = (int)((float)instance.method_5578() / 2.0f);
            class_1291 newEffect = class_1294.field_5924;
            for (class_1291 harmful : FLIPPABLE_EFFECTS.keySet()) {
                if (!effect.equals(harmful)) continue;
                newEffect = FLIPPABLE_EFFECTS.get(harmful);
                break;
            }
            effectsToRemove.add(effect);
            triggered = true;
            player.method_6092(new class_1293(newEffect, duration, amplifier));
        }
        for (class_1291 effectToRemove : effectsToRemove) {
            player.method_6016(effectToRemove);
        }
        if (triggered && !player.method_7337()) {
            player.method_7357().method_7906(ArmorRegistry.CHAOS_CROWN, (int)Math.max(ConfigConstructor.chaos_crown_flip_effect_min_cooldown, ConfigConstructor.chaos_crown_flip_effect_cooldown - (float)(this.getReduceCooldownEnchantLevel(player.method_6118(class_1304.field_6169)) * 40)));
            player.method_7357().method_7906(ArmorRegistry.CHAOS_HELMET, (int)Math.max(ConfigConstructor.chaos_crown_flip_effect_min_cooldown, ConfigConstructor.chaos_crown_flip_effect_cooldown - (float)(this.getReduceCooldownEnchantLevel(player.method_6118(class_1304.field_6169)) * 40)));
        }
    }

    @Override
    public class_2561[] getLoreTooltips() {
        return new class_2561[]{class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_lore_1").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_lore_2").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_lore_3").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_lore_4").method_27692(class_124.field_1063)};
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_chaos_crown;
    }

    @Override
    public boolean isSlotActive(class_1657 player, class_1304 slot) {
        class_1799 stack = player.method_6118(slot);
        return !stack.method_7960() && !this.isDisabled(stack) && stack.method_7909() instanceof ChaosCrown;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_chaos_crown;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.chaos_crown_flip_effect_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.chaos_crown_flip_effect_enchant_reduces_cooldown_ids;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = new ChaosSetRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.chaos_set_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.chaos_set_bleed_damage_resistances;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.chaos_set_posture_buildup_resistances;
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.chaos_set_base_posture_increase;
    }

    static {
        FLIPPABLE_EFFECTS.put(class_1294.field_5909, class_1294.field_5904);
        FLIPPABLE_EFFECTS.put(class_1294.field_5901, class_1294.field_5917);
        FLIPPABLE_EFFECTS.put(class_1294.field_5911, class_1294.field_5910);
        FLIPPABLE_EFFECTS.put(class_1294.field_5919, class_1294.field_5925);
        FLIPPABLE_EFFECTS.put(class_1294.field_5903, class_1294.field_5922);
        FLIPPABLE_EFFECTS.put(class_1294.field_5902, class_1294.field_5906);
    }
}

