/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.soulsweaponry.blocks.WitheredBlock;
import net.soulsweaponry.blocks.WitheredFlower;
import net.soulsweaponry.blocks.WitheredGrass;
import net.soulsweaponry.blocks.WitheredTallFlower;
import net.soulsweaponry.blocks.WitheredTallGrass;
import net.soulsweaponry.client.renderer.armor.ChaosSetRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChaosRobes
extends ModdedArmor
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final HashMap<class_2248, WitheredBlock> turnableBlocks = new HashMap();
    private final HashMap<class_2248, WitheredGrass> turnableGrass = new HashMap();
    private final HashMap<class_2248, WitheredTallGrass> turnableTallPlant = new HashMap();

    public ChaosRobes(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.CORRUPT_GROUND);
        this.turnableBlocks.put(class_2246.field_10219, BlockRegistry.WITHERED_GRASS_BLOCK);
        this.turnableBlocks.put(class_2246.field_10566, BlockRegistry.WITHERED_DIRT);
        this.turnableGrass.put(class_2246.field_10479, BlockRegistry.WITHERED_GRASS);
        this.turnableGrass.put(class_2246.field_10112, BlockRegistry.WITHERED_FERN);
        this.turnableGrass.put(class_2246.field_16999, BlockRegistry.WITHERED_BERRY_BUSH);
        this.turnableTallPlant.put(class_2246.field_10214, BlockRegistry.WITHERED_TALL_GRASS);
        this.turnableTallPlant.put(class_2246.field_10313, BlockRegistry.WITHERED_LARGE_FERN);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1657 && this.isSlotActive(player = (class_1657)entity, class_1304.field_6174)) {
            if (ConfigConstructor.chaos_cape_wither_ground) {
                this.turnBlocks((class_1309)player, world, player.method_24515(), 0);
            }
            if (player.field_6012 % 40 == 0) {
                for (class_1309 target : world.method_18467(class_1309.class, player.method_5829().method_1014(3.0))) {
                    if (target instanceof class_1657 || target == player) continue;
                    target.method_6092(new class_1293(class_1294.field_5920, 80, 1));
                }
            }
        }
    }

    public void turnBlocks(class_1309 entity, class_1937 world, class_2338 blockPos, int bonusRadius) {
        if (!entity.method_24828()) {
            return;
        }
        int f = Math.min(16, 3 + bonusRadius);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 blockPos2 : class_2338.method_10097((class_2338)blockPos.method_10069(-f, -1, -f), (class_2338)blockPos.method_10069(f, -1, f))) {
            if (world.method_8320(blockPos2).method_26215()) continue;
            for (class_2248 turnBlock : this.turnableBlocks.keySet()) {
                if (world.method_8320(blockPos2).method_26204() == turnBlock) {
                    class_2680 blockState = this.turnableBlocks.get(turnBlock).method_9564();
                    if (!blockPos2.method_19769((class_2374)entity.method_19538(), (double)f)) continue;
                    mutable.method_10103(blockPos2.method_10263(), blockPos2.method_10264() + 1, blockPos2.method_10260());
                    class_2680 blockState2 = world.method_8320((class_2338)mutable);
                    if (blockState2.method_26164(class_3481.field_15480)) {
                        world.method_8501((class_2338)mutable, (class_2680)BlockRegistry.HYDRANGEA.method_9564().method_11657((class_2769)WitheredFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false)));
                    }
                    for (class_2248 turnGrass : this.turnableGrass.keySet()) {
                        if (!blockState2.method_27852(turnGrass)) continue;
                        world.method_8501((class_2338)mutable, this.turnableGrass.get(turnGrass).method_9564());
                    }
                    for (class_2248 turnTallPlant : this.turnableTallPlant.keySet()) {
                        if (!blockState2.method_27852(turnTallPlant)) continue;
                        world.method_8650((class_2338)mutable, false);
                        class_2320.method_10021((class_1936)world, (class_2680)this.turnableTallPlant.get(turnTallPlant).method_9564(), (class_2338)mutable, (int)2);
                    }
                    if (blockState2.method_26164(class_3481.field_20338)) {
                        world.method_8650((class_2338)mutable, false);
                        class_2320.method_10021((class_1936)world, (class_2680)((class_2680)BlockRegistry.OLEANDER.method_9564().method_11657((class_2769)WitheredTallFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false))), (class_2338)mutable, (int)2);
                    }
                    world.method_8501(blockPos2, blockState);
                    world.method_39279(blockPos2, (class_2248)this.turnableBlocks.get(turnBlock), class_3532.method_15395((class_5819)entity.method_6051(), (int)50, (int)90));
                    continue;
                }
                if (world.method_8320(blockPos2).method_26204() != this.turnableBlocks.get(turnBlock)) continue;
                WitheredBlock block = (WitheredBlock)world.method_8320(blockPos2).method_26204();
                block.resetAge(world.method_8320(blockPos2), world, blockPos2);
            }
        }
    }

    @Override
    public class_2561[] getLoreTooltips() {
        return new class_2561[]{class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_lore_1").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_lore_2").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_lore_3").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_lore_4").method_27692(class_124.field_1063)};
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_chaos_robes;
    }

    @Override
    public boolean isSlotActive(class_1657 player, class_1304 slot) {
        class_1799 stack = player.method_6118(slot);
        return !stack.method_7960() && !this.isDisabled(stack) && stack.method_7909() instanceof ChaosRobes;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_chaos_robes;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return new String[0];
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = new ChaosSetRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.chaos_set_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.chaos_set_bleed_damage_resistances;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.chaos_set_posture_buildup_resistances;
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.chaos_set_base_posture_increase;
    }
}

