/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.Cannonball;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.gun.GunItem;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class HunterCannon
extends GunItem {
    public HunterCannon(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public int getPostureLoss(class_1799 stack) {
        int lvl = class_1890.method_8225((class_1887)EnchantRegistry.VISCERAL, (class_1799)stack);
        return (int)(ConfigConstructor.hunter_cannon_posture_loss + (float)lvl * ConfigConstructor.hunter_cannon_posture_loss_per_enchant_level);
    }

    @Override
    public float getBulletDamage(class_1799 stack) {
        return ConfigConstructor.hunter_cannon_damage;
    }

    @Override
    public float getBulletVelocity(class_1799 stack) {
        return ConfigConstructor.hunter_cannon_velocity;
    }

    @Override
    public float getBulletDivergence(class_1799 stack) {
        return ConfigConstructor.hunter_cannon_divergence;
    }

    @Override
    public int getCooldown(class_1799 stack) {
        return (int)(ConfigConstructor.hunter_cannon_cooldown - (float)(4 * this.getReducedCooldown(stack)) + (float)(class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) * 50));
    }

    @Override
    public int getBulletsNeeded(class_1799 stack) {
        return class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0 ? this.getBulletsNeededWithInfinity(stack) : (int)ConfigConstructor.hunter_cannon_bullets_needed;
    }

    @Override
    public int getBulletsNeededWithInfinity(class_1799 stack) {
        return (int)ConfigConstructor.hunter_cannon_bullets_needed_with_infinity;
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_hunter_cannon;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (this.isDisabled(user.method_5998(hand))) {
            this.notifyDisabled((class_1309)user);
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        class_1799 stack = user.method_5998(hand);
        class_1799 itemStack = this.canShoot(user, stack);
        if (itemStack != null) {
            this.spawnShotParticles(world, user, 50, 0.4f);
            class_1665 entity = this.createSilverBulletEntity(world, (class_1309)user, stack);
            world.method_8649((class_1297)entity);
            WeaponUtil.launchTarget((class_1309)user, 2.0f, true);
            this.postShot(world, user, stack);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    @Override
    public int getStackDamageToApply() {
        return this.getBulletsNeeded(this.method_7854());
    }

    @Override
    public int getProjectileMaxAge() {
        return 120;
    }

    @Override
    public int getProjectileMaxAgeEthereal() {
        return 60;
    }

    @Override
    public SilverBulletEntity getModdedProjectile(class_1937 world, class_1309 shooter, class_1799 gunStack) {
        return new Cannonball(world, shooter);
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_hunter_cannon;
    }
}

