/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.hammer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.MjolnirItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MjolnirProjectile;
import net.soulsweaponry.entity.projectile.noclip.WarmupLightningEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mjolnir
extends ChargeToUseItem
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    public static final String RAINING = "raining";

    public Mjolnir(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.mjolnir_damage, ConfigConstructor.mjolnir_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.MJOLNIR_LIGHTNING, TooltipAbilities.THROW_LIGHTNING, TooltipAbilities.RETURNING, TooltipAbilities.WEATHERBORN, TooltipAbilities.OFF_HAND_FLIGHT);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = WeaponUtil.getChargeTime(stack, remainingUseTicks);
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (i >= 10) {
                int cooldown = 0;
                stack.method_7956(3, (class_1309)player, p -> p.method_20236(user.method_6058()));
                if (player.method_5715()) {
                    this.smashGround(stack, world, player);
                    this.lightningCall(player, world);
                    cooldown = (int)ConfigConstructor.mjolnir_lightning_smash_cooldown;
                } else if (player.method_6079().method_31574((class_1792)this)) {
                    this.riptide(player, world, stack);
                    if (!world.method_8419()) {
                        cooldown = (int)ConfigConstructor.mjolnir_riptide_cooldown;
                    }
                } else {
                    this.throwHammer(world, player, stack);
                }
                if (cooldown != 0) {
                    cooldown = (int)Math.max(ConfigConstructor.mjolnir_ability_min_cooldown, (float)(cooldown - this.getReduceCooldownEnchantLevel(stack) * 30));
                }
                this.applyItemCooldown(player, cooldown);
            }
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.mjolnir_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.mjolnir_ability_enchant_reduces_cooldown_ids;
    }

    private void throwHammer(class_1937 world, class_1657 player, class_1799 stack) {
        MjolnirProjectile projectile = new MjolnirProjectile(world, (class_1309)player, stack);
        projectile.saveOnPlayer(player);
        float speed = (float)WeaponUtil.getEnchantDamageBonus(stack) / 5.0f;
        projectile.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 2.5f + speed, 1.0f);
        projectile.field_7572 = class_1665.class_1666.field_7594;
        world.method_8649((class_1297)projectile);
        world.method_43129(null, (class_1297)projectile, class_3417.field_15001, class_3419.field_15248, 1.0f, 1.0f);
        if (!player.method_31549().field_7477) {
            player.method_31548().method_7378(stack);
        }
    }

    private void riptide(class_1657 player, class_1937 world, class_1799 stack) {
        float sharpness = WeaponUtil.getEnchantDamageBonus(stack);
        WeaponUtil.launchTarget((class_1309)player, 5.0f + sharpness, false);
        player.method_40126(20);
        if (player.method_24828()) {
            player.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999284744263, 0.0));
        }
        world.method_43129(null, (class_1297)player, class_3417.field_14717, class_3419.field_15248, 1.0f, 1.0f);
    }

    private void smashGround(class_1799 stack, class_1937 world, class_1657 player) {
        class_238 box = player.method_5829().method_1014(3.0);
        List entities = world.method_8335((class_1297)player, box);
        float power = ConfigConstructor.mjolnir_smash_damage;
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1309)) continue;
            entity.method_5643(world.method_48963().method_48812((class_1309)player), power + 2.0f * class_1890.method_8218((class_1799)stack, (class_1310)((class_1309)entity).method_6046()));
            entity.method_5762(0.0, 0.25, 0.0);
        }
        world.method_43129(null, (class_1297)player, class_3417.field_14956, class_3419.field_15248, 0.75f, 1.0f);
        double d = player.method_6051().method_43059() * 0.05;
        double e = player.method_6051().method_43059() * 0.05;
        for (int j = 0; j < 200; ++j) {
            double newX = player.method_6051().method_43058() - 0.5 + player.method_6051().method_43059() * 0.15 + d;
            double newZ = player.method_6051().method_43058() - 0.5 + player.method_6051().method_43059() * 0.15 + e;
            double newY = player.method_6051().method_43058() - 0.5 + player.method_6051().method_43058() * 0.5;
            world.method_8406((class_2394)new class_2392(class_2398.field_11218, class_1802.field_20391.method_7854()), player.method_23317(), player.method_23318(), player.method_23321(), newX, newY / 2.0, newZ);
            world.method_8406((class_2394)new class_2392(class_2398.field_11218, class_1802.field_8831.method_7854()), player.method_23317(), player.method_23318(), player.method_23321(), newX, newY / 2.0, newZ);
            world.method_8406((class_2394)class_2398.field_11237, player.method_23317(), player.method_23318(), player.method_23321(), newX, newY / 8.0, newZ);
            world.method_8406((class_2394)class_2398.field_29644, player.method_23317(), player.method_23318(), player.method_23321(), newX * 10.0, newY * 2.0, newZ * 10.0);
        }
    }

    private void lightningCall(class_1657 player, class_1937 world) {
        int i = 1;
        while ((float)i < ConfigConstructor.mjolnir_lightning_circle_amount + 1.0f) {
            int r = 5 * i;
            for (int theta = 0; theta < 360; theta += 30) {
                double x0 = player.method_23317();
                double z0 = player.method_23321();
                double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                WarmupLightningEntity entity = new WarmupLightningEntity(EntityRegistry.WARMUP_LIGHTNING, world);
                entity.method_23327(x, player.method_23318(), z);
                entity.setWarmup(2 + i * 8);
                entity.method_7432((class_1297)player);
                world.method_8649((class_1297)entity);
            }
            ++i;
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        this.refreshRaining(world, stack);
    }

    private void refreshRaining(class_1937 world, class_1799 stack) {
        stack.method_7948().method_10556(RAINING, world.method_8419());
    }

    private boolean isRaining(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545(RAINING)) {
            return stack.method_7969().method_10577(RAINING);
        }
        return false;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", this.isRaining(stack) && !this.isDisabled(stack) ? (double)(ConfigConstructor.mjolnir_rain_bonus_damage - 1.0f + ConfigConstructor.mjolnir_damage) : (double)(ConfigConstructor.mjolnir_damage - 1.0f), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)(-(4.0f - ConfigConstructor.mjolnir_rain_total_attack_speed)), class_1322.class_1323.field_6328));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.method_7844(slot);
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_mjolnir;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final MjolnirItemRenderer renderer = new MjolnirItemRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_mjolnir;
    }
}

