/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.hammer;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.NightfallRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.entitydata.SummonsData;
import net.soulsweaponry.items.ISummonAllies;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.DetonateGroundAttributes;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Nightfall
extends UltraHeavyWeapon
implements GeoItem,
IKeybindAbility,
ISummonAllies {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final DetonateGroundAttributes attributes = new DetonateGroundAttributes(ConfigConstructor.nightfall_calculated_fall_base_radius, ConfigConstructor.nightfall_calculated_fall_height_increase_radius_modifier, ConfigConstructor.nightfall_calculated_fall_target_launch_modifier, ConfigConstructor.nightfall_calculated_fall_target_max_launch_power, ConfigConstructor.nightfall_calculated_fall_max_radius, ConfigConstructor.nightfall_calculated_fall_max_damage, ConfigConstructor.nightfall_calculated_fall_height_increase_damage_modifier, ConfigConstructor.nightfall_calculated_fall_heal_from_damage_modifier, Map.of(class_2398.field_22246, new class_243(1.0, 6.0, 1.0)), (TriConsumer<class_1309, class_1309, Float>)((TriConsumer)(target, user, fallDistance) -> this.spawnRemnant((class_1309)target, (class_1309)user)), (TriConsumer<class_1309, Float, class_1799>)((TriConsumer)(user, fallDistance, stack) -> {}));

    public Nightfall(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.nightfall_damage, ConfigConstructor.nightfall_attack_speed, settings, true);
        this.addTooltipAbility(TooltipAbilities.SUMMON_GHOST, TooltipAbilities.SHIELD, TooltipAbilities.OBLITERATE);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i;
        class_1657 player;
        if (user instanceof class_1657 && !(player = (class_1657)user).method_7357().method_7904((class_1792)this) && (i = WeaponUtil.getChargeTime(stack, remainingUseTicks)) >= 10) {
            this.applyItemCooldown(player, this.getScaledCooldownSmash(stack));
            stack.method_7956(3, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
            class_243 vecBlocksAway = player.method_5720().method_1021(3.0).method_1019(player.method_19538());
            class_2338 targetArea = new class_2338((int)vecBlocksAway.field_1352, (int)user.method_23318(), (int)vecBlocksAway.field_1350);
            class_238 aoe = new class_238(targetArea).method_1014(3.0);
            List entities = world.method_8335((class_1297)player, aoe);
            float power = ConfigConstructor.nightfall_ability_damage;
            for (class_1297 entity : entities) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 target = (class_1309)entity;
                entity.method_5643(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (class_1297)player), power + 2.0f * class_1890.method_8218((class_1799)stack, (class_1310)target.method_6046()));
                entity.method_18800(entity.method_18798().field_1352, 0.5, entity.method_18798().field_1350);
                this.spawnRemnant(target, user);
            }
            world.method_8396(player, targetArea, SoundRegistry.NIGHTFALL_BONK_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            if (!world.field_9236) {
                ParticleHandler.particleOutburstMap(world, 150, targetArea.method_10263(), (float)targetArea.method_10264() + 0.1f, targetArea.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
            }
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.nightfall_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.nightfall_enchant_reduces_cooldown_ids;
    }

    protected int getScaledCooldownSmash(class_1799 stack) {
        float base = ConfigConstructor.nightfall_smash_cooldown;
        return (int)Math.max(ConfigConstructor.nightfall_smash_min_cooldown, base - (float)(this.getReduceCooldownEnchantLevel(stack) * 50));
    }

    protected int getScaledCooldownShield(class_1799 stack) {
        float base = ConfigConstructor.nightfall_shield_cooldown;
        return (int)Math.max(ConfigConstructor.nightfall_shield_min_cooldown, base - (float)(this.getReduceCooldownEnchantLevel(stack) * 100));
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!this.isDisabled(stack)) {
            this.spawnRemnant(target, attacker);
        }
        return super.method_7873(stack, target, attacker);
    }

    public void spawnRemnant(class_1309 target, class_1309 attacker) {
        if (target.method_5999() && target.method_29504() && attacker instanceof class_1657 && !this.isDisabled(attacker.method_6047())) {
            double chance = new Random().nextDouble();
            class_1937 world = attacker.method_5770();
            if (!world.field_9236 && this.canSummonEntity((class_3218)world, attacker, this.getSummonsListId()) && chance < ConfigConstructor.nightfall_summon_chance) {
                Remnant entity = new Remnant(EntityRegistry.REMNANT, world);
                entity.method_23327(target.method_23317(), target.method_23318() + (double)0.1f, target.method_23321());
                entity.method_6170((class_1657)attacker);
                world.method_8649((class_1297)entity);
                this.saveSummonUuid(attacker, entity.method_5667());
                world.method_8396(null, target.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                if (!attacker.method_37908().field_9236) {
                    ParticleHandler.particleOutburstMap(attacker.method_37908(), 50, target.method_23317(), target.method_23318(), target.method_23321(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final NightfallRenderer renderer = new NightfallRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public class_2561[] getAdditionalTooltips() {
        return new class_2561[]{class_2561.method_43471((String)"tooltip.soulsweapons.nightfall.part_1").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.nightfall.part_2").method_27692(class_124.field_1063), class_2561.method_43471((String)"tooltip.soulsweapons.nightfall.part_3").method_27692(class_124.field_1063)};
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_nightfall;
    }

    @Override
    public void useKeybindAbilityServer(class_3218 world, class_1799 stack, class_1657 player) {
        if (!player.method_7357().method_7904((class_1792)this)) {
            this.applyItemCooldown(player, this.getScaledCooldownShield(stack));
            stack.method_7956(3, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
            player.method_6092(new class_1293(class_1294.field_5898, 200, (int)ConfigConstructor.nightfall_ability_shield_power));
            player.method_6092(new class_1293(class_1294.field_5907, 200, 0));
            world.method_8396(null, player.method_24515(), SoundRegistry.NIGHTFALL_SHIELD_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @Override
    public void useKeybindAbilityClient(class_638 world, class_1799 stack, class_1657 player) {
    }

    @Override
    public int getMaxSummons() {
        return (int)ConfigConstructor.nightfall_summoned_allies_cap;
    }

    @Override
    public String getSummonsListId() {
        return "NightfallSummons";
    }

    @Override
    public void saveSummonUuid(class_1309 user, UUID summonUuid) {
        SummonsData.addSummonUUID((IEntityDataSaver)user, summonUuid, this.getSummonsListId());
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_nightfall;
    }

    @Override
    public DetonateGroundAttributes getDetonationAttributes() {
        return this.attributes;
    }

    @Override
    public int getPostureLoss() {
        return (int)ConfigConstructor.nightfall_posture_loss;
    }
}

