/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.spear;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.CometSpearItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.CometSpearEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.IDetonateGround;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.DetonateGroundAttributes;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CometSpear
extends ChargeToUseItem
implements GeoItem,
IDetonateGround {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final DetonateGroundAttributes attributes = new DetonateGroundAttributes(ConfigConstructor.comet_spear_calculated_fall_base_radius, ConfigConstructor.comet_spear_calculated_fall_height_increase_radius_modifier, ConfigConstructor.comet_spear_calculated_fall_target_launch_modifier, ConfigConstructor.comet_spear_calculated_fall_target_max_launch_power, ConfigConstructor.comet_spear_calculated_fall_max_radius, ConfigConstructor.comet_spear_calculated_fall_max_damage, ConfigConstructor.comet_spear_calculated_fall_height_increase_damage_modifier, ConfigConstructor.comet_spear_calculated_fall_heal_from_damage_modifier, Map.of(class_2398.field_11240, new class_243(1.0, 6.0, 1.0)), (TriConsumer<class_1309, class_1309, Float>)((TriConsumer)(target, user, fallDistance) -> {}), (TriConsumer<class_1309, Float, class_1799>)((TriConsumer)(user, fallDistance, stack) -> {}));

    public CometSpear(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.comet_spear_damage, ConfigConstructor.comet_spear_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SKYFALL, TooltipAbilities.INFINITY, TooltipAbilities.CRIT);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                float enchant = WeaponUtil.getEnchantDamageBonus(stack);
                if (stack == user.method_6079()) {
                    WeaponUtil.launchTarget(user, 5.0f + enchant, false);
                    playerEntity.method_40126(20);
                    world.method_43129(null, (class_1297)playerEntity, class_3417.field_14717, class_3419.field_15248, 1.0f, 1.0f);
                    if (playerEntity.method_24828()) {
                        playerEntity.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999284744263, 0.0));
                    }
                    user.method_6092(new class_1293(EffectRegistry.CALCULATED_FALL, 600, (int)ConfigConstructor.comet_spear_ability_damage));
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownSkyfall(stack));
                    stack.method_7956(4, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                } else {
                    stack.method_7956(2, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownThrow(stack));
                    CometSpearEntity entity = new CometSpearEntity(world, (class_1309)playerEntity, stack);
                    entity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 5.0f, 1.0f);
                    entity.field_7572 = class_1665.class_1666.field_7594;
                    world.method_8649((class_1297)entity);
                    world.method_43129(null, (class_1297)entity, class_3417.field_15001, class_3419.field_15248, 1.0f, 1.0f);
                }
            }
        }
    }

    protected int getScaledCooldownSkyfall(class_1799 stack) {
        int base = (int)ConfigConstructor.comet_spear_skyfall_ability_cooldown;
        return (int)Math.max(ConfigConstructor.comet_spear_skyfall_ability_min_cooldown, (float)(base - this.getReduceCooldownEnchantLevel(stack) * 20));
    }

    protected int getScaledCooldownThrow(class_1799 stack) {
        int base = (int)ConfigConstructor.comet_spear_throw_ability_cooldown;
        return (int)Math.max(ConfigConstructor.comet_spear_throw_ability_min_cooldown, (float)(base - this.getReduceCooldownEnchantLevel(stack) * 5));
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.comet_spear_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.comet_spear_enchant_reduces_cooldown_ids;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final CometSpearItemRenderer renderer = new CometSpearItemRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_comet_spear;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_comet_spear;
    }

    @Override
    public DetonateGroundAttributes getDetonationAttributes() {
        return this.attributes;
    }
}

