/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class DarkMoonGreatsword
extends ChargeToUseItem
implements IKeybindAbility {
    public DarkMoonGreatsword(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.dark_moon_greatsword_damage, ConfigConstructor.dark_moon_greatsword_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.FREEZE, TooltipAbilities.PERMAFROST, TooltipAbilities.FROST_MOON);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!this.isDisabled(stack)) {
            target.method_6092(new class_1293(EffectRegistry.FREEZING, (int)ConfigConstructor.dark_moon_greatsword_post_hit_permafrost_base_duration, (int)(ConfigConstructor.dark_moon_greatsword_post_hit_permafrost_base_amplifier + (float)WeaponUtil.getEnchantDamageBonus(stack))));
        }
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                stack.method_7956(1, (class_1309)playerEntity, p -> p.method_20236(user.method_6058()));
                int duration = (int)ConfigConstructor.dark_moon_greatsword_projectile_permafrost_base_duration;
                int amp = (int)(ConfigConstructor.dark_moon_greatsword_projectile_permafrost_base_amplifier + (float)WeaponUtil.getEnchantDamageBonus(stack));
                MoonlightProjectile entity = new MoonlightProjectile(EntityRegistry.DARK_MOON_PROJECTILE, world, user, stack);
                entity.setAppliedStatusEffect(EffectRegistry.FREEZING);
                entity.setEffectAmplifier(amp);
                entity.setAppliedEffectDuration(duration);
                entity.setAgeAndPoints(30, 150, 4);
                entity.setAreaParticleCount(8);
                entity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 1.5f, 1.0f);
                entity.method_7438(ConfigConstructor.dark_moon_greatsword_projectile_damage);
                world.method_8649((class_1297)entity);
                world.method_8396(null, user.method_24515(), SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_6059(EffectRegistry.FROST_MOON) && !user.method_7337()) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_dark_moon_greatsword;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_dark_moon_greatsword;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.dark_moon_greatsword_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.dark_moon_greatsword_enchant_reduces_cooldown_ids;
    }

    @Override
    public void useKeybindAbilityServer(class_3218 world, class_1799 stack, class_1657 player) {
        if (this.isDisabled(stack) || player.method_6059(EffectRegistry.COOLDOWN) && !player.method_7337()) {
            return;
        }
        stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
        int duration = (int)ConfigConstructor.dark_moon_greatsword_frost_moon_base_duration;
        int amp = (int)ConfigConstructor.dark_moon_greatsword_frost_moon_base_amplifier;
        int cooldown = (int)ConfigConstructor.dark_moon_greatsword_frost_moon_cooldown;
        cooldown = (int)Math.max(ConfigConstructor.dark_moon_greatsword_frost_moon_min_cooldown, (float)(cooldown - this.getReduceCooldownEnchantLevel(stack) * 60));
        this.applyEffectCooldown(player, cooldown);
        player.method_6092(new class_1293(EffectRegistry.FROST_MOON, duration, amp));
        world.method_8396(null, player.method_24515(), class_3417.field_28606, player.method_5634(), 1.0f, 1.0f);
    }

    @Override
    public void useKeybindAbilityClient(class_638 world, class_1799 stack, class_1657 player) {
    }
}

