/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.HolyMoonlightPillar;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.IUndeadBonus;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;

public class HolyMoonlightGreatsword
extends ChargeToUseItem
implements IChargeNeeded,
IUndeadBonus {
    public HolyMoonlightGreatsword(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.holy_moonlight_greatsword_damage, ConfigConstructor.holy_moonlight_greatsword_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.NEED_CHARGE, TooltipAbilities.LUNAR_HERALD_NO_CHARGE, TooltipAbilities.CHARGE, TooltipAbilities.MOONFALL);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int chargeTime = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (chargeTime >= 10) {
                int emp = player.method_6059(EffectRegistry.MOON_HERALD) ? 20 * player.method_6112(EffectRegistry.MOON_HERALD).method_5578() : 0;
                this.applyItemCooldown(player, (int)Math.max(ConfigConstructor.holy_moonlight_ability_min_cooldown, ConfigConstructor.holy_moonlight_ability_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 30) - (float)emp));
                stack.method_7956(5, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
                int ruptures = (int)(ConfigConstructor.holy_moonlight_ruptures_amount + (float)WeaponUtil.getEnchantDamageBonus(stack));
                class_243 vecBlocksAway = player.method_5720().method_1021(3.0).method_1019(player.method_19538());
                class_2338 targetArea = new class_2338((int)vecBlocksAway.field_1352, (int)user.method_23318(), (int)vecBlocksAway.field_1350);
                float power = ConfigConstructor.holy_moonlight_ability_damage;
                for (class_1297 entity : world.method_8335((class_1297)player, new class_238(targetArea).method_1014(3.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    entity.method_5643(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (class_1297)player), power + 2.0f * class_1890.method_8218((class_1799)stack, (class_1310)((class_1309)entity).method_6046()));
                    entity.method_5762(0.0, (double)this.getKnockup(stack), 0.0);
                }
                if (!world.field_9236) {
                    WeaponUtil.doConsumerOnLine(world, user.method_36454() + 90.0f, user.method_19538(), 4.0, ruptures, 1.75f, (TriConsumer<class_243, Integer, Float>)((TriConsumer)(position, warmup, yaw) -> {
                        HolyMoonlightPillar pillar = new HolyMoonlightPillar(EntityRegistry.HOLY_MOONLIGHT_PILLAR, world);
                        pillar.method_7432((class_1297)user);
                        pillar.setParticleAmountMod(1.0f);
                        pillar.setRadius(1.85f);
                        pillar.method_7438(this.getAbilityDamage());
                        pillar.setKnockUp(this.getKnockup(stack));
                        pillar.setWarmup((int)warmup);
                        pillar.method_23327(position.method_10216(), position.method_10214(), position.method_10215());
                        world.method_8649((class_1297)pillar);
                    }));
                }
                if (!player.method_7337()) {
                    stack.method_7948().method_10569("current_charge", 0);
                }
                world.method_8396(player, targetArea, SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                world.method_8396(player, targetArea, class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
                if (!world.field_9236) {
                    ParticleHandler.particleOutburstMap(player.method_37908(), 150, vecBlocksAway.method_10216(), user.method_23318(), vecBlocksAway.method_10215(), ParticleEvents.MOONFALL_MAP, 1.0f);
                }
            }
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!this.isDisabled(stack)) {
            this.addCharge(stack, this.getAddedCharge(stack));
        }
        return super.method_7873(stack, target, attacker);
    }

    private float getAbilityDamage() {
        return ConfigConstructor.holy_moonlight_ability_damage;
    }

    private float getKnockup(class_1799 stack) {
        return ConfigConstructor.holy_moonlight_ability_knockup + (float)WeaponUtil.getEnchantDamageBonus(stack) / 10.0f;
    }

    @Override
    public int getMaxCharge() {
        return (int)ConfigConstructor.holy_moonlight_ability_charge_needed;
    }

    @Override
    public int getAddedCharge(class_1799 stack) {
        int base = (int)ConfigConstructor.holy_moonlight_greatsword_charge_added_post_hit;
        return base + WeaponUtil.getEnchantDamageBonus(stack) * 2;
    }

    @Override
    public boolean acceptsMoonHeraldEffect(class_1799 stack) {
        return true;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.holy_moonlight_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.holy_moonlight_ability_enchant_reduces_cooldown_ids;
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_holy_moonlight_greatsword;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_holy_moonlight_greatsword;
    }

    @Override
    public boolean isRighteous() {
        return true;
    }

    @Override
    public float getUndeadBonus(class_1799 stack) {
        return ConfigConstructor.holy_moonlight_greatsword_righteous_undead_bonus_damage;
    }
}

