/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;

public class NightsEdgeItem
extends ChargeToUseItem
implements IKeybindAbility {
    public NightsEdgeItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.nights_edge_weapon_damage, ConfigConstructor.nights_edge_weapon_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.NIGHTS_EDGE, TooltipAbilities.BLIGHT);
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_nights_edge;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (this.isDisabled(stack)) {
            return super.method_7873(stack, target, attacker);
        }
        if (target.method_6059(EffectRegistry.BLIGHT)) {
            int amp = target.method_6112(EffectRegistry.BLIGHT).method_5578();
            target.method_6092(new class_1293(EffectRegistry.BLIGHT, 60, amp + 1));
            if (amp >= 10) {
                target.method_6092(new class_1293(EffectRegistry.DECAY, 80, 0));
            }
        } else {
            target.method_6092(new class_1293(EffectRegistry.BLIGHT, 60, class_3532.method_15375((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f))));
        }
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i;
        class_1657 player;
        if (user instanceof class_1657 && !(player = (class_1657)user).method_7357().method_7904((class_1792)this) && (i = WeaponUtil.getChargeTime(stack, remainingUseTicks)) >= 10) {
            stack.method_7956(1, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
            WeaponUtil.doConsumerOnLine(world, player.method_36454() + 90.0f, player.method_19538(), 4.0, 10 + 2 * WeaponUtil.getEnchantDamageBonus(stack), 1.25f, (TriConsumer<class_243, Integer, Float>)((TriConsumer)(position, warmup, yaw) -> this.spawnNightsEdge(world, (class_1309)player, stack, (class_243)position, (int)warmup, yaw.floatValue())));
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
        }
    }

    @Override
    public void useKeybindAbilityServer(class_3218 world, class_1799 stack, class_1657 player) {
        if (!player.method_7357().method_7904((class_1792)this)) {
            double verticalSearch = 3.0;
            int ripples = 3 + class_3532.method_15375((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            class_241 radii = new class_241(1.5f, 1.75f);
            float ringYaw = player.method_36454() + 90.0f;
            WeaponUtil.doConsumerOnCircle((class_1937)world, ringYaw, player.method_19538(), verticalSearch, ripples, radii, (TriConsumer<class_243, Integer, Float>)((TriConsumer)(position, warmup, yawDeg) -> this.spawnNightsEdge((class_1937)world, (class_1309)player, stack, (class_243)position, (int)warmup, yawDeg.floatValue())));
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
            stack.method_7956(1, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
        }
    }

    public void spawnNightsEdge(class_1937 world, class_1309 user, class_1799 stack, class_243 position, int warmup, float yaw) {
        NightsEdge edge = new NightsEdge(EntityRegistry.NIGHTS_EDGE, world);
        edge.setOwner(user);
        edge.setDamage(ConfigConstructor.nights_edge_ability_damage + (float)(2 * WeaponUtil.getEnchantDamageBonus(stack)));
        edge.setWarmup(warmup);
        edge.method_36456(yaw);
        edge.method_23327(position.field_1352, position.field_1351, position.field_1350);
        world.method_8649((class_1297)edge);
    }

    protected int getScaledCooldown(class_1799 stack) {
        float base = ConfigConstructor.nights_edge_ability_cooldown;
        return (int)Math.max(ConfigConstructor.nights_edge_ability_min_cooldown, base - (float)(this.getReduceCooldownEnchantLevel(stack) * 8));
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.nights_edge_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.nights_edge_enchant_reduces_cooldown_ids;
    }

    @Override
    public void useKeybindAbilityClient(class_638 world, class_1799 stack, class_1657 player) {
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_nights_edge;
    }
}

