/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.particles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_703;
import net.minecraft.class_7923;
import net.soulsweaponry.networking.PacketHelper;
import net.soulsweaponry.networking.PacketIds;
import net.soulsweaponry.particles.ChainLightningHandler;
import org.joml.Vector3f;

public class ParticleHandler {
    private static final Random RANDOM = new Random();
    private static final Map<String, class_243[]> PARTICLE_OUTBURST_CACHE = new HashMap<String, class_243[]>();

    public static void particleOutburstMap(class_1937 world, int amount, double x, double y, double z, Map<class_2394, class_243> particleMap, float sizeMod) {
        for (class_2394 particle : particleMap.keySet()) {
            ParticleHandler.particleOutburst(world, amount, x, y, z, particle, particleMap.get(particle), sizeMod);
        }
    }

    public static void particleSphereList(class_1937 world, int amount, double x, double y, double z, float sizeMod, class_2394 ... particles) {
        for (class_2394 particle : particles) {
            ParticleHandler.particleSphere(world, amount, x, y, z, particle, sizeMod);
        }
    }

    public static void particleSphereList(class_1937 world, int amount, double x, double y, double z, List<class_2394> particles, float sizeMod) {
        for (class_2394 particle : particles) {
            ParticleHandler.particleSphere(world, amount, x, y, z, particle, sizeMod);
        }
    }

    public static void chainLightning(class_1937 world, class_243 from, class_243 to) {
        ParticleHandler.chainLightning(world, new Vector3f((float)from.field_1352, (float)from.field_1351, (float)from.field_1350), new Vector3f((float)to.field_1352, (float)to.field_1351, (float)to.field_1350));
    }

    public static void chainLightning(class_1937 world, Vector3f from, Vector3f to) {
        if (world.field_9236) {
            ChainLightningHandler.spawnChainLightning(world, from, to);
        } else {
            class_2540 buf = PacketByteBufs.create();
            buf.method_49068(from);
            buf.method_49068(to);
            PacketHelper.sendToAllPlayersS2C((class_3218)world, class_2338.method_49637((double)from.x, (double)from.y, (double)from.z), PacketIds.CHAIN_LIGHTNING, buf);
        }
    }

    public static void singleParticleList(class_1937 world, double x, double y, double z, double velX, double velY, double velZ, class_2394 ... particles) {
        for (class_2394 particle : particles) {
            ParticleHandler.singleParticle(world, particle, x, y, z, velX, velY, velZ);
        }
    }

    public static void singleParticle(class_1937 world, class_2394 particle, double x, double y, double z, double velX, double velY, double velZ) {
        if (world.field_9236) {
            world.method_8406(particle, x, y, z, velX, velY, velZ);
        } else {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8162);
            if (particle instanceof class_2392) {
                class_2392 par = (class_2392)particle;
                stack = par.method_10289();
                particle = class_2398.field_11240;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(class_7923.field_41180.method_10221((Object)particle.method_10295()));
            buf.method_10793(stack);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeDouble(velX);
            buf.writeDouble(velY);
            buf.writeDouble(velZ);
            PacketHelper.sendToAllPlayersS2C((class_3218)world, class_2338.method_49637((double)x, (double)y, (double)z), PacketIds.SINGLE_PARTICLE, buf);
        }
    }

    public static void particleOutburstList(class_1937 world, int amount, double x, double y, double z, class_2394 particle, class_243 velDivider, float sizeMod) {
        if (world.field_9236) {
            List<class_243> list = ParticleHandler.getParticleOutburstCords(amount, velDivider, sizeMod);
            for (class_243 vec : list) {
                world.method_8406(particle, x, y, z, vec.field_1352, vec.field_1351, vec.field_1350);
            }
        } else {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8162);
            if (particle instanceof class_2392) {
                class_2392 par = (class_2392)particle;
                stack = par.method_10289();
                particle = class_2398.field_11240;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(class_7923.field_41180.method_10221((Object)particle.method_10295()));
            buf.writeInt(amount);
            buf.method_10793(stack);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeDouble(velDivider.method_10216());
            buf.writeDouble(velDivider.method_10214());
            buf.writeDouble(velDivider.method_10215());
            buf.writeFloat(sizeMod);
            PacketHelper.sendToAllPlayersS2C((class_3218)world, class_2338.method_49637((double)x, (double)y, (double)z), PacketIds.OUTBURST_PARTICLES, buf);
        }
    }

    public static void particleOutburst(class_1937 world, int amount, double x, double y, double z, class_2394 particle, class_243 velDivider, float sizeMod) {
        String cacheKey = ParticleHandler.generateCacheKey(amount, velDivider, sizeMod);
        class_243[] particleVelocities = PARTICLE_OUTBURST_CACHE.computeIfAbsent(cacheKey, key -> ParticleHandler.getParticleOutburstCordsArray(amount, velDivider, sizeMod));
        if (world.field_9236) {
            for (class_243 vec : particleVelocities) {
                world.method_8406(particle, x, y, z, vec.field_1352, vec.field_1351, vec.field_1350);
            }
        } else {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8162);
            if (particle instanceof class_2392) {
                class_2392 par = (class_2392)particle;
                stack = par.method_10289();
                particle = class_2398.field_11240;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(class_7923.field_41180.method_10221((Object)particle.method_10295()));
            buf.writeInt(amount);
            buf.method_10793(stack);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeDouble(velDivider.method_10216());
            buf.writeDouble(velDivider.method_10214());
            buf.writeDouble(velDivider.method_10215());
            buf.writeFloat(sizeMod);
            PacketHelper.sendToAllPlayersS2C((class_3218)world, class_2338.method_49637((double)x, (double)y, (double)z), PacketIds.OUTBURST_PARTICLES, buf);
        }
    }

    public static void particleSphere(class_1937 world, int amount, double x, double y, double z, class_2394 particle, float sizeMod) {
        if (world.field_9236) {
            List<class_243> list = ParticleHandler.getSphereParticleCords(amount, sizeMod);
            for (class_243 vec : list) {
                world.method_8406(particle, x, y, z, vec.method_10216(), vec.method_10214(), vec.method_10215());
            }
        } else {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8162);
            if (particle instanceof class_2392) {
                class_2392 par = (class_2392)particle;
                stack = par.method_10289();
                particle = class_2398.field_11240;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(class_7923.field_41180.method_10221((Object)particle.method_10295()));
            buf.writeInt(amount);
            buf.method_10793(stack);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeFloat(sizeMod);
            PacketHelper.sendToAllPlayersS2C((class_3218)world, class_2338.method_49637((double)x, (double)y, (double)z), PacketIds.SPHERE_PARTICLES, buf);
        }
    }

    public static void flashParticle(class_1937 world, double x, double y, double z, RGB rgb, float expansion) {
        if (world.field_9236) {
            class_703 flash = class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_17909, x, y, z, 0.0, 0.0, 0.0);
            flash.method_3067(new class_238(class_2338.method_49637((double)x, (double)y, (double)z)).method_1014((double)expansion));
            flash.method_3084(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
        } else {
            class_2540 buf = PacketByteBufs.create();
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeFloat(rgb.getRed());
            buf.writeFloat(rgb.getGreen());
            buf.writeFloat(rgb.getBlue());
            buf.writeFloat(expansion);
            PacketHelper.sendToAllPlayersS2C((class_3218)world, class_2338.method_49637((double)x, (double)y, (double)z), PacketIds.FLASH_PARTICLE, buf);
        }
    }

    public static List<class_243> getParticleOutburstCords(int particleAmount, class_243 velDividers, double sizeMod) {
        ArrayList<class_243> list = new ArrayList<class_243>(particleAmount);
        double d = RANDOM.nextGaussian() * 0.05;
        double e = RANDOM.nextGaussian() * 0.05;
        double f = RANDOM.nextGaussian() * 0.05;
        for (int j = 0; j < particleAmount; ++j) {
            double newX = (RANDOM.nextDouble() - 0.5 + RANDOM.nextGaussian() * 0.15 + d) * sizeMod;
            double newZ = (RANDOM.nextDouble() - 0.5 + RANDOM.nextGaussian() * 0.15 + e) * sizeMod;
            double newY = (RANDOM.nextDouble() - 0.5 + RANDOM.nextGaussian() * 0.15 + f) * sizeMod;
            list.add(new class_243(newX / velDividers.method_10216(), newY / velDividers.method_10214(), newZ / velDividers.method_10215()));
        }
        return list;
    }

    public static class_243[] getParticleOutburstCordsArray(int particleAmount, class_243 velDividers, double sizeMod) {
        class_243[] results = new class_243[particleAmount];
        double d = RANDOM.nextGaussian() * 0.05;
        double e = RANDOM.nextGaussian() * 0.05;
        double f = RANDOM.nextGaussian() * 0.05;
        for (int j = 0; j < particleAmount; ++j) {
            double newX = (RANDOM.nextDouble() - 0.5 + RANDOM.nextGaussian() * 0.15 + d) * sizeMod;
            double newZ = (RANDOM.nextDouble() - 0.5 + RANDOM.nextGaussian() * 0.15 + e) * sizeMod;
            double newY = (RANDOM.nextDouble() - 0.5 + RANDOM.nextGaussian() * 0.15 + f) * sizeMod;
            results[j] = new class_243(newX / velDividers.method_10216(), newY / velDividers.method_10214(), newZ / velDividers.method_10215());
        }
        return results;
    }

    private static String generateCacheKey(int amount, class_243 velDivider, float sizeMod) {
        return amount + ":" + velDivider.field_1352 + "," + velDivider.field_1351 + "," + velDivider.field_1350 + ":" + sizeMod;
    }

    public static List<class_243> getSphereParticleCords(double points, float sizeModifier) {
        ArrayList<class_243> list = new ArrayList<class_243>();
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            class_243 vec = new class_243(velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            list.add(vec);
            ++i;
        }
        return list;
    }

    public static class RGB {
        float r;
        float g;
        float b;

        public RGB(float red, float green, float blue) {
            this.r = red / 255.0f;
            this.g = green / 255.0f;
            this.b = blue / 255.0f;
        }

        public float getRed() {
            return this.r;
        }

        public float getGreen() {
            return this.g;
        }

        public float getBlue() {
            return this.b;
        }
    }
}

