/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.event;

import com.eccarrascon.structurecredits.StructureCreditsClient;
import com.eccarrascon.structurecredits.registry.KeyMapRegistry;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class DisplayNameClient
implements ClientTickEvent.Client {
    private static String lastStructure = "haley:you_found_it!";

    public void tick(class_310 instance) {
        KeyMapRegistry keyMapRegistry = KeyMapRegistry.getInstance();
        while (keyMapRegistry.getDeactivateMsgKeyMapping().method_1436()) {
            this.toggleActiveState();
        }
        while (keyMapRegistry.getShowAgainMsgKeyMapping().method_1436()) {
            this.showLastStructureMessage();
        }
        while (keyMapRegistry.getDontShowMsgKeyMapping().method_1436()) {
            this.addCurrentStructureToDontShow();
        }
    }

    public static void updateStructureName(String structureName, boolean isPacket) {
        block5: {
            String structureNameFormatted;
            String modName;
            block6: {
                if (Objects.equals(lastStructure, structureName) && isPacket) {
                    return;
                }
                if (!StructureCreditsClient.CONFIG_VALUES.isActive() && isPacket) break block5;
                lastStructure = structureName;
                String customName = StructureCreditsClient.CONFIG_VALUES.getCustomStructureName().getOrDefault(structureName, structureName);
                String[] parts = customName.split(":");
                if (parts.length != 2) break block5;
                modName = DisplayNameClient.formatName(parts[0]);
                structureNameFormatted = DisplayNameClient.formatName(parts[1]);
                if (!isPacket) break block6;
                if (!StructureCreditsClient.CONFIG_VALUES.getDontShowAll().stream().noneMatch(structureName::startsWith) || StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(structureName)) break block5;
            }
            String messageKey = StructureCreditsClient.CONFIG_VALUES.isShowCreator() ? "text.structurecredits.message" : "text.structurecredits.message_no_creator";
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{structureNameFormatted, modName}), !StructureCreditsClient.CONFIG_VALUES.isChatMessage());
            if (isPacket && StructureCreditsClient.CONFIG_VALUES.isOnlyOneTime() && !StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(structureName)) {
                StructureCreditsClient.CONFIG_VALUES.getDontShow().add(structureName);
                StructureCreditsClient.CONFIG.save();
            }
        }
    }

    private static String formatName(String name) {
        return Arrays.stream(name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    private void toggleActiveState() {
        boolean isActive = !StructureCreditsClient.CONFIG_VALUES.isActive();
        StructureCreditsClient.CONFIG_VALUES.setActive(isActive);
        StructureCreditsClient.CONFIG.save();
        String messageKey = isActive ? "text.structurecredits.activated" : "text.structurecredits.deactivated";
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)messageKey), true);
    }

    private void showLastStructureMessage() {
        if (lastStructure != null) {
            DisplayNameClient.updateStructureName(lastStructure, false);
        }
    }

    private void addCurrentStructureToDontShow() {
        if (lastStructure != null) {
            if (!StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(lastStructure)) {
                StructureCreditsClient.CONFIG_VALUES.getDontShow().add(lastStructure);
                StructureCreditsClient.CONFIG.save();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.structurecredits.dont_show"), true);
            } else {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.structurecredits.already_dont_show"), true);
            }
        }
    }
}

