/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.LegacyFormattingParser;
import eu.pb4.placeholders.api.parsers.MarkdownLiteParserV1;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.PatternPlaceholderParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.JsonDataStorage;
import eu.pb4.styledchat.StyledChatEvents;
import eu.pb4.styledchat.StyledChatMod;
import eu.pb4.styledchat.StyledChatStyles;
import eu.pb4.styledchat.config.ChatStyle;
import eu.pb4.styledchat.config.Config;
import eu.pb4.styledchat.config.ConfigManager;
import eu.pb4.styledchat.config.data.ChatStyleData;
import eu.pb4.styledchat.config.data.VersionedChatStyleData;
import eu.pb4.styledchat.ducks.ExtPlayNetworkHandler;
import eu.pb4.styledchat.ducks.ExtSignedMessage;
import eu.pb4.styledchat.parser.LinkParser;
import eu.pb4.styledchat.parser.MentionParser;
import eu.pb4.styledchat.parser.SpoilerNode;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2300;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_7417;
import net.minecraft.class_7471;
import net.minecraft.class_7492;
import net.minecraft.class_7597;
import net.minecraft.class_7608;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class StyledChatUtils {
    public static final class_2561 IGNORED_TEXT = class_2561.method_43473();
    public static final Pattern URL_REGEX = Pattern.compile("(https?:\\/\\/[-a-zA-Z0-9@:%._\\+~#=]+\\.[^ ]+)");
    public static final String ITEM_KEY = "item";
    public static final String POS_KEY = "pos";
    public static final String SPOILER_TAG = "spoiler";
    private static final Function<class_5250, class_5250> COLOR_CLEARING = t -> t.method_10862(t.method_10866().method_27703((class_5251)null));
    public static JsonDataStorage<VersionedChatStyleData> PLAYER_DATA = new JsonDataStorage("styled_chat_style", VersionedChatStyleData.class, ConfigManager.GSON);
    public static final TextParserV1.TagNodeBuilder SPOILER_TAG_HANDLER = (tag, data, input, handlers, endAt) -> {
        TextParserV1.NodeList out = TextParserV1.parseNodesWith((String)input, (TextParserV1.TagParserGetter)handlers, (String)endAt);
        return new TextParserV1.TagNodeValue((TextNode)new SpoilerNode(out.nodes()), out.length());
    };
    public static final TextParserV1.TextTag SPOILER_TEXT_TAG = TextParserV1.TextTag.of((String)"spoiler", List.of("hide"), (String)"styledchat", (boolean)true, (TextParserV1.TagNodeBuilder)SPOILER_TAG_HANDLER);
    public static final String FORMAT_PERMISSION_BASE = "styledchat.format.";
    public static final String FORMAT_PERMISSION_UNSAFE = "styledchat.unsafe_format.";
    public static final Pattern EMOTE_PATTERN = Pattern.compile("(?<!((?<!(\\\\))\\\\))[:](?<id>[^:]+)[:]");
    public static final class_2561 EMPTY_TEXT = class_2561.method_43473();
    private static final Set<class_5321<class_2556>> DECORABLE = Set.of(class_2556.field_11737, class_2556.field_39231, class_2556.field_39799, class_2556.field_39800, class_2556.field_39228, class_2556.field_39881, class_2556.field_39882);

    @Deprecated
    public static TextNode parseText(String input) {
        return !input.isEmpty() ? Placeholders.parseNodes((TextNode)TextParserUtils.formatNodes((String)input)) : EmptyNode.INSTANCE;
    }

    public static NodeParser createParser(class_2168 source) {
        return StyledChatUtils.createParser(PlaceholderContext.of((class_2168)source));
    }

    public static NodeParser createParser(PlaceholderContext context) {
        Map<String, TextNode> emotes;
        ArrayList<Object> form;
        Config config = ConfigManager.getConfig();
        ArrayList<Object> list = new ArrayList<Object>();
        TextParserV1 base = StyledChatUtils.createTextParserV1(context.source());
        list.add(base);
        if (config.configData.formatting.parseLinksInChat) {
            list.add(new LinkParser(ConfigManager.getConfig().getLinkStyle(context)));
        }
        if (config.configData.formatting.parseMentionsInChat) {
            list.add(new MentionParser(ConfigManager.getConfig().getMentionStyle(context), context));
        }
        if (config.configData.formatting.markdown) {
            form = new ArrayList<Object>();
            if (base.getTagParser("bold") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.BOLD);
            }
            if (base.getTagParser("italic") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.ITALIC);
            }
            if (base.getTagParser("underline") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.UNDERLINE);
            }
            if (base.getTagParser("strikethrough") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.STRIKETHROUGH);
            }
            if (base.getTagParser(SPOILER_TAG) != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.SPOILER);
            }
            if (base.getTagParser("link") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.URL);
            }
            if (!form.isEmpty()) {
                list.add(new MarkdownLiteParserV1(SpoilerNode::new, MarkdownLiteParserV1::defaultQuoteFormatting, form.toArray(new MarkdownLiteParserV1.MarkdownFormat[0])));
            }
        }
        if (config.configData.formatting.legacyChatFormatting) {
            boolean color;
            form = new ArrayList();
            for (class_124 formatting : class_124.values()) {
                if (base.getTagParser(formatting.method_537()) == null) continue;
                form.add(formatting);
            }
            boolean bl = color = base.getTagParser("color") != null;
            if (!form.isEmpty() || color) {
                list.add(new LegacyFormattingParser(color, form.toArray(new class_124[0])));
            }
        }
        if (!(emotes = StyledChatUtils.getEmotes(context)).isEmpty()) {
            list.add(new PatternPlaceholderParser(EMOTE_PATTERN, emotes::get));
        }
        return NodeParser.merge(list);
    }

    public static TextParserV1 createTextParserV1(class_2168 source) {
        TextParserV1 parser = new TextParserV1();
        Config config = ConfigManager.getConfig();
        Object2BooleanOpenHashMap<String> allowedFormatting = config.getAllowedFormatting(source);
        for (TextParserV1.TextTag entry : TextParserV1.DEFAULT.getTags()) {
            if (!allowedFormatting.getBoolean((Object)entry.name()) && !Permissions.check((class_2172)source, (String)((entry.userSafe() ? FORMAT_PERMISSION_BASE : FORMAT_PERMISSION_UNSAFE) + entry.name()), (int)(entry.userSafe() ? 2 : 4)) && !Permissions.check((class_2172)source, (String)((entry.userSafe() ? FORMAT_PERMISSION_BASE : FORMAT_PERMISSION_UNSAFE) + ".type." + entry.type()), (int)(entry.userSafe() ? 2 : 4))) continue;
            parser.register(entry);
        }
        if (allowedFormatting.getBoolean((Object)SPOILER_TAG) || Permissions.check((class_2172)source, (String)"styledchat.format.spoiler", (int)2)) {
            parser.register(SPOILER_TEXT_TAG);
        }
        ((StyledChatEvents.FormattingCreationEvent)StyledChatEvents.FORMATTING_CREATION_EVENT.invoker()).onFormattingBuild(source, parser);
        return parser;
    }

    public static Map<String, TextNode> getEmotes(PlaceholderContext context) {
        return StyledChatStyles.getEmotes(context.hasPlayer() ? context.player().method_5671() : context.server().method_3739());
    }

    public static class_2561 formatFor(PlaceholderContext context, String input) {
        NodeParser parser = StyledChatUtils.createParser(context);
        Config config = ConfigManager.getConfig();
        if (StyledChatMod.USE_FABRIC_API) {
            input = ((StyledChatEvents.PreMessageEvent)StyledChatEvents.PRE_MESSAGE_CONTENT.invoker()).onPreMessage(input, context);
        }
        TextNode value = TextNode.asSingle((TextNode[])parser.parseNodes((TextNode)new LiteralNode(input)));
        if (StyledChatMod.USE_FABRIC_API) {
            value = ((StyledChatEvents.MessageEvent)StyledChatEvents.MESSAGE_CONTENT.invoker()).onMessage(value, context);
        }
        class_2561 text = value.toText(context);
        if (config.configData.formatting.respectColors) {
            try {
                text = (class_2561)context.server().method_43929().decorate(context.player(), text).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return text;
    }

    public static String legacyFormatMessage(String input, Set<String> handlers) {
        Config config = ConfigManager.getConfig();
        try {
            if (config.configData.formatting.markdown) {
                if (handlers.contains(SPOILER_TAG)) {
                    input = input.replaceAll(StyledChatUtils.getMarkdownRegex("||", "\\|\\|"), "<spoiler>$2</spoiler>");
                }
                if (handlers.contains("bold")) {
                    input = input.replaceAll(StyledChatUtils.getMarkdownRegex("**", "\\*\\*"), "<bold>$2</bold>");
                }
                if (handlers.contains("underline")) {
                    input = input.replaceAll(StyledChatUtils.getMarkdownRegex("__", "__"), "<underline>$2</underline>");
                }
                if (handlers.contains("strikethrough")) {
                    input = input.replaceAll(StyledChatUtils.getMarkdownRegex("~~", "~~"), "<strikethrough>$2</strikethrough>");
                }
                if (handlers.contains("italic")) {
                    input = input.replaceAll(StyledChatUtils.getMarkdownRegex("*", "\\*"), "<italic>$2</italic>");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return input;
    }

    private static String getMarkdownRegex(String base, String sides) {
        return "(" + sides + ")(?<id>[^" + base + "]+)(" + sides + ")";
    }

    public static class_7492 getChatDecorator() {
        return (player, message) -> {
            if (player != null) {
                return CompletableFuture.completedFuture(StyledChatStyles.getChat(player, StyledChatUtils.formatFor(PlaceholderContext.of((class_3222)player), message.getString())));
            }
            return CompletableFuture.completedFuture(StyledChatUtils.formatFor(PlaceholderContext.of((MinecraftServer)StyledChatMod.server), message.getString()));
        };
    }

    public static class_7492 getRawDecorator() {
        return (player, message) -> {
            if (player != null) {
                return CompletableFuture.completedFuture(StyledChatUtils.formatFor(PlaceholderContext.of((class_3222)player), message.getString()));
            }
            return CompletableFuture.completedFuture(StyledChatUtils.formatFor(PlaceholderContext.of((MinecraftServer)StyledChatMod.server), message.getString()));
        };
    }

    public static <T> class_7492 getCommandDecorator(String context, class_2168 source, BiFunction<String, Class<?>, Object> argumentGetter) {
        Config config = ConfigManager.getConfig();
        return (player, message) -> {
            class_2561 input = StyledChatUtils.formatFor(player != null ? PlaceholderContext.of((class_3222)player) : PlaceholderContext.of((MinecraftServer)StyledChatMod.server), message.getString());
            return CompletableFuture.completedFuture(switch (context) {
                case "msg" -> {
                    try {
                        class_2561 var9_9;
                        yield var9_9 = config.getPrivateMessageReceived(source.method_9223(), ((class_3222)((class_2300)argumentGetter.apply("targets", class_2300.class)).method_9813(source).get(0)).method_5476(), input, source);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        class_5250 var9_10 = class_2561.method_43470((String)"");
                        yield var9_10;
                    }
                }
                case "teammsg" -> {
                    try {
                        class_2561 var9_11;
                        yield var9_11 = config.getTeamChatReceived((class_2561)((class_268)source.method_9228().method_5781()).method_1148(), source.method_9223(), input, source);
                    }
                    catch (Exception e) {
                        class_5250 var9_12 = class_2561.method_43470((String)"");
                        yield var9_12;
                    }
                }
                case "say" -> {
                    class_2561 var9_13;
                    yield var9_13 = config.getSayCommand(source, input);
                }
                case "me" -> {
                    class_2561 var9_14;
                    yield var9_14 = config.getMeCommand(source, input);
                }
                default -> {
                    class_2561 var9_15;
                    yield var9_15 = input;
                }
            });
        };
    }

    @Deprecated
    public static TextNode additionalParsing(TextNode node, PlaceholderContext context) {
        if (ConfigManager.getConfig().configData.formatting.parseLinksInChat) {
            node = StyledChatUtils.parseLinks(node, context);
        }
        return node;
    }

    @Deprecated
    public static TextNode parseLinks(TextNode node, PlaceholderContext context) {
        return TextNode.asSingle((TextNode[])LinkParser.parse(node, context));
    }

    public static class_2556.class_7602 removeColor(class_2556.class_7602 parameters) {
        return new class_2556.class_7602(parameters.comp_919(), StyledChatUtils.removeColor(parameters.comp_920()), parameters.comp_921());
    }

    public static class_2561 removeColor(class_2561 text) {
        return GeneralUtils.cloneTransformText((class_2561)text, COLOR_CLEARING);
    }

    public static boolean isHandledByMod(class_5321<class_2556> typeKey) {
        return DECORABLE.contains(typeKey);
    }

    public static void modifyForSending(class_7471 message, class_2168 source, class_5321<class_2556> type) {
        try {
            ExtSignedMessage.setArg(message, "override", StyledChatUtils.formatMessage(message, source, type));
            ((ExtSignedMessage)message).styledChat_setType(type);
            ((ExtSignedMessage)message).styledChat_setSource(source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_2561 formatMessage(class_7471 message, class_2168 source, class_5321<class_2556> type) {
        class_2561 input;
        ExtSignedMessage ext = (ExtSignedMessage)message;
        class_2561 baseInput = ext.styledChat_getArg("base_input");
        class_2561 class_25612 = input = baseInput != null && baseInput.method_10851() != class_7417.field_39004 ? baseInput : StyledChatUtils.maybeFormatFor(source, ext.styledChat_getOriginal(), message.method_46291());
        if (baseInput == EMPTY_TEXT) {
            ext.styledChat_setArg("base_input", input);
        }
        return switch (type.method_29177().method_12832()) {
            case "msg_command_incoming" -> {
                try {
                    class_2561 var8_8;
                    yield var8_8 = StyledChatStyles.getPrivateMessageReceived(source.method_9223(), ext.styledChat_getArg("targets"), input, source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    class_5250 var8_9 = class_2561.method_43473();
                    yield var8_9;
                }
            }
            case "msg_command_outgoing" -> {
                try {
                    class_2561 var8_10;
                    yield var8_10 = StyledChatStyles.getPrivateMessageSent(source.method_9223(), ext.styledChat_getArg("targets"), input, source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    class_5250 var8_11 = class_2561.method_43473();
                    yield var8_11;
                }
            }
            case "team_msg_command_incoming" -> {
                try {
                    class_2561 var8_12;
                    yield var8_12 = StyledChatStyles.getTeamChatReceived((class_2561)((class_268)source.method_9228().method_5781()).method_1148(), source.method_9223(), input, source);
                }
                catch (Exception e) {
                    class_5250 var8_13 = class_2561.method_43470((String)"");
                    yield var8_13;
                }
            }
            case "team_msg_command_outgoing" -> {
                try {
                    class_2561 var8_14;
                    yield var8_14 = StyledChatStyles.getTeamChatSent((class_2561)((class_268)source.method_9228().method_5781()).method_1148(), source.method_9223(), input, source);
                }
                catch (Exception e) {
                    class_5250 var8_15 = class_2561.method_43470((String)"");
                    yield var8_15;
                }
            }
            case "say_command" -> {
                class_2561 var8_16;
                yield var8_16 = StyledChatStyles.getSayCommand(source, input);
            }
            case "emote_command" -> {
                class_2561 var8_17;
                yield var8_17 = StyledChatStyles.getMeCommand(source, input);
            }
            case "chat" -> {
                class_2561 var8_18;
                yield var8_18 = StyledChatStyles.getChat(source.method_44023(), input);
            }
            default -> {
                class_2561 var8_19;
                yield var8_19 = StyledChatStyles.getCustom(type.method_29177(), source.method_9223(), input, null, source);
            }
        };
    }

    public static class_2561 maybeFormatFor(class_2168 source, String original, class_2561 originalContent) {
        return StyledChatUtils.formatFor(source, original);
    }

    public static class_2561 formatFor(class_2168 source, String original) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return StyledChatUtils.formatFor(PlaceholderContext.of((class_3222)player), original);
        }
        return StyledChatUtils.formatFor(PlaceholderContext.of((MinecraftServer)source.method_9211()), original);
    }

    @Deprecated
    public static class_7471 toEventMessage(class_7471 message, PlaceholderContext context) {
        class_2561 input;
        ExtSignedMessage ext = (ExtSignedMessage)message;
        class_2561 baseInput = ext.styledChat_getArg("base_input");
        class_2561 class_25612 = input = baseInput != EMPTY_TEXT && baseInput.method_10851() != class_7417.field_39004 ? baseInput : StyledChatUtils.formatFor(context, ext.styledChat_getOriginal());
        if (baseInput == EMPTY_TEXT) {
            ext.styledChat_setArg("base_input", input);
        }
        return new class_7471(message.comp_1083(), null, class_7608.method_46305((String)message.method_44862()), input, null);
    }

    @Deprecated(forRemoval=true)
    public static void sendAutocompliton(class_3222 player) {
        StyledChatUtils.sendAutoCompletion(player, ConfigManager.getConfig().allPossibleAutoCompletionKeys);
    }

    public static void sendAutoCompletion(class_3222 player, Collection<String> oldAutoCompletion) {
        Config config = ConfigManager.getConfig();
        player.field_13987.method_14364((class_2596)new class_7597(class_7597.class_7598.field_39802, new ArrayList<String>(oldAutoCompletion)));
        HashSet<CallSite> set = new HashSet<CallSite>();
        class_2168 source = player.method_5671();
        TextParserV1 handler = StyledChatUtils.createTextParserV1(source);
        if (config.configData.autoCompletion.tags) {
            for (TextParserV1.TextTag tag : handler.getTags()) {
                set.add((CallSite)((Object)("<" + tag.name() + ">")));
                if (!config.configData.autoCompletion.tagAliases || tag.aliases() == null) continue;
                for (String a : tag.aliases()) {
                    set.add((CallSite)((Object)("<" + a + ">")));
                }
            }
        }
        if (config.configData.autoCompletion.emoticons) {
            for (String emote : config.getEmotes(source).keySet()) {
                set.add((CallSite)((Object)(":" + emote + ":")));
            }
        }
        if (!set.isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_7597(class_7597.class_7598.field_39801, new ArrayList(set)));
        }
    }

    public static ChatStyle getPersonalStyle(class_3222 player) {
        if (player.field_13987 != null) {
            return ((ExtPlayNetworkHandler)player.field_13987).styledChat$getStyle();
        }
        return ChatStyle.EMPTY;
    }

    public static void updateStyle(class_3222 player) {
        if (player.field_13987 != null) {
            ((ExtPlayNetworkHandler)player.field_13987).styledChat$setStyle(StyledChatUtils.createStyleOf(player));
        }
    }

    @Nullable
    public static ChatStyleData getPersonalData(class_3222 player) {
        return (ChatStyleData)PlayerDataApi.getCustomDataFor((class_3222)player, PLAYER_DATA);
    }

    public static ChatStyleData getOrCreatePersonalData(class_3222 player) {
        VersionedChatStyleData style = (VersionedChatStyleData)PlayerDataApi.getCustomDataFor((class_3222)player, PLAYER_DATA);
        if (style == null) {
            style = new VersionedChatStyleData();
            PlayerDataApi.setCustomDataFor((class_3222)player, PLAYER_DATA, (Object)style);
        }
        return style;
    }

    public static void clearPersonalStyleData(class_3222 player) {
        PlayerDataApi.setCustomDataFor((class_3222)player, PLAYER_DATA, (Object)new VersionedChatStyleData());
    }

    public static ChatStyle createStyleOf(class_3222 player) {
        VersionedChatStyleData style = (VersionedChatStyleData)PlayerDataApi.getCustomDataFor((class_3222)player, PLAYER_DATA);
        style = style == null ? new VersionedChatStyleData() : (VersionedChatStyleData)style.clone();
        style.fillPermissionOptionProvider(player.method_5671());
        return new ChatStyle(style);
    }

    public static class_2556.class_7602 createParameters(class_2561 override) {
        return new class_2556.class_7602(StyledChatMod.getMessageType(), override, null);
    }
}

