/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.styledplayerlist.GenericModInfo;
import eu.pb4.styledplayerlist.access.PlayerListViewerHolder;
import eu.pb4.styledplayerlist.config.ConfigManager;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import java.util.Collection;
import java.util.Locale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Commands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"styledplayerlist").requires(Permissions.require((String)"styledplayerlist.main", (boolean)true))).executes(Commands::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"switch").requires(Permissions.require((String)"styledplayerlist.switch", (boolean)true))).then(Commands.switchArgument("style").executes(Commands::switchStyle)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"switchothers").requires(Permissions.require((String)"styledplayerlist.switch.others", (int)2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(Commands.switchArgument("style").executes(Commands::switchStyleOthers))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"styledplayerlist.reload", (int)3))).executes(Commands::reloadConfig)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"plstyle").requires(Permissions.require((String)"styledplayerlist.switch", (boolean)true))).then(Commands.switchArgument("style").executes(Commands::switchStyle)));
        });
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        if (ConfigManager.loadConfig()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloaded config!"), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error accrued while reloading config!").method_27692(class_124.field_1061));
        }
        for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            ((PlayerListViewerHolder)player.field_13987).styledPlayerList$reloadStyle();
        }
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        for (class_2561 text : ((class_2168)context.getSource()).method_9228() instanceof class_3222 ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((class_2168)context.getSource()).method_9226(() -> text, false);
        }
        return 1;
    }

    public static int switchStyleOthers(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String styleId = (String)context.getArgument("style", String.class);
        Collection target = class_2186.method_9312(context, (String)"targets");
        if (!ConfigManager.styleExist(styleId)) {
            source.method_9226(() -> ConfigManager.getConfig().unknownStyleMessage, false);
            return 0;
        }
        PlayerListStyle style = ConfigManager.getStyle(styleId);
        for (class_3222 player : target) {
            ((PlayerListViewerHolder)player.field_13987).styledPlayerList$setStyle(styleId);
        }
        source.method_9226(() -> class_2561.method_43470((String)("Changed player list style of targets to " + style.name)), false);
        return 2;
    }

    private static int switchStyle(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            class_2168 source = (class_2168)context.getSource();
            String styleId = (String)context.getArgument("style", String.class);
            if (!ConfigManager.styleExist(styleId)) {
                source.method_9226(() -> ConfigManager.getConfig().unknownStyleMessage, false);
                return 0;
            }
            PlayerListStyle style = ConfigManager.getStyle(styleId);
            class_3222 player = source.method_44023();
            if (player != null && player instanceof class_3222) {
                if (style.hasPermission(player)) {
                    ((PlayerListViewerHolder)player.field_13987).styledPlayerList$setStyle(styleId);
                    source.method_9226(() -> ConfigManager.getConfig().getSwitchMessage(player, style.name), false);
                    return 1;
                }
                source.method_9226(() -> ConfigManager.getConfig().permissionMessage, false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"Only players can use this command!"), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static RequiredArgumentBuilder<class_2168, String> switchArgument(String name) {
        return class_2170.method_9244((String)name, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (PlayerListStyle style : ConfigManager.getStyles()) {
                if (!style.id.contains(remaining) || !style.hasPermission((class_2168)ctx.getSource())) continue;
                builder.suggest(style.id);
            }
            return builder.buildFuture();
        });
    }
}

