/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.config;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.PatternPlaceholderParser;
import eu.pb4.placeholders.api.parsers.StaticPreParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.styledplayerlist.SPLHelper;
import eu.pb4.styledplayerlist.config.DynamicNode;
import eu.pb4.styledplayerlist.config.data.ConfigData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final NodeParser PARSER = NodeParser.merge((NodeParser[])new NodeParser[]{TextParserV1.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER, new PatternPlaceholderParser(PatternPlaceholderParser.PREDEFINED_PLACEHOLDER_PATTERN, DynamicNode::of), StaticPreParser.INSTANCE});
    public final ConfigData configData;
    public final TextNode playerNameFormat;
    public final TextNode switchMessage;
    public final class_2561 unknownStyleMessage;
    public final class_2561 permissionMessage;
    private final List<PermissionNameFormat> permissionNameFormat;
    public final boolean isHiddenDefault;
    private final boolean passthroughDefault;

    public Config(ConfigData data) {
        this.configData = data;
        this.playerNameFormat = Config.parseText(data.playerName.playerNameFormat);
        this.switchMessage = Config.parseText(data.messages.switchMessage);
        this.unknownStyleMessage = Config.parseText(data.messages.unknownStyleMessage).toText();
        this.permissionMessage = Config.parseText(data.messages.permissionMessage).toText();
        this.isHiddenDefault = data.playerName.hidePlayer;
        this.passthroughDefault = data.playerName.ignoreFormatting;
        this.permissionNameFormat = new ArrayList<PermissionNameFormat>();
        for (ConfigData.PermissionNameFormat entry : data.playerName.permissionNameFormat) {
            this.permissionNameFormat.add(new PermissionNameFormat(entry.require != null ? entry.require : BuiltinPredicates.operatorLevel((int)5), Config.parseText(entry.format), entry.ignoreFormatting, entry.hidePlayer != null ? entry.hidePlayer : this.isHiddenDefault));
        }
    }

    public static TextNode parseText(String string) {
        return PARSER.parseNode(string);
    }

    public class_2561 getSwitchMessage(class_3222 player, String target) {
        return this.switchMessage.toText(ParserContext.of(DynamicNode.NODES, Map.of("style", class_2561.method_43470((String)target))));
    }

    @Nullable
    public class_2561 formatPlayerUsername(class_3222 player) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (PermissionNameFormat entry : this.permissionNameFormat) {
            if (!entry.predicate.test(context).success()) continue;
            return entry.passthrough ? null : entry.style.toText(PlaceholderContext.of((class_3222)player, (PlaceholderContext.ViewObject)SPLHelper.PLAYER_NAME_VIEW));
        }
        return this.passthroughDefault ? null : this.playerNameFormat.toText(PlaceholderContext.of((class_3222)player, (PlaceholderContext.ViewObject)SPLHelper.PLAYER_NAME_VIEW));
    }

    public boolean isPlayerHidden(class_3222 player) {
        PredicateContext context = PredicateContext.of((class_3222)player);
        for (PermissionNameFormat entry : this.permissionNameFormat) {
            if (!entry.predicate.test(context).success()) continue;
            return entry.hidden;
        }
        return this.isHiddenDefault;
    }

    record PermissionNameFormat(MinecraftPredicate predicate, TextNode style, boolean passthrough, boolean hidden) {
    }
}

