/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.mixin;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.styledplayerlist.PlayerList;
import eu.pb4.styledplayerlist.SPLHelper;
import eu.pb4.styledplayerlist.access.PlayerListViewerHolder;
import eu.pb4.styledplayerlist.config.ConfigManager;
import eu.pb4.styledplayerlist.config.DefaultValues;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import eu.pb4.styledplayerlist.config.data.ConfigData;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2772;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4614;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class ServerPlayNetworkManagerMixin
implements PlayerListViewerHolder {
    @Shadow
    public class_3222 field_14140;
    @Shadow
    @Final
    private MinecraftServer field_14148;
    @Unique
    private String styledPlayerList$activeStyle = ConfigManager.getDefault();
    @Unique
    private PlayerListStyle styledPlayerList$style = DefaultValues.EMPTY_STYLE;
    @Unique
    private int styledPlayerList$animationTick = 0;

    @Shadow
    public abstract void method_14364(class_2596<?> var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void styledPlayerList$loadData(MinecraftServer server, class_2535 connection, class_3222 player, CallbackInfo ci) {
        try {
            class_2519 style = (class_2519)PlayerDataApi.getGlobalDataFor((class_3222)player, (class_2960)PlayerList.id("style"), (class_4614)class_2519.field_21045);
            if (style != null) {
                this.styledPlayerList$setStyle(style.method_10714());
            } else {
                this.styledPlayerList$reloadStyle();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void styledPlayerList$updatePlayerList(CallbackInfo ci) {
        if (ConfigManager.isEnabled() && SPLHelper.shouldSendPlayerList(this.field_14140)) {
            int tick = this.field_14148.method_3780();
            ConfigData config = ConfigManager.getConfig().configData;
            if (tick % this.styledPlayerList$style.updateRate == 0) {
                PlaceholderContext context = PlaceholderContext.of((class_3222)this.field_14140, (PlaceholderContext.ViewObject)SPLHelper.PLAYER_LIST_VIEW);
                this.method_14364((class_2596<?>)new class_2772(this.styledPlayerList$style.getHeader(context, this.styledPlayerList$animationTick), this.styledPlayerList$style.getFooter(context, this.styledPlayerList$animationTick)));
                ++this.styledPlayerList$animationTick;
            }
            if (config.playerName.playerNameUpdateRate > 0L && (long)tick % config.playerName.playerNameUpdateRate == 0L) {
                this.styledPlayerList$updateName();
            }
        }
    }

    @Inject(method={"handleDecoratedMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;checkForSpam()V")})
    private void styledPlayerList$onMessage(class_7471 signedMessage, CallbackInfo ci) {
        if (ConfigManager.isEnabled() && ConfigManager.getConfig().configData.playerName.updatePlayerNameEveryChatMessage) {
            this.styledPlayerList$updateName();
        }
    }

    @Override
    public void styledPlayerList$setStyle(String key) {
        this.styledPlayerList$activeStyle = ConfigManager.isEnabled() ? (ConfigManager.styleExist(key) ? key : ConfigManager.getDefault()) : "default";
        this.styledPlayerList$reloadStyle();
        PlayerDataApi.setGlobalDataFor((class_3222)this.field_14140, (class_2960)PlayerList.id("style"), (class_2520)class_2519.method_23256((String)this.styledPlayerList$activeStyle));
    }

    @Override
    public String styledPlayerList$getStyle() {
        return this.styledPlayerList$activeStyle;
    }

    @Override
    public void styledPlayerList$updateName() {
        try {
            if (ConfigManager.isEnabled() && ConfigManager.getConfig().configData.playerName.changePlayerName) {
                class_2703 packet = new class_2703(EnumSet.of(class_2703.class_5893.field_29139, class_2703.class_5893.field_40700), List.of(this.field_14140));
                this.field_14148.method_3760().method_14581((class_2596)packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void styledPlayerList$reloadStyle() {
        PlayerListStyle style = ConfigManager.getStyle(this.styledPlayerList$activeStyle);
        if (style != this.styledPlayerList$style) {
            this.styledPlayerList$style = style;
            this.styledPlayerList$animationTick = 0;
        }
    }

    @Override
    public int styledPlayerList$getAndIncreaseAnimationTick() {
        return this.styledPlayerList$animationTick++;
    }

    @Override
    public PlayerListStyle styledPlayerList$getStyleObject() {
        return this.styledPlayerList$style;
    }
}

