/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.bundle;

import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public final class BundleFeatures {
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_SELECTED_ITEM = "SelectedItem";
    public static final int MAX_WEIGHT = 64;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int NO_SELECTED_ITEM = -1;

    public static boolean onBundleUpdate() {
        return (Boolean)VanillaBackport.COMMON_CONFIG.hasUpdatedBundles.get();
    }

    public static boolean canItemBeInBundle(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().method_31568();
    }

    @Nullable
    public static class_1799 removeOne(class_1799 bundle) {
        class_2499 items;
        class_2487 tag = bundle.method_7948();
        if (tag.method_10545(TAG_ITEMS) && !(items = tag.method_10554(TAG_ITEMS, 10)).isEmpty()) {
            int index;
            int selectedItem = tag.method_10550(TAG_SELECTED_ITEM);
            int n = index = BundleFeatures.isValidIndex(selectedItem, items.size()) ? selectedItem : 0;
            if (!BundleFeatures.isValidIndex(index, items.size())) {
                return null;
            }
            class_2487 itemTag = items.method_10602(index);
            class_1799 removedItem = class_1799.method_7915((class_2487)itemTag);
            items.method_10536(index);
            if (items.isEmpty()) {
                bundle.method_7983(TAG_ITEMS);
            }
            BundleFeatures.setSelectedItem(bundle, -1);
            return removedItem;
        }
        return null;
    }

    public static Stream<class_1799> getContents(class_1799 bundle) {
        class_2487 tag = bundle.method_7969();
        if (tag == null || !tag.method_10545(TAG_ITEMS)) {
            return Stream.empty();
        }
        class_2499 items = tag.method_10554(TAG_ITEMS, 10);
        return items.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    public static int getWeight(class_1799 stack) {
        if (stack.method_31573(ModItemTags.BUNDLES)) {
            return 4 + BundleFeatures.getContentWeight(stack);
        }
        return 64 / stack.method_7914();
    }

    public static int getContentWeight(class_1799 bundle) {
        return BundleFeatures.getContents(bundle).mapToInt(item -> BundleFeatures.getWeight(item) * item.method_7947()).sum();
    }

    private static Optional<class_2487> getMatchingItem(class_1799 stack, class_2499 items) {
        return items.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(tag -> class_1799.method_31577((class_1799)class_1799.method_7915((class_2487)tag), (class_1799)stack)).findFirst();
    }

    public static void setSelectedItem(class_1799 bundle, int index) {
        class_2487 tag = bundle.method_7948();
        tag.method_10569(TAG_SELECTED_ITEM, index);
    }

    public static int getSelectedItem(class_1799 bundle) {
        class_2499 items;
        class_2487 tag = bundle.method_7969();
        if (tag == null || !tag.method_10545(TAG_SELECTED_ITEM)) {
            return -1;
        }
        int selectedItem = tag.method_10550(TAG_SELECTED_ITEM);
        if (!BundleFeatures.isValidIndex(selectedItem, (items = tag.method_10554(TAG_ITEMS, 10)).size())) {
            return -1;
        }
        return selectedItem;
    }

    public static int tryInsert(class_1799 bundle, class_1799 item) {
        if (!BundleFeatures.canItemBeInBundle(item)) {
            return 0;
        }
        class_2487 tag = bundle.method_7948();
        if (!tag.method_10545(TAG_ITEMS)) {
            tag.method_10566(TAG_ITEMS, (class_2520)new class_2499());
        }
        class_2499 items = tag.method_10554(TAG_ITEMS, 10);
        int currentWeight = BundleFeatures.getContentWeight(bundle);
        int itemWeight = BundleFeatures.getWeight(item);
        int maxToAdd = Math.min(item.method_7947(), (64 - currentWeight) / itemWeight);
        if (maxToAdd == 0) {
            return 0;
        }
        Optional<class_2487> matchingItem = BundleFeatures.getMatchingItem(item, items);
        if (matchingItem.isPresent()) {
            class_2487 itemTag = matchingItem.get();
            class_1799 existingStack = class_1799.method_7915((class_2487)itemTag);
            existingStack.method_7933(maxToAdd);
            existingStack.method_7953(itemTag);
            items.remove((Object)itemTag);
            items.method_10531(0, (class_2520)itemTag);
        } else {
            class_1799 newStack = item.method_46651(maxToAdd);
            class_2487 newTag = new class_2487();
            newStack.method_7953(newTag);
            items.method_10531(0, (class_2520)newTag);
        }
        item.method_7934(maxToAdd);
        return maxToAdd;
    }

    public static int tryTransfer(class_1799 bundle, class_1735 slot, class_1657 player) {
        class_1799 slotStack = slot.method_7677();
        if (!BundleFeatures.canItemBeInBundle(slotStack)) {
            return 0;
        }
        int currentWeight = BundleFeatures.getContentWeight(bundle);
        int itemWeight = BundleFeatures.getWeight(slotStack);
        int maxToAdd = Math.min(slotStack.method_7947(), (64 - currentWeight) / itemWeight);
        if (maxToAdd == 0) {
            return 0;
        }
        class_1799 takenStack = slot.method_32753(slotStack.method_7947(), maxToAdd, player);
        return BundleFeatures.tryInsert(bundle, takenStack);
    }

    public static void toggleSelectedItem(class_1799 bundle, int index) {
        class_2487 tag = bundle.method_7948();
        int selected0 = tag.method_10550(TAG_SELECTED_ITEM);
        if (!tag.method_10545(TAG_ITEMS)) {
            BundleFeatures.setSelectedItem(bundle, -1);
            return;
        }
        class_2499 items = tag.method_10554(TAG_ITEMS, 10);
        if (!BundleFeatures.isValidIndex(index, items.size())) {
            BundleFeatures.setSelectedItem(bundle, -1);
            return;
        }
        boolean outsideBounds = index < 0 || index >= items.size();
        int selected = selected0 != index && !outsideBounds ? index : -1;
        BundleFeatures.setSelectedItem(bundle, selected);
    }

    private static boolean isValidIndex(int index, int size) {
        return index >= 0 && index < size;
    }

    public static int getNumberOfItemsToShow(class_1799 bundle) {
        class_2487 tag = bundle.method_7969();
        if (tag != null && tag.method_10545(TAG_ITEMS)) {
            return BundleFeatures.getItemsToShow(tag.method_10554(TAG_ITEMS, 10).stream().toList());
        }
        return 0;
    }

    public static int getItemsToShow(List<?> items) {
        int contents = items.size();
        int maxDisplay = contents > 12 ? 11 : 12;
        int remainder = contents % 4;
        int padding = remainder == 0 ? 0 : 4 - remainder;
        return Math.min(contents, maxDisplay - padding);
    }

    public static class_1799 getSelectedItemStack(class_1799 bundle) {
        int selectedIndex = BundleFeatures.getSelectedItem(bundle);
        if (selectedIndex == -1) {
            return class_1799.field_8037;
        }
        class_2487 tag = bundle.method_7969();
        if (tag == null || !tag.method_10545(TAG_ITEMS)) {
            return class_1799.field_8037;
        }
        class_2499 items = tag.method_10554(TAG_ITEMS, 10);
        if (!BundleFeatures.isValidIndex(selectedIndex, items.size())) {
            return class_1799.field_8037;
        }
        class_2487 itemTag = items.method_10602(selectedIndex);
        return class_1799.method_7915((class_2487)itemTag);
    }

    public static class_1792 getByColor(class_1767 dyeColor) {
        return switch (dyeColor) {
            case class_1767.field_7952 -> ModItems.WHITE_BUNDLE.get();
            case class_1767.field_7946 -> ModItems.ORANGE_BUNDLE.get();
            case class_1767.field_7958 -> ModItems.MAGENTA_BUNDLE.get();
            case class_1767.field_7951 -> ModItems.LIGHT_BLUE_BUNDLE.get();
            case class_1767.field_7947 -> ModItems.YELLOW_BUNDLE.get();
            case class_1767.field_7961 -> ModItems.LIME_BUNDLE.get();
            case class_1767.field_7954 -> ModItems.PINK_BUNDLE.get();
            case class_1767.field_7944 -> ModItems.GRAY_BUNDLE.get();
            case class_1767.field_7967 -> ModItems.LIGHT_GRAY_BUNDLE.get();
            case class_1767.field_7955 -> ModItems.CYAN_BUNDLE.get();
            case class_1767.field_7966 -> ModItems.BLUE_BUNDLE.get();
            case class_1767.field_7957 -> ModItems.BROWN_BUNDLE.get();
            case class_1767.field_7942 -> ModItems.GREEN_BUNDLE.get();
            case class_1767.field_7964 -> ModItems.RED_BUNDLE.get();
            case class_1767.field_7963 -> ModItems.BLACK_BUNDLE.get();
            case class_1767.field_7945 -> ModItems.PURPLE_BUNDLE.get();
            default -> class_1802.field_27023;
        };
    }
}

