/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.vanillabackport.common.api.leash.LeashState;
import com.blackgear.vanillabackport.common.api.leash.Leashable;
import com.blackgear.vanillabackport.core.mixin.access.EntityRendererAccessor;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_765;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class LeashRenderer<T extends class_1297> {
    private final class_898 dispatcher;
    @Nullable
    private List<LeashState> leashStates;

    public LeashRenderer(class_898 dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean shouldRender(T entity, class_4604 camera, boolean isVisible, boolean fallback) {
        if (!isVisible) {
            Leashable leashable;
            class_1297 holder;
            class_238 entityBox = entity.method_5830().method_1014(0.5);
            if (entityBox.method_1013() || entityBox.method_995() == 0.0) {
                entityBox = new class_238(entity.method_23317() - 2.0, entity.method_23318() - 2.0, entity.method_23321() - 2.0, entity.method_23317() + 2.0, entity.method_23318() + 2.0, entity.method_23321() + 2.0);
            }
            if (camera.method_23093(entityBox)) {
                return true;
            }
            if (entity instanceof Leashable && (holder = (leashable = (Leashable)entity).vb$getLeashHolder()) != null) {
                class_238 holderBox = holder.method_5830();
                return camera.method_23093(holderBox) || camera.method_23093(entityBox.method_991(holderBox));
            }
        }
        return fallback;
    }

    public boolean shouldRender(T entity, class_4604 camera, boolean isVisible) {
        return this.shouldRender(entity, camera, isVisible, isVisible);
    }

    public void render(T entity, float partialTick, class_4587 poseStack, class_4597 buffer) {
        this.setupLeashRendering(entity, partialTick);
        if (this.leashStates != null) {
            for (LeashState state : this.leashStates) {
                this.renderLeash(poseStack, buffer, state);
            }
        }
    }

    private void renderLeash(class_4587 stack, class_4597 buffer, LeashState state) {
        int segment;
        float deltaX = (float)(state.end.field_1352 - state.start.field_1352);
        float deltaY = (float)(state.end.field_1351 - state.start.field_1351);
        float deltaZ = (float)(state.end.field_1350 - state.start.field_1350);
        float scaleFactor = class_3532.method_48119((float)(deltaX * deltaX + deltaZ * deltaZ)) * 0.05f / 2.0f;
        float offsetZ = deltaZ * scaleFactor;
        float offsetX = deltaX * scaleFactor;
        stack.method_22903();
        stack.method_22904(state.offset.field_1352, state.offset.field_1351, state.offset.field_1350);
        class_4588 vertices = buffer.getBuffer(class_1921.method_23587());
        Matrix4f matrices = stack.method_23760().method_23761();
        for (segment = 0; segment <= 24; ++segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.05f, 0.05f, offsetZ, offsetX, segment, false, state);
        }
        for (segment = 24; segment >= 0; --segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.05f, 0.0f, offsetZ, offsetX, segment, true, state);
        }
        stack.method_22909();
    }

    private static void addVertexPair(class_4588 vertices, Matrix4f matrices, float deltaX, float deltaY, float deltaZ, float thickness1, float thickness2, float offsetZ, float offsetX, int segment, boolean isInnerFace, LeashState state) {
        float progress = (float)segment / 24.0f;
        int blockLight = (int)class_3532.method_16439((float)progress, (float)state.startBlockLight, (float)state.endBlockLight);
        int skyLight = (int)class_3532.method_16439((float)progress, (float)state.startSkyLight, (float)state.endSkyLight);
        int packedLight = class_765.method_23687((int)blockLight, (int)skyLight);
        float colorModifier = segment % 2 == (isInnerFace ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * colorModifier;
        float green = 0.4f * colorModifier;
        float blue = 0.3f * colorModifier;
        float posX = deltaX * progress;
        float posZ = deltaZ * progress;
        float posY = state.slack ? (deltaY > 0.0f ? deltaY * progress * progress : deltaY - deltaY * (1.0f - progress) * (1.0f - progress)) : deltaY * progress;
        vertices.method_22918(matrices, posX - offsetZ, posY + thickness2, posZ + offsetX).method_22915(red, green, blue, 1.0f).method_22916(packedLight).method_1344();
        vertices.method_22918(matrices, posX + offsetZ, posY + thickness1 - thickness2, posZ - offsetX).method_22915(red, green, blue, 1.0f).method_22916(packedLight).method_1344();
    }

    private void setupLeashRendering(T entity, float partialTicks) {
        if (!(entity instanceof Leashable)) {
            this.leashStates = null;
            return;
        }
        Leashable leashable = (Leashable)entity;
        class_1297 leashHolder = leashable.vb$getLeashHolder();
        if (leashHolder != null) {
            int leashCount;
            Leashable ext;
            float entityRotation = Leashable.vb$getPreciseBodyRotation(entity, partialTicks) * ((float)Math.PI / 180);
            class_243 leashOffset = entity.method_45321(partialTicks);
            class_2338 entityPos = class_2338.method_49638((class_2374)entity.method_5836(partialTicks));
            class_2338 holderPos = class_2338.method_49638((class_2374)leashHolder.method_5836(partialTicks));
            int entityBlockLight = this.getBlockLightLevel((class_1297)entity, entityPos);
            int holderBlockLight = this.getBlockLightLevel(leashHolder, holderPos);
            int entitySkyLight = entity.method_37908().method_8314(class_1944.field_9284, entityPos);
            int holderSkyLight = entity.method_37908().method_8314(class_1944.field_9284, holderPos);
            boolean handleHolderQuadLeash = leashHolder instanceof Leashable && (ext = (Leashable)leashHolder).vb$supportQuadLeashAsHolder();
            boolean handleQuadLeash = leashable.vb$supportQuadLeash();
            boolean useQuadLeash = handleHolderQuadLeash && handleQuadLeash;
            int n = leashCount = useQuadLeash ? 4 : 1;
            if (this.leashStates == null || this.leashStates.size() != leashCount) {
                this.leashStates = new ArrayList<LeashState>(leashCount);
                for (int i = 0; i < leashCount; ++i) {
                    this.leashStates.add(new LeashState());
                }
            }
            if (useQuadLeash) {
                float holderRotation = Leashable.vb$getPreciseBodyRotation(leashHolder, partialTicks) * ((float)Math.PI / 180);
                class_243 holderPosition = leashHolder.method_30950(partialTicks);
                class_243[] entityOffsets = leashable.vb$getQuadLeashOffsets();
                class_243[] holderOffsets = ((Leashable)leashHolder).vb$getQuadLeashHolderOffsets();
                for (int i = 0; i < leashCount; ++i) {
                    LeashState leashState = this.leashStates.get(i);
                    leashState.offset = entityOffsets[i].method_1024(-entityRotation);
                    leashState.start = entity.method_30950(partialTicks).method_1019(leashState.offset);
                    leashState.end = holderPosition.method_1019(holderOffsets[i].method_1024(-holderRotation));
                    leashState.startBlockLight = entityBlockLight;
                    leashState.endBlockLight = holderBlockLight;
                    leashState.startSkyLight = entitySkyLight;
                    leashState.endSkyLight = holderSkyLight;
                    leashState.slack = false;
                }
            } else {
                class_243 rotatedOffset = leashOffset.method_1024(-entityRotation);
                LeashState leashState = this.leashStates.get(0);
                leashState.offset = rotatedOffset;
                leashState.start = entity.method_30950(partialTicks).method_1019(rotatedOffset);
                leashState.end = leashHolder.method_30951(partialTicks);
                leashState.startBlockLight = entityBlockLight;
                leashState.endBlockLight = holderBlockLight;
                leashState.startSkyLight = entitySkyLight;
                leashState.endSkyLight = holderSkyLight;
            }
        } else {
            this.leashStates = null;
        }
    }

    private int getBlockLightLevel(class_1297 entity, class_2338 pos) {
        return ((EntityRendererAccessor)this.dispatcher.method_3953(entity)).callGetBlockLightLevel(entity, pos);
    }
}

