/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.entities;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.variant.SpawnContext;
import com.blackgear.vanillabackport.common.api.variant.VariantHolder;
import com.blackgear.vanillabackport.common.api.variant.VariantUtils;
import com.blackgear.vanillabackport.common.api.wolf.BackportedWolvesConversion;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariant;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariantHolder;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariants;
import com.blackgear.vanillabackport.common.level.entities.wolf.ModCrackiness;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfSoundVariantsModule;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariant;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariants;
import com.blackgear.vanillabackport.common.level.items.WolfArmorItem;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.mixin.common.entities.TamableAnimalMixin;
import com.blackgear.vanillabackport.core.registries.ModBuiltinRegistries;
import com.blackgear.vanillabackport.core.util.ColorUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1493.class})
public abstract class WolfMixin
extends TamableAnimalMixin
implements class_5354,
WolfSoundVariantHolder,
VariantHolder<WolfVariant> {
    @Unique
    private static final class_2940<String> DATA_SOUND_VARIANT_ID = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13326);
    @Unique
    private static final class_2940<String> DATA_VARIANT_ID = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13326);

    @Shadow
    public abstract class_1767 method_6713();

    protected WolfMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Wolf;"}, at={@At(value="RETURN")})
    private void vb$getBreedOffspring(class_3218 level, class_1296 otherParent, CallbackInfoReturnable<class_1493> cir) {
        class_1493 child = (class_1493)cir.getReturnValue();
        if (child != null && otherParent instanceof class_1493) {
            class_1493 mate = (class_1493)otherParent;
            if (this.method_6181()) {
                class_1767 fatherColor = this.method_6713();
                class_1767 motherColor = mate.method_6713();
                child.method_6708(ColorUtils.getMixedColor(level, fatherColor, motherColor));
            }
            WolfSoundVariantHolder.of(child).vb$setSoundVariant((WolfSoundVariant)ModBuiltinRegistries.WOLF_SOUND_VARIANTS.getRandomElement(this.method_6051()));
            VariantHolder.vb$trySetOffspringVariant((class_1309)child, this, (class_1309)mate);
        }
    }

    @Override
    public WolfVariant vb$getVariant() {
        return VariantUtils.getVariant(ModBuiltinRegistries.WOLF_VARIANTS, (String)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    @Override
    public void vb$setVariant(WolfVariant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)VariantUtils.getID(ModBuiltinRegistries.WOLF_VARIANTS, variant));
    }

    @Override
    public WolfSoundVariant vb$getSoundVariant() {
        return VariantUtils.getVariant(ModBuiltinRegistries.WOLF_SOUND_VARIANTS, (String)this.field_6011.method_12789(DATA_SOUND_VARIANT_ID));
    }

    @Override
    public void vb$setSoundVariant(WolfSoundVariant variant) {
        this.field_6011.method_12778(DATA_SOUND_VARIANT_ID, (Object)VariantUtils.getID(ModBuiltinRegistries.WOLF_SOUND_VARIANTS, variant));
    }

    @Override
    protected void vb$defineSynchedData(CallbackInfo ci) {
        this.field_6011.method_12784(DATA_SOUND_VARIANT_ID, (Object)VariantUtils.getDefaultID(ModBuiltinRegistries.WOLF_SOUND_VARIANTS, WolfSoundVariants.CLASSIC));
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultID(ModBuiltinRegistries.WOLF_VARIANTS, WolfVariants.PALE));
    }

    @Override
    protected void vb$addAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        VariantUtils.addVariantSaveData(this, tag, ModBuiltinRegistries.WOLF_VARIANTS);
        tag.method_10582("sound_variant", ModBuiltinRegistries.WOLF_SOUND_VARIANTS.getKey((Object)this.vb$getSoundVariant()).toString());
    }

    @Override
    protected void vb$readAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        BackportedWolvesConversion.migrateWolfVariant(this, tag, ModBuiltinRegistries.WOLF_VARIANTS);
        VariantUtils.readVariantSaveData(this, tag, ModBuiltinRegistries.WOLF_VARIANTS);
        WolfSoundVariant soundVariant = (WolfSoundVariant)ModBuiltinRegistries.WOLF_SOUND_VARIANTS.get(class_2960.method_12829((String)tag.method_10558("sound_variant")));
        if (soundVariant != null) {
            this.vb$setSoundVariant(soundVariant);
        }
    }

    @Override
    protected void vb$finalizeSpawn(class_5425 level, class_1266 difficulty, class_3730 reason, class_1315 spawnData, class_2487 dataTag, CallbackInfoReturnable<class_1315> cir) {
        this.vb$setSoundVariant((WolfSoundVariant)ModBuiltinRegistries.WOLF_SOUND_VARIANTS.getRandomElement(level.method_8409()));
        VariantUtils.selectWolfVariantToSpawn(SpawnContext.create(level, this.method_24515()), ModBuiltinRegistries.WOLF_VARIANTS, WolfVariants.PALE).ifPresent(this::vb$setVariant);
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void vb$getAmbientSound(CallbackInfoReturnable<class_3414> cir) {
        class_3414 result = WolfSoundVariantsModule.getAmbientSound((class_1493)this);
        if (result != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$getHurtSound(class_1282 source, CallbackInfoReturnable<class_3414> cir) {
        class_3414 result;
        if (this.canArmorAbsorb(source)) {
            cir.setReturnValue((Object)ModSoundEvents.WOLF_ARMOR_DAMAGE.get());
        }
        if ((result = WolfSoundVariantsModule.getHurtSound((class_1493)this)) != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$getDeathSound(CallbackInfoReturnable<class_3414> cir) {
        class_3414 result = WolfSoundVariantsModule.getDeathSound((class_1493)this);
        if (result != null) {
            cir.setReturnValue((Object)result);
        }
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        if (!this.canArmorAbsorb(damageSource)) {
            super.method_6074(damageSource, damageAmount);
        } else {
            class_1799 stack = this.method_6118(class_1304.field_6174);
            int i = stack.method_7919();
            int j = stack.method_7936();
            stack.method_7956(class_3532.method_15386((float)damageAmount), (class_1309)this, wolf -> wolf.method_20235(class_1304.field_6174));
            if (ModCrackiness.WOLF_ARMOR.byDamage(i, j) != ModCrackiness.WOLF_ARMOR.byDamage(this.method_6118(class_1304.field_6174))) {
                this.method_43077(ModSoundEvents.WOLF_ARMOR_CRACK.get());
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 level = (class_3218)class_19372;
                    level.method_14199((class_2394)new class_2392(class_2398.field_11218, ModItems.ARMADILLO_SCUTE.get().method_7854()), this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 20, 0.2, 0.1, 0.2, 0.1);
                }
            }
        }
    }

    @Unique
    private boolean canArmorAbsorb(class_1282 source) {
        return this.hasArmor() && !source.method_48789(class_8103.field_42241);
    }

    protected void method_6105(class_1282 damageSource, float damageAmount) {
        if (damageAmount > 0.0f) {
            int i = (int)Math.max(1.0f, damageAmount / 4.0f);
            class_1799 stack = this.method_6118(class_1304.field_6174);
            if (stack.method_7909() instanceof WolfArmorItem) {
                stack.method_7956(i, (class_1309)this, wolf -> wolf.method_20235(class_1304.field_6174));
            }
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$mobInteract(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 stack = player.method_5998(hand);
        if (!this.method_37908().field_9236 && this.method_6181()) {
            class_1799 armor;
            if (stack.method_31574(ModItems.WOLF_ARMOR.get()) && this.method_6171((class_1309)player) && this.method_6118(class_1304.field_6174).method_7960() && !this.method_6109()) {
                this.method_5673(class_1304.field_6174, stack.method_46651(1));
                this.method_43077(ModSoundEvents.ARMOR_EQUIP_WOLF.get());
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                cir.setReturnValue((Object)class_1269.field_5812);
            } else if (stack.method_31574(class_1802.field_8868) && this.method_6171((class_1309)player) && this.hasArmor() && (!class_1890.method_8224((class_1799)this.method_6118(class_1304.field_6174)) || player.method_7337())) {
                stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                this.method_43077(ModSoundEvents.ARMOR_UNEQUIP_WOLF.get());
                class_1799 armor2 = this.method_6118(class_1304.field_6174);
                this.method_5673(class_1304.field_6174, class_1799.field_8037);
                this.method_5775(armor2);
                cir.setReturnValue((Object)class_1269.field_5812);
            } else if (stack.method_31574(ModItems.ARMADILLO_SCUTE.get()) && this.method_6172() && this.hasArmor() && this.method_6171((class_1309)player) && (armor = this.method_6118(class_1304.field_6174)).method_7986()) {
                int repair = class_3532.method_15386((float)((float)armor.method_7936() * 0.125f));
                int current = armor.method_7919();
                int newDamage = Math.max(0, current - repair);
                if (newDamage < current) {
                    armor.method_7974(newDamage);
                    this.method_43077(ModSoundEvents.WOLF_ARMOR_REPAIR.get());
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    cir.setReturnValue((Object)class_1269.field_5812);
                }
            }
        }
    }

    @Unique
    private boolean hasArmor() {
        return this.method_6118(class_1304.field_6174).method_31574(ModItems.WOLF_ARMOR.get());
    }
}

