/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util.codec;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7876;

public class HolderSetCodec<E>
implements Codec<class_6885<E>> {
    private final class_5321<? extends class_2378<E>> registryKey;
    private final Codec<class_6880<E>> elementCodec;
    private final Codec<List<class_6880<E>>> homogenousListCodec;
    private final Codec<Either<class_6862<E>, List<class_6880<E>>>> registryAwareCodec;

    private static <E> Codec<List<class_6880<E>>> homogenousList(Codec<class_6880<E>> elementCodec, boolean disallowInline) {
        Codec codec = class_5699.method_48112((Codec)elementCodec.listOf(), (Function)class_5699.method_40114(class_6880::method_40231));
        return disallowInline ? codec : Codec.either((Codec)codec, elementCodec).xmap(either -> (List)either.map(list -> list, List::of), list -> list.size() == 1 ? Either.right((Object)((class_6880)list.get(0))) : Either.left((Object)list));
    }

    public static <E> Codec<class_6885<E>> create(class_5321<? extends class_2378<E>> registryKey, Codec<class_6880<E>> elementCodec, boolean disallowInline) {
        return new HolderSetCodec<E>(registryKey, elementCodec, disallowInline);
    }

    private HolderSetCodec(class_5321<? extends class_2378<E>> registryKey, Codec<class_6880<E>> elementCodec, boolean disallowInline) {
        this.registryKey = registryKey;
        this.elementCodec = elementCodec;
        this.homogenousListCodec = HolderSetCodec.homogenousList(elementCodec, disallowInline);
        this.registryAwareCodec = Codec.either((Codec)class_6862.method_40093(registryKey), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<class_6885<E>, T>> decode(DynamicOps<T> ops, T input) {
        class_6903 registryOps;
        Optional optional;
        if (ops instanceof class_6903 && (optional = (registryOps = (class_6903)ops).method_46634(this.registryKey)).isPresent()) {
            class_7871 holderGetter = (class_7871)optional.get();
            return this.registryAwareCodec.decode(ops, input).flatMap(pair -> {
                DataResult dataResult = (DataResult)((Either)pair.getFirst()).map(tagKey -> HolderSetCodec.lookupTag(holderGetter, tagKey), list -> DataResult.success((Object)class_6885.method_40242((List)list)));
                return dataResult.map(holderSet -> Pair.of((Object)holderSet, (Object)pair.getSecond()));
            });
        }
        return this.decodeWithoutRegistry(ops, input);
    }

    private static <E> DataResult<class_6885<E>> lookupTag(class_7871<E> holderGetter, class_6862<E> tagKey) {
        return holderGetter.method_46733(tagKey).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(tagKey.comp_327()) + "' in '" + String.valueOf(tagKey.comp_326().method_29177()) + "'"));
    }

    public <T> DataResult<T> encode(class_6885<E> input, DynamicOps<T> ops, T prefix) {
        class_6903 registryOps;
        Optional optional;
        if (ops instanceof class_6903 && (optional = (registryOps = (class_6903)ops).method_46628(this.registryKey)).isPresent()) {
            if (!input.method_46768((class_7876)optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(input) + " is not valid in current registry set");
            }
            return this.registryAwareCodec.encode((Object)input.method_40248().mapRight(List::copyOf), ops, prefix);
        }
        return this.encodeWithoutRegistry(input, ops, prefix);
    }

    private <T> DataResult<Pair<class_6885<E>, T>> decodeWithoutRegistry(DynamicOps<T> dynamicOps, T object) {
        return this.elementCodec.listOf().decode(dynamicOps, object).flatMap(pair -> {
            ArrayList<class_6880.class_6881> list = new ArrayList<class_6880.class_6881>();
            for (class_6880 holder : (List)pair.getFirst()) {
                if (!(holder instanceof class_6880.class_6881)) {
                    return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
                }
                class_6880.class_6881 direct = (class_6880.class_6881)holder;
                list.add(direct);
            }
            return DataResult.success((Object)new Pair((Object)class_6885.method_40242(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(class_6885<E> holderSet, DynamicOps<T> dynamicOps, T object) {
        return this.homogenousListCodec.encode(holderSet.method_40239().toList(), dynamicOps, object);
    }
}

