/*
 * Decompiled with CFR 0.152.
 */
package me.drex.vanish.api;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import me.drex.vanish.util.VanishManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public interface VanishAPI {
    public static boolean isVanished(@NotNull class_1297 entity) {
        return VanishManager.isVanished(entity);
    }

    public static boolean isVanished(@NotNull MinecraftServer server, @NotNull UUID uuid) {
        return VanishManager.isVanished(server, uuid);
    }

    public static boolean setVanish(@NotNull class_3222 player, boolean status) {
        return VanishManager.setVanished(player.method_7334(), player.field_13995, status);
    }

    public static boolean canSeePlayer(@NotNull class_3222 actor, @NotNull class_3222 observer) {
        return VanishManager.canSeePlayer(actor, observer.method_5671());
    }

    public static boolean canSeePlayer(@NotNull MinecraftServer server, @NotNull UUID uuid, @NotNull class_3222 observer) {
        return VanishAPI.canSeePlayer(server, uuid, observer.method_5671());
    }

    public static boolean canSeePlayer(@NotNull MinecraftServer server, @NotNull UUID uuid, @NotNull class_2168 observer) {
        return VanishManager.canSeePlayer(server, uuid, observer);
    }

    public static boolean canViewVanished(class_2172 observer) {
        return VanishManager.canViewVanished(observer);
    }

    @NotNull
    public static List<class_3222> getVisiblePlayers(@NotNull class_2168 observer) {
        MinecraftServer server = observer.method_9211();
        ObjectArrayList list = new ObjectArrayList();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!VanishManager.canSeePlayer(player, observer)) continue;
            list.add((Object)player);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<class_3222> getViewingPlayers(@NotNull class_3222 actor) {
        ObjectArrayList list = new ObjectArrayList();
        for (class_3222 observer : actor.field_13995.method_3760().method_14571()) {
            if (!VanishAPI.canSeePlayer(actor, observer)) continue;
            list.add((Object)observer);
        }
        return list;
    }

    public static void broadcastHiddenMessage(@NotNull class_3222 actor, @NotNull class_2561 message) {
        class_5250 component = message.method_27661();
        component.method_10852((class_2561)class_2561.method_43471((String)"text.vanish.chat.hidden").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        for (class_3222 observer : actor.field_13995.method_3760().method_14571()) {
            if (!VanishAPI.canSeePlayer(actor, observer)) continue;
            observer.method_43496((class_2561)component);
        }
    }

    public static void sendHiddenMessage(@NotNull class_3222 actor, @NotNull class_3222 observer, @NotNull class_2561 message) {
        class_5250 component = message.method_27661();
        component.method_10852((class_2561)class_2561.method_43471((String)"text.vanish.chat.hidden").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        if (VanishAPI.canSeePlayer(actor, observer)) {
            observer.method_43496((class_2561)component);
        }
    }
}

